package com.seeq.link.sdk;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * Default configuration for user group synchronization.
 * It may be used as is in the connector configuration or it may be extended if the connector needs additional
 * attributes
 */
@Data
@EqualsAndHashCode
@ToString(callSuper = true)
public class DefaultIdentitySynchronizationConfig {
    private boolean enabled;

    @Nullable
    private List<String> groupsToSync;

    @JsonIgnore
    public Set<String> getGroupsToSyncSet() {
        return this.groupsToSync == null ? Collections.emptySet() : ImmutableSet.copyOf(this.groupsToSync);
    }
}
