package com.seeq.link.sdk;

import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * Provides the ConfigObject and its metadata (needed by ConfigService to decide what configuration to use)
 */
@Data
@AllArgsConstructor
public class ConfigObjectWrapper {
    private ConfigObject configObject;
    private Long lastModified;

    /**
     * Returns true if this ConfigObjectWrapper is not a default configuration and it is newer than the
     * ConfigObjectWrapper sent as parameter.
     */
    public boolean persistentAndNewerThan(ConfigObjectWrapper otherConfigWrapper) {
        if (this.lastModified == null) {
            return false;
        }

        if (otherConfigWrapper.lastModified == null) {
            return true;
        }

        return this.lastModified > otherConfigWrapper.lastModified;
    }
}