/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.math.LongMath;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class TimeInstant {
    private final long timestamp;
    public static final TimeInstant MIN = new TimeInstant(Long.MIN_VALUE);
    public static Pattern ISO_TIMESTAMP_REGEX = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(\\.(\\d+))?Z");

    public TimeInstant(long timestamp) {
        this.timestamp = timestamp;
    }

    public TimeInstant(ZonedDateTime dateTime) {
        this.timestamp = this.getNanosecondsSinceUnixEpoch(dateTime);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private long getNanosecondsSinceUnixEpoch(ZonedDateTime dateTime) {
        ZonedDateTime unixEpoch = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
        if (!dateTime.getZone().equals(ZoneId.of("UTC"))) {
            dateTime = dateTime.withZoneSameInstant(ZoneId.of("UTC"));
        }
        Duration duration = Duration.between(unixEpoch, dateTime);
        return duration.get(ChronoUnit.SECONDS) * 1000000000L + duration.get(ChronoUnit.NANOS);
    }

    public ZonedDateTime toDateTime() {
        ZonedDateTime returnValue = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
        returnValue = returnValue.plusNanos(this.timestamp);
        return returnValue;
    }

    public static ZonedDateTime timestampToDateTime(long timestamp) {
        TimeInstant instant = new TimeInstant(timestamp);
        return instant.toDateTime();
    }

    public static long dateTimeToTimestamp(ZonedDateTime dateTime) {
        TimeInstant instant = new TimeInstant(dateTime);
        return instant.getTimestamp();
    }

    public static long dateTimeToTimestamp(LocalDateTime dateTime) {
        TimeInstant instant = new TimeInstant(dateTime.atZone(ZoneId.of("UTC")));
        return instant.getTimestamp();
    }

    public TimeInstant roundUp(long multiple_ns) {
        return new TimeInstant(TimeInstant.roundTimestampUp(this.timestamp, multiple_ns));
    }

    public static long roundTimestampUp(long timestamp, long multiple) {
        if (timestamp < 0L) {
            return TimeInstant.roundDown(timestamp, multiple);
        }
        return TimeInstant.roundUp(timestamp, multiple);
    }

    private static long roundUp(long timestamp, long multiple) {
        long delta = multiple - 1L;
        if (timestamp < 0L) {
            delta = -delta;
        }
        if (timestamp % multiple != 0L) {
            return (timestamp + delta) / multiple * multiple;
        }
        return timestamp;
    }

    public TimeInstant roundDown(long multiple_ns) {
        return new TimeInstant(TimeInstant.roundTimestampDown(this.timestamp, multiple_ns));
    }

    public TimeInstant decrement() {
        return new TimeInstant(LongMath.checkedSubtract((long)this.timestamp, (long)1L));
    }

    public TimeInstant increment() {
        return new TimeInstant(LongMath.checkedAdd((long)this.timestamp, (long)1L));
    }

    public static long roundTimestampDown(long timestamp, long multiple) {
        if (timestamp < 0L) {
            return TimeInstant.roundUp(timestamp, multiple);
        }
        return TimeInstant.roundDown(timestamp, multiple);
    }

    private static long roundDown(long timestamp, long multiple) {
        if (timestamp % multiple != 0L) {
            return timestamp / multiple * multiple;
        }
        return timestamp;
    }

    public String toString() {
        return this.toDateTime().format(DateTimeFormatter.ISO_INSTANT);
    }

    public static TimeInstant parseIso(String str) {
        Matcher match = ISO_TIMESTAMP_REGEX.matcher(str);
        if (!match.matches()) {
            throw new IllegalArgumentException("ISO timestamp string not recognized, must be in format 2021-02-14T15:23:54.384758575Z");
        }
        ZonedDateTime dateTime = ZonedDateTime.parse(str);
        return new TimeInstant(dateTime);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeInstant)) {
            return false;
        }
        TimeInstant other = (TimeInstant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeInstant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }
}

