/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.base.Stopwatch;
import com.seeq.link.sdk.interfaces.Connection;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateChangeAccumulator {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(StateChangeAccumulator.class);
    public Duration timeout = Duration.ofSeconds(50L);
    private final Queue<Connection.ConnectionState> stateChangeQueue = new LinkedList<Connection.ConnectionState>();

    public StateChangeAccumulator() {
    }

    public StateChangeAccumulator(Duration timeout) {
        this.timeout = timeout;
    }

    public boolean confirmStateChange(Connection.ConnectionState requiredState) {
        Stopwatch generalTimeout = Stopwatch.createStarted();
        while (this.stateChangeQueue.isEmpty()) {
            if (generalTimeout.elapsed(TimeUnit.SECONDS) > this.timeout.getSeconds()) {
                LOG.error("Timed out waiting for state change to '{}'", (Object)requiredState);
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        Connection.ConnectionState newState = this.stateChangeQueue.poll();
        if (requiredState == newState) {
            return true;
        }
        String remainingInQueue = "";
        if (this.stateChangeQueue.peek() != null) {
            Connection.ConnectionState remaining;
            remainingInQueue = "[Next state change(s) detected:";
            while ((remaining = this.stateChangeQueue.poll()) != null) {
                remainingInQueue = remainingInQueue + String.format(" '%s'", remaining.toString());
            }
            remainingInQueue = remainingInQueue + "]";
        }
        LOG.error("State change mismatch. Expected '{}', instead was '{}'. {}", new Object[]{requiredState, newState, remainingInQueue});
        return false;
    }

    public void stateChanged(Connection sender, Connection.ConnectionState state, String message) {
        this.stateChangeQueue.add(state);
    }
}

