/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;

public final class Markdown {
    private static final MutableDataHolder MARKDOWN_OPTIONS = new MutableDataSet().set(HtmlRenderer.RENDER_HEADER_ID, (Object)true).set(Parser.EXTENSIONS, Collections.singletonList(TocExtension.create()));

    private Markdown() {
    }

    public static String compileMarkdownToStyledHtml(String markdown) {
        try {
            String html = Markdown.compileMarkdownToHtml(markdown);
            String css = Resources.toString((URL)Resources.getResource((String)"markdown.css"), (Charset)Charsets.UTF_8);
            html = "<head><style>\n" + css + "\n</style></head>\n<article class=\"markdown-body\">\n" + html + "</article>";
            return html;
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error resolving the markdown css file");
        }
    }

    public static String compileMarkdownToHtml(String markdown) {
        Parser parser = Parser.builder((DataHolder)MARKDOWN_OPTIONS).build();
        Node document = parser.parse(markdown);
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)MARKDOWN_OPTIONS).build();
        return renderer.render(document);
    }
}

