/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.seeq.link.sdk.interfaces.ConcurrentRequestsHandler;
import com.seeq.link.sdk.utilities.ThreadCollection;
import com.seeq.utilities.ManualResetEvent;
import com.seeq.utilities.exception.OperationCanceledException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConcurrentRequestsHandler
implements ConcurrentRequestsHandler {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConcurrentRequestsHandler.class);
    private final AtomicInteger currentConcurrentRequests = new AtomicInteger(0);
    private final int maxConcurrentRequests;
    private final Semaphore concurrentRequestsSemaphore;

    public DefaultConcurrentRequestsHandler(int maxConcurrentRequests) {
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"Max concurrent requests should be at least 1");
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.concurrentRequestsSemaphore = new Semaphore(this.maxConcurrentRequests);
    }

    @Override
    public Thread runWhenPermitted(Runnable request, ThreadCollection threadCollection, long timeoutMillis, long requestId, ManualResetEvent requestThreadStartedEvent) {
        int registeredRequests = this.registerRequest();
        int maxConcurrentRequests = this.getMaxConcurrentRequests();
        int overflowRequests = registeredRequests - maxConcurrentRequests;
        return threadCollection.spawn(() -> {
            LOG.debug("Received concurrent request with Id {}, {} work thread. {} work thread(s) running. {} work thread(s) queued. Request timeout {}ms", new Object[]{requestId, overflowRequests > 0 ? "queuing" : "spawning", Math.min(registeredRequests, maxConcurrentRequests), Math.max(0, overflowRequests), timeoutMillis});
            try {
                LOG.debug("Acquiring execution permit for request with Id {}", (Object)requestId);
                this.acquireProcessingPermit(requestThreadStartedEvent);
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
            try {
                LOG.debug("Running request with Id {}", (Object)requestId);
                request.run();
            }
            finally {
                LOG.debug("Releasing execution permit for request with Id {}", (Object)requestId);
                this.releaseProcessingPermit();
            }
        }, timeoutMillis, requestId);
    }

    @Override
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public int getRegisteredRequestsCount() {
        return this.currentConcurrentRequests.get();
    }

    @VisibleForTesting
    int registerRequest() {
        return this.currentConcurrentRequests.incrementAndGet();
    }

    @VisibleForTesting
    void acquireProcessingPermit(ManualResetEvent beforeAcquireEvent) throws InterruptedException {
        try {
            beforeAcquireEvent.set();
            this.concurrentRequestsSemaphore.acquire();
        }
        catch (InterruptedException e) {
            this.currentConcurrentRequests.decrementAndGet();
            throw e;
        }
    }

    @VisibleForTesting
    int releaseProcessingPermit() {
        this.concurrentRequestsSemaphore.release();
        return this.currentConcurrentRequests.decrementAndGet();
    }
}

