/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.seeq.link.sdk.utilities.Stopwatch;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class BatchSizeHelper {
    private final Stopwatch stopwatch;
    private int currentSize;
    private int lastSize;
    private Duration lastDuration = Duration.ZERO;
    private final Duration maximumDuration;

    public BatchSizeHelper(int initialSize, Duration maximumDuration) {
        this(initialSize, maximumDuration, new Stopwatch());
    }

    public BatchSizeHelper(int initialSize, Duration maximumDuration, Stopwatch stopwatch) {
        this.currentSize = initialSize;
        this.maximumDuration = maximumDuration;
        this.stopwatch = stopwatch;
    }

    public void start() {
        this.stopwatch.restart();
    }

    public void stop() {
        this.stop(this.currentSize);
    }

    public void stop(int actualSize) {
        this.stopwatch.stop();
        Duration headroom = this.maximumDuration.minus(Duration.ofMillis(this.stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        this.lastSize = actualSize;
        this.lastDuration = Duration.ofMillis(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        double itemsPerMillisecond = (double)actualSize / (double)this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        double newSize = (double)this.currentSize + (double)headroom.toMillis() * itemsPerMillisecond;
        double MaximumGrowthFactor = 5.0;
        double MaximumShrinkFactor = 0.2;
        if (newSize > (double)this.lastSize * 5.0) {
            newSize = (double)this.lastSize * 5.0;
        } else if (newSize < (double)this.lastSize * 0.2) {
            newSize = (double)this.lastSize * 0.2;
        }
        this.stopwatch.reset();
        this.currentSize = Math.max(1, (int)newSize);
    }

    public int getBatchSize() {
        return this.currentSize;
    }

    public Duration getLastDuration() {
        return this.lastDuration;
    }

    public double getLastItemsPerSecond() {
        return (double)this.lastSize / ((double)this.lastDuration.toMillis() / 1000.0);
    }
}

