/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.seeq.link.sdk.services.PropertyTransformer;
import com.seeq.link.sdk.services.Transformable;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.model.SignalWithIdInputV1;
import java.util.ArrayList;
import java.util.List;

class TransformableSignal
implements Transformable<SignalWithIdInputV1> {
    private final SignalWithIdInputV1 input;

    public TransformableSignal() {
        this.input = new SignalWithIdInputV1();
    }

    public TransformableSignal(SignalWithIdInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<SignalWithIdInputV1> copy() {
        TransformableSignal output = new TransformableSignal();
        String[] properties = new String[]{"Data ID", "Datasource Class", "Datasource ID", "Data Version Check", "Description", "Formula", "FormulaParameters", "Interpolation Method", "Key Unit Of Measure", "Maximum Interpolation", "Name", "Scoped To", "Sync Token", "Value Unit Of Measure", "Number Format", "Source Security String", "Security String"};
        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }
        if (this.input.getAdditionalProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getAdditionalProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }
        return output;
    }

    @Override
    public SignalWithIdInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals("Type")) {
            return "Signal";
        }
        if (propertyName.equals("Data ID")) {
            return this.input.getDataId();
        }
        if (propertyName.equals("Datasource Class")) {
            return this.input.getDatasourceClass();
        }
        if (propertyName.equals("Datasource ID")) {
            return this.input.getDatasourceId();
        }
        if (propertyName.equals("Data Version Check")) {
            return this.input.getDataVersionCheck();
        }
        if (propertyName.equals("Description")) {
            return this.input.getDescription();
        }
        if (propertyName.equals("Formula")) {
            return this.input.getFormula();
        }
        if (propertyName.equals("FormulaParameters")) {
            return this.input.getFormulaParameters();
        }
        if (propertyName.equals("Interpolation Method")) {
            return this.input.getInterpolationMethod();
        }
        if (propertyName.equals("Key Unit Of Measure")) {
            return this.input.getKeyUnitOfMeasure();
        }
        if (propertyName.equals("Maximum Interpolation")) {
            return this.input.getMaximumInterpolation();
        }
        if (propertyName.equals("Name")) {
            return this.input.getName();
        }
        if (propertyName.equals("Scoped To")) {
            return this.input.getScopedTo();
        }
        if (propertyName.equals("Sync Token")) {
            return this.input.getSyncToken();
        }
        if (propertyName.equals("Value Unit Of Measure")) {
            return this.input.getValueUnitOfMeasure();
        }
        if (propertyName.equals("Number Format")) {
            return this.input.getNumberFormat();
        }
        if (propertyName.equals("Source Security String")) {
            return this.input.getSourceSecurityString();
        }
        if (propertyName.equals("Security String")) {
            return this.input.getSecurityString();
        }
        if (this.input.getAdditionalProperties() == null) {
            return null;
        }
        ScalarPropertyV1 property = this.input.getAdditionalProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null);
        return property == null ? null : property.getValue();
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals("Data ID")) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Datasource Class")) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Datasource ID")) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Data Version Check")) {
            this.input.setDataVersionCheck(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Description")) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Formula")) {
            this.input.setFormula(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("FormulaParameters")) {
            List parameterList = (List)propertyValue;
            this.input.setFormulaParameters(parameterList);
        } else if (propertyName.equals("Interpolation Method")) {
            this.input.setInterpolationMethod(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Key Unit Of Measure")) {
            this.input.setKeyUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Maximum Interpolation")) {
            if (unitOfMeasure != null && !(propertyValue instanceof String)) {
                propertyValue = PropertyTransformer.toStr(propertyValue) + PropertyTransformer.toStr(unitOfMeasure);
            }
            this.input.setMaximumInterpolation(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Name")) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Scoped To")) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Sync Token")) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Value Unit Of Measure")) {
            this.input.setValueUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Number Format")) {
            this.input.setNumberFormat(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Source Security String")) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Security String")) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else {
            ScalarPropertyV1 property;
            if (this.input.getAdditionalProperties() == null) {
                this.input.setAdditionalProperties(new ArrayList());
            }
            if ((property = (ScalarPropertyV1)this.input.getAdditionalProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null)) == null) {
                property = new ScalarPropertyV1();
                this.input.addAdditionalPropertiesItem(property);
            }
            property.setName(propertyName);
            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    public String toString() {
        return String.format("Signal(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}

