/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.seeq.link.sdk.services.PropertyTransformer;
import com.seeq.link.sdk.services.Transformable;
import com.seeq.model.ConditionInputV1;
import com.seeq.model.ScalarPropertyV1;
import java.util.ArrayList;
import java.util.List;

public class TransformableCondition
implements Transformable<ConditionInputV1> {
    private final ConditionInputV1 input;

    public TransformableCondition() {
        this.input = new ConditionInputV1();
    }

    public TransformableCondition(ConditionInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<ConditionInputV1> copy() {
        TransformableCondition output = new TransformableCondition();
        String[] properties = new String[]{"Data ID", "Datasource Class", "Datasource ID", "Data Version Check", "Description", "Formula", "FormulaParameters", "Maximum Duration", "Unit Of Measure", "Name", "Scoped To", "Sync Token", "Source Security String", "Security String"};
        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }
        if (this.input.getProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }
        return output;
    }

    @Override
    public ConditionInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals("Type")) {
            return "Condition";
        }
        if (propertyName.equals("Data ID")) {
            return this.input.getDataId();
        }
        if (propertyName.equals("Datasource Class")) {
            return this.input.getDatasourceClass();
        }
        if (propertyName.equals("Datasource ID")) {
            return this.input.getDatasourceId();
        }
        if (propertyName.equals("Data Version Check")) {
            return this.input.getDataVersionCheck();
        }
        if (propertyName.equals("Description")) {
            return this.input.getDescription();
        }
        if (propertyName.equals("Formula")) {
            return this.input.getFormula();
        }
        if (propertyName.equals("FormulaParameters")) {
            return this.input.getParameters();
        }
        if (propertyName.equals("Unit Of Measure")) {
            return this.input.getUnitOfMeasure();
        }
        if (propertyName.equals("Maximum Duration")) {
            return this.input.getMaximumDuration();
        }
        if (propertyName.equals("Name")) {
            return this.input.getName();
        }
        if (propertyName.equals("Scoped To")) {
            return this.input.getScopedTo();
        }
        if (propertyName.equals("Sync Token")) {
            return this.input.getSyncToken();
        }
        if (propertyName.equals("Source Security String")) {
            return this.input.getSourceSecurityString();
        }
        if (propertyName.equals("Security String")) {
            return this.input.getSecurityString();
        }
        if (this.input.getProperties() == null) {
            return null;
        }
        ScalarPropertyV1 property = this.input.getProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null);
        return property == null ? null : property.getValue();
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals("Data ID")) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Datasource Class")) {
            this.input.setDatasourceClass(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Datasource ID")) {
            this.input.setDatasourceId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Data Version Check")) {
            this.input.setDataVersionCheck(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Description")) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Formula")) {
            this.input.setFormula(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("FormulaParameters")) {
            List parameterList = (List)propertyValue;
            this.input.setParameters(parameterList);
        } else if (propertyName.equals("Unit Of Measure")) {
            this.input.setUnitOfMeasure(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Maximum Duration")) {
            if (unitOfMeasure != null && !(propertyValue instanceof String)) {
                propertyValue = PropertyTransformer.toStr(propertyValue) + PropertyTransformer.toStr(unitOfMeasure);
            }
            this.input.setMaximumDuration(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Name")) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Scoped To")) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Sync Token")) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Source Security String")) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Security String")) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else {
            ScalarPropertyV1 property;
            if (this.input.getProperties() == null) {
                this.input.setProperties(new ArrayList());
            }
            if ((property = (ScalarPropertyV1)this.input.getProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null)) == null) {
                property = new ScalarPropertyV1();
                this.input.addPropertiesItem(property);
            }
            property.setName(propertyName);
            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    public String toString() {
        return String.format("Condition(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}

