/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.seeq.link.sdk.services.PropertyTransformer;
import com.seeq.link.sdk.services.Transformable;
import com.seeq.model.AssetInputV1;
import com.seeq.model.ScalarPropertyV1;
import java.util.ArrayList;

public class TransformableAsset
implements Transformable<AssetInputV1> {
    private final AssetInputV1 input;

    public TransformableAsset() {
        this.input = new AssetInputV1();
    }

    public TransformableAsset(AssetInputV1 input) {
        this.input = input;
    }

    @Override
    public Transformable<AssetInputV1> copy() {
        TransformableAsset output = new TransformableAsset();
        String[] properties = new String[]{"Data ID", "Description", "Name", "Scoped To", "Sync Token", "Security String", "Source Security String"};
        for (String property : properties) {
            output.setProperty(property, this.getProperty(property));
        }
        if (this.input.getProperties() != null) {
            for (ScalarPropertyV1 inputProperty : this.input.getProperties()) {
                output.setProperty(inputProperty.getName(), inputProperty.getValue(), inputProperty.getUnitOfMeasure());
            }
        }
        return output;
    }

    @Override
    public AssetInputV1 getInputObject() {
        return this.input;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals("Type")) {
            return "Asset";
        }
        if (propertyName.equals("Data ID")) {
            return this.input.getDataId();
        }
        if (propertyName.equals("Description")) {
            return this.input.getDescription();
        }
        if (propertyName.equals("Name")) {
            return this.input.getName();
        }
        if (propertyName.equals("Scoped To")) {
            return this.input.getScopedTo();
        }
        if (propertyName.equals("Sync Token")) {
            return this.input.getSyncToken();
        }
        if (propertyName.equals("Source Security String")) {
            return this.input.getSourceSecurityString();
        }
        if (propertyName.equals("Security String")) {
            return this.input.getSecurityString();
        }
        if (this.input.getProperties() == null) {
            return null;
        }
        ScalarPropertyV1 property = this.input.getProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null);
        return property == null ? null : property.getValue();
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        this.setProperty(propertyName, propertyValue, null);
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue, String unitOfMeasure) {
        if (propertyName.equals("Data ID")) {
            this.input.setDataId(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Description")) {
            this.input.setDescription(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Name")) {
            this.input.setName(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Scoped To")) {
            this.input.setScopedTo(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Sync Token")) {
            this.input.setSyncToken(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Source Security String")) {
            this.input.setSourceSecurityString(PropertyTransformer.toStr(propertyValue));
        } else if (propertyName.equals("Security String")) {
            this.input.setSecurityString(PropertyTransformer.toStr(propertyValue));
        } else {
            ScalarPropertyV1 property;
            if (this.input.getProperties() == null) {
                this.input.setProperties(new ArrayList());
            }
            if ((property = (ScalarPropertyV1)this.input.getProperties().stream().filter(s -> s.getName().equals(propertyName)).findFirst().orElse(null)) == null) {
                property = new ScalarPropertyV1();
                this.input.addPropertiesItem(property);
            }
            property.setName(propertyName);
            property.setValue(propertyValue);
            property.setUnitOfMeasure(unitOfMeasure);
        }
    }

    public String toString() {
        return String.format("Asset(name = %s, dataId = %s)", this.input.getName(), this.input.getDataId());
    }
}

