/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.ConfigObjectWrapper;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;

public class JsonConfigObjectMapper {
    private final ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy((PropertyNamingStrategy)new PascalCaseNamingStrategy()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public ConfigObjectWrapper toConfigObjectWrapper(String jsonString, ConfigObject[] defaultConfigObjects, String parseErrorMessage, Long lastModified) throws IOException {
        ConfigObject configObject = null;
        if (jsonString != null) {
            for (ConfigObject defaultConfigObject : defaultConfigObjects) {
                try {
                    configObject = (ConfigObject)this.objectMapper.readValue(jsonString, defaultConfigObject.getClass());
                }
                catch (JsonProcessingException e) {
                    String msg = parseErrorMessage;
                    if (e.getLocation() != null) {
                        msg = msg + String.format(" at line %d, column %d. ", e.getLocation().getLineNr(), e.getLocation().getColumnNr());
                    }
                    if (e.getOriginalMessage() != null) {
                        msg = msg + "Details: " + e.getOriginalMessage() + ". ";
                    }
                    if (e instanceof MismatchedInputException) {
                        MismatchedInputException mismatchedException = (MismatchedInputException)e;
                        String path = mismatchedException.getPath().stream().map(JsonMappingException.Reference::getFieldName).filter(Objects::nonNull).collect(Collectors.joining("/"));
                        msg = msg + "Path: " + path;
                    }
                    throw new IOException(msg);
                }
                if (configObject.getVersion().equals(defaultConfigObject.getVersion())) break;
                configObject = null;
            }
        }
        if (configObject == null) {
            configObject = defaultConfigObjects[0];
        }
        return new ConfigObjectWrapper(configObject, lastModified);
    }

    public String toJson(Object configObject) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PascalCaseNamingStrategy());
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        String newJson = objectMapper.writeValueAsString(configObject);
        if (!newJson.endsWith(System.getProperty("line.separator"))) {
            newJson = newJson + System.getProperty("line.separator");
        }
        return newJson;
    }

    private static class PascalCaseNamingStrategy
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = -522841738265888214L;

        private PascalCaseNamingStrategy() {
        }

        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.convert(defaultName);
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.convert(defaultName);
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.convert(defaultName);
        }

        public String convert(String defaultName) {
            char[] arr = defaultName.toCharArray();
            if (arr.length != 0 && Character.isLowerCase(arr[0])) {
                char upper;
                arr[0] = upper = Character.toUpperCase(arr[0]);
            }
            return String.valueOf(arr);
        }
    }
}

