/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.seeq.link.sdk.interfaces.SqlDatabaseType;
import com.seeq.link.sdk.interfaces.SqlService;

public class DefaultSqlService
implements SqlService {
    @Override
    public String getSqlDriverClassName(SqlDatabaseType databaseType) throws IllegalArgumentException {
        switch (databaseType) {
            case MYSQL: {
                return "com.mysql.jdbc.Driver";
            }
            case MSSQLSERVER: {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case ORACLE: {
                return "oracle.jdbc.OracleDriver";
            }
            case POSTGRES: {
                return "org.postgresql.Driver";
            }
            case REDSHIFT: {
                return "com.amazon.redshift.jdbc.Driver";
            }
            case VERTICA: {
                return "com.vertica.jdbc.Driver";
            }
            case ATHENA: {
                return "com.simba.athena.jdbc.Driver";
            }
            case SNOWFLAKE: {
                return "net.snowflake.client.jdbc.SnowflakeDriver";
            }
            case TIMESTREAM: {
                return "com.amazon.timestream.jdbc.TimestreamDriver";
            }
            case SAPHANA: {
                return "com.sap.db.jdbc.Driver";
            }
        }
        throw new IllegalArgumentException("Unsupported database type: " + (Object)((Object)databaseType));
    }

    @Override
    public synchronized void loadSqlDriver(Class<?> callingClass, SqlDatabaseType databaseType) throws ClassNotFoundException {
        Class.forName(this.getSqlDriverClassName(databaseType), true, callingClass.getClassLoader());
    }
}

