/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.seeq.api.AgentsApi;
import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.ConfigObjectWrapper;
import com.seeq.link.sdk.interfaces.RemoteConfigChangeListener;
import com.seeq.link.sdk.interfaces.RemoteConfigObjectProvider;
import com.seeq.link.sdk.interfaces.SeeqApiProvider;
import com.seeq.link.sdk.services.JsonConfigObjectMapper;
import com.seeq.link.sdk.utilities.AgentHelper;
import com.seeq.link.sdk.utilities.ApiRequestHelper;
import com.seeq.model.AgentInputV1;
import com.seeq.model.AgentOutputV1;
import com.seeq.model.ConnectorInputV1;
import com.seeq.model.ConnectorOutputV1;
import com.seeq.utilities.exception.RuntimeIOException;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteConfigObjectProvider
implements RemoteConfigObjectProvider,
RemoteConfigChangeListener {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemoteConfigObjectProvider.class);
    @VisibleForTesting
    String agentIdentification;
    private String agentName;
    private final JsonConfigObjectMapper configObjectMapper = new JsonConfigObjectMapper();
    private SeeqApiProvider apiProvider;
    private final Map<String, Consumer<String>> callbacks = new HashMap<String, Consumer<String>>();

    @Override
    public void initialize(SeeqApiProvider apiProvider, String agentName) {
        this.apiProvider = apiProvider;
        this.agentName = agentName;
        this.agentIdentification = new AgentHelper(agentName).getAgentIdentification();
    }

    @Override
    public void registerChangeCallback(String name, Consumer<String> callback) {
        this.callbacks.put(name, callback);
    }

    @Override
    public void unregisterChangeCallback(String name) {
        this.callbacks.remove(name);
    }

    @Override
    public ConfigObjectWrapper loadConfigObject(String name, ConfigObject[] supportedConfigObjects) throws IOException {
        AgentsApi agentsApi = this.apiProvider.createAgentsApi();
        if (this.isAgentConfiguration(name)) {
            AgentOutputV1 agent = ApiRequestHelper.callNotFoundSafe(() -> agentsApi.getAgent(this.agentIdentification));
            if (agent != null && agent.getIsArchived().booleanValue()) {
                agent = null;
            }
            Optional<AgentOutputV1> maybeAgent = Optional.ofNullable(agent);
            String json = maybeAgent.map(AgentOutputV1::getJson).orElse(null);
            Long modificationTime = DefaultRemoteConfigObjectProvider.toEpochTime(maybeAgent.map(AgentOutputV1::getUpdatedAt).orElse(null));
            return this.configObjectMapper.toConfigObjectWrapper(json, supportedConfigObjects, "Error parsing remote JSON", modificationTime);
        }
        ConnectorOutputV1 connector = ApiRequestHelper.callNotFoundSafe(() -> agentsApi.getConnector(this.agentIdentification, name));
        if (connector != null && connector.getIsArchived().booleanValue()) {
            connector = null;
        }
        Optional<ConnectorOutputV1> maybeConnector = Optional.ofNullable(connector);
        String json = maybeConnector.map(ConnectorOutputV1::getJson).orElse(null);
        Long modificationTime = DefaultRemoteConfigObjectProvider.toEpochTime(maybeConnector.map(ConnectorOutputV1::getUpdatedAt).orElse(null));
        return this.configObjectMapper.toConfigObjectWrapper(json, supportedConfigObjects, String.format("Error parsing remote JSON for '%s'", name), modificationTime);
    }

    @Override
    public void saveConfigObject(String name, Object configObject) {
        AgentsApi agentsApi = this.apiProvider.createAgentsApi();
        try {
            if (this.isAgentConfiguration(name)) {
                agentsApi.createOrUpdateAgent(this.agentIdentification, new AgentInputV1().propagateToAgent(Boolean.valueOf(false)).json(this.configObjectMapper.toJson(configObject)));
            } else {
                agentsApi.createOrUpdateConnector(this.agentIdentification, name, new ConnectorInputV1().propagateToAgent(Boolean.valueOf(false)).json(this.configObjectMapper.toJson(configObject)));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeIOException((IOException)((Object)e));
        }
    }

    private boolean isAgentConfiguration(String name) {
        return name.equals(this.agentName);
    }

    @Override
    public void onConfigChanged(String name) {
        LOG.debug("{} configuration change event received from Seeq Server.", (Object)name);
        Consumer<String> callback = this.callbacks.get(name);
        if (callback != null) {
            callback.accept(name);
        }
    }

    public static Long toEpochTime(String iso8601UTCDateTime) {
        if (iso8601UTCDateTime == null) {
            return null;
        }
        ZonedDateTime dateTime = ZonedDateTime.parse(iso8601UTCDateTime);
        return dateTime.toInstant().toEpochMilli();
    }
}

