/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.interfaces;

import com.seeq.link.messages.connector.signal.SignalConnectionMessages;
import com.seeq.link.sdk.utilities.TimeInstant;
import java.util.function.Consumer;

public class GetSamplesParameters {
    private final String dataId;
    private final TimeInstant startTime;
    private final TimeInstant endTime;
    private final long maxInterpolation;
    private final int sampleLimit;
    private final String valueUom;
    private final Consumer<TimeInstant> cursorCallback;

    public GetSamplesParameters(SignalConnectionMessages.SignalRequestMessage signalRequestMessage, Consumer<TimeInstant> cursorCallback) {
        this(signalRequestMessage.getSignalId(), new TimeInstant(signalRequestMessage.getStartTime()), new TimeInstant(signalRequestMessage.getEndTime()), signalRequestMessage.getMaxInterpolation(), signalRequestMessage.getSampleLimit(), cursorCallback, signalRequestMessage.getValueUom());
    }

    public GetSamplesParameters(String dataId, TimeInstant startTime, TimeInstant endTime, long maxInterpolation, int sampleLimit, Consumer<TimeInstant> cursorCallback, String valueUom) {
        this.dataId = dataId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.sampleLimit = sampleLimit;
        this.maxInterpolation = maxInterpolation;
        this.valueUom = valueUom;
        this.cursorCallback = cursorCallback;
    }

    public String getDataId() {
        return this.dataId;
    }

    public TimeInstant getStartTime() {
        return this.startTime;
    }

    public TimeInstant getExpandedStartTime() {
        return new TimeInstant(this.startTime.getTimestamp() - this.maxInterpolation);
    }

    public TimeInstant getEndTime() {
        return this.endTime;
    }

    public TimeInstant getExpandedEndTime() {
        return new TimeInstant(this.endTime.getTimestamp() + this.maxInterpolation);
    }

    public long getMaxInterpolation() {
        return this.maxInterpolation;
    }

    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public boolean isLastCertainKeyRequested() {
        return this.cursorCallback != null;
    }

    public String getValueUom() {
        return this.valueUom;
    }

    public void setLastCertainKey(TimeInstant key) {
        if (this.cursorCallback == null) {
            throw new IllegalStateException("setLastCertainKey() can be called only if isLastCertainKeyRequested() is true");
        }
        this.cursorCallback.accept(key);
    }
}

