/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.interfaces;

import com.seeq.link.messages.connector.condition.ConditionConnectionMessages;
import com.seeq.link.sdk.utilities.TimeInstant;
import java.util.function.Consumer;

public class GetCapsulesParameters {
    private final String dataId;
    private final TimeInstant startTime;
    private final TimeInstant endTime;
    private final int capsuleLimit;
    private final long maxDuration;
    private final Consumer<TimeInstant> cursorCallback;

    public GetCapsulesParameters(ConditionConnectionMessages.ConditionRequestMessage conditionRequestMessage, Consumer<TimeInstant> cursorCallback) {
        this.dataId = conditionRequestMessage.getConditionId();
        this.startTime = new TimeInstant(conditionRequestMessage.getStartTime());
        this.endTime = new TimeInstant(conditionRequestMessage.getEndTime());
        this.capsuleLimit = conditionRequestMessage.getCapsuleLimit();
        this.maxDuration = conditionRequestMessage.getMaxDuration();
        this.cursorCallback = cursorCallback;
    }

    public GetCapsulesParameters(String dataId, TimeInstant startTime, TimeInstant endTime, int capsuleLimit, long maxDuration, Consumer<TimeInstant> cursorCallback) {
        this.dataId = dataId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.capsuleLimit = capsuleLimit - 1;
        this.maxDuration = maxDuration;
        this.cursorCallback = cursorCallback;
    }

    public String getDataId() {
        return this.dataId;
    }

    public TimeInstant getStartTime() {
        return this.startTime;
    }

    public TimeInstant getExpandedStartTime() {
        return new TimeInstant(this.startTime.getTimestamp() - this.maxDuration);
    }

    public TimeInstant getEndTime() {
        return this.endTime;
    }

    public TimeInstant getExpandedEndTime() {
        return new TimeInstant(this.endTime.getTimestamp() + this.maxDuration);
    }

    public int getCapsuleLimit() {
        return this.capsuleLimit == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.capsuleLimit + 1;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public boolean isLastCertainKeyRequested() {
        return this.cursorCallback != null;
    }

    public void setLastCertainKey(TimeInstant key) {
        if (this.cursorCallback == null) {
            throw new IllegalStateException("SetLastCertainKey cannot be called unless IsLastCertainKeyRequested is true");
        }
        this.cursorCallback.accept(key);
    }
}

