/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.interfaces;

import com.seeq.link.sdk.interfaces.GroupInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class AuthResult {
    private final boolean authenticated;
    @Nullable
    private final String userId;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String continuation;
    @Nullable
    private String name;
    @Nullable
    private String firstName;
    @Nullable
    private String lastName;
    @Nullable
    private String emailAddress;
    @Nullable
    private String securityId;
    @Nullable
    private List<GroupInfo> groups;

    private AuthResult(boolean authenticated, @Nullable String userId, @Nullable String errorMessageOrNull, @Nullable String continuationTokenOrNull) {
        this.authenticated = authenticated;
        this.userId = userId;
        this.errorMessage = errorMessageOrNull;
        this.continuation = continuationTokenOrNull;
    }

    public static AuthResult success(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        return new AuthResult(true, userId, null, null);
    }

    public static AuthResult negotiate(@NonNull String continuationToken) {
        if (continuationToken == null) {
            throw new NullPointerException("continuationToken is marked non-null but is null");
        }
        return new AuthResult(false, null, null, continuationToken);
    }

    public static AuthResult failed(@NonNull String errorMessage) {
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        return new AuthResult(false, null, errorMessage, null);
    }

    public static AuthResult unauthorized(@NonNull String errorMessage, @NonNull String userId, @Nullable List<GroupInfo> groups) {
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        AuthResult result = new AuthResult(false, userId, errorMessage, null);
        result.groups = groups;
        return result;
    }

    public AuthResult unauthorized(@NonNull String errorMessage) {
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        AuthResult result = new AuthResult(false, this.userId, errorMessage, this.continuation);
        result.name = this.name;
        result.firstName = this.firstName;
        result.lastName = this.lastName;
        result.emailAddress = this.emailAddress;
        result.securityId = this.securityId;
        result.groups = this.groups == null ? null : new ArrayList<GroupInfo>(this.groups);
        return result;
    }

    @Generated
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Nullable
    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    @Generated
    public String getContinuation() {
        return this.continuation;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    @Generated
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Nullable
    @Generated
    public String getSecurityId() {
        return this.securityId;
    }

    @Nullable
    @Generated
    public List<GroupInfo> getGroups() {
        return this.groups;
    }

    @Generated
    public AuthResult setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Generated
    public AuthResult setFirstName(@Nullable String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Generated
    public AuthResult setLastName(@Nullable String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Generated
    public AuthResult setEmailAddress(@Nullable String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Generated
    public AuthResult setSecurityId(@Nullable String securityId) {
        this.securityId = securityId;
        return this;
    }

    @Generated
    public AuthResult setGroups(@Nullable List<GroupInfo> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthResult)) {
            return false;
        }
        AuthResult other = (AuthResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthenticated() != other.isAuthenticated()) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$continuation = this.getContinuation();
        String other$continuation = other.getContinuation();
        if (this$continuation == null ? other$continuation != null : !this$continuation.equals(other$continuation)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$emailAddress = this.getEmailAddress();
        String other$emailAddress = other.getEmailAddress();
        if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
            return false;
        }
        String this$securityId = this.getSecurityId();
        String other$securityId = other.getSecurityId();
        if (this$securityId == null ? other$securityId != null : !this$securityId.equals(other$securityId)) {
            return false;
        }
        List<GroupInfo> this$groups = this.getGroups();
        List<GroupInfo> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticated() ? 79 : 97);
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $continuation = this.getContinuation();
        result = result * 59 + ($continuation == null ? 43 : $continuation.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $emailAddress = this.getEmailAddress();
        result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
        String $securityId = this.getSecurityId();
        result = result * 59 + ($securityId == null ? 43 : $securityId.hashCode());
        List<GroupInfo> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthResult(authenticated=" + this.isAuthenticated() + ", userId=" + this.getUserId() + ", errorMessage=" + this.getErrorMessage() + ", continuation=" + this.getContinuation() + ", name=" + this.getName() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", emailAddress=" + this.getEmailAddress() + ", securityId=" + this.getSecurityId() + ", groups=" + this.getGroups() + ")";
    }
}

