/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.seeq.link.sdk.interfaces.SyncMode;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingSchedule {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(IndexingSchedule.class);
    private String frequency = "1w";
    private boolean onStartupAndConfigChange = true;
    private boolean onStartupAndConfigChangeComplete = false;
    private volatile SyncMode indexingRequested;
    private ZonedDateTime next = ZonedDateTime.now();

    public IndexingSchedule() {
        this.indexingRequested = SyncMode.NONE;
    }

    public IndexingSchedule(ZonedDateTime next, String frequency, boolean onStartupAndConfigChange) {
        this();
        this.next = next;
        this.frequency = frequency;
        this.onStartupAndConfigChange = onStartupAndConfigChange;
    }

    public String getNext() {
        return this.next.toString();
    }

    public void setNext(String next) {
        if (next == null || next.trim().length() == 0) {
            this.next = ZonedDateTime.now();
            return;
        }
        try {
            this.next = ZonedDateTime.parse(next);
        }
        catch (Exception e) {
            LOG.error("Could not parse index schedule next '{}', setting to now", (Object)next);
            this.next = ZonedDateTime.now();
        }
    }

    @JsonIgnore
    ZonedDateTime getNextDateTime() {
        return this.next;
    }

    public SyncMode shouldIndex(String connectionName) {
        if (this.onStartupAndConfigChange && !this.onStartupAndConfigChangeComplete) {
            LOG.debug("Connection {} should index now because IndexingSchedule.OnStartupAndConfigChange is true", (Object)connectionName);
            return SyncMode.FULL;
        }
        if (this.indexingRequested != SyncMode.NONE) {
            LOG.debug("Connection {} should index now because the connector requested {} index", (Object)connectionName, (Object)this.indexingRequested.toString());
        }
        return this.indexingRequested;
    }

    public void requestNow(SyncMode syncMode) {
        this.indexingRequested = syncMode;
    }

    public void markIndexingFinished() {
        this.onStartupAndConfigChangeComplete = true;
        this.indexingRequested = SyncMode.NONE;
    }

    @Generated
    public String getFrequency() {
        return this.frequency;
    }

    @Generated
    public IndexingSchedule setFrequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @Generated
    public boolean isOnStartupAndConfigChange() {
        return this.onStartupAndConfigChange;
    }

    @Generated
    public IndexingSchedule setOnStartupAndConfigChange(boolean onStartupAndConfigChange) {
        this.onStartupAndConfigChange = onStartupAndConfigChange;
        return this;
    }
}

