/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.seeq.ApiException;
import com.seeq.api.AssetsApi;
import com.seeq.api.ConditionsApi;
import com.seeq.api.ItemsApi;
import com.seeq.api.ScalarsApi;
import com.seeq.api.SignalsApi;
import com.seeq.api.SystemApi;
import com.seeq.api.TreesApi;
import com.seeq.api.UserGroupsApi;
import com.seeq.link.messages.agent.AgentMessages;
import com.seeq.link.messages.connector.auth.AuthConnectionMessages;
import com.seeq.link.messages.connector.condition.ConditionConnectionMessages;
import com.seeq.link.messages.connector.extcalc.ExternalCalculationMessages;
import com.seeq.link.messages.connector.oauth2.OAuth2ConnectionMessages;
import com.seeq.link.messages.connector.signal.SignalConnectionMessages;
import com.seeq.link.sdk.BaseDatasourceConnection;
import com.seeq.link.sdk.ConnectorV2Host;
import com.seeq.link.sdk.interfaces.AgentService;
import com.seeq.link.sdk.interfaces.AuthDatasourceConnection;
import com.seeq.link.sdk.interfaces.AuthParameters;
import com.seeq.link.sdk.interfaces.AuthResult;
import com.seeq.link.sdk.interfaces.ConditionPullDatasourceConnection;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.interfaces.DatasourceConnectionServiceV2;
import com.seeq.link.sdk.interfaces.DatasourceConnectionV2;
import com.seeq.link.sdk.interfaces.ExternalCalcSignalDataType;
import com.seeq.link.sdk.interfaces.ExternalCalculationDatasourceConnection;
import com.seeq.link.sdk.interfaces.ExternalCalculationValidator;
import com.seeq.link.sdk.interfaces.GetCapsulesParameters;
import com.seeq.link.sdk.interfaces.GetSamplesParameters;
import com.seeq.link.sdk.interfaces.GroupInfo;
import com.seeq.link.sdk.interfaces.IndexingDatasourceConnection;
import com.seeq.link.sdk.interfaces.NonSchedulableIndexingConnection;
import com.seeq.link.sdk.interfaces.OAuth2AuthParameters;
import com.seeq.link.sdk.interfaces.OAuth2AuthResult;
import com.seeq.link.sdk.interfaces.OAuth2DatasourceConnection;
import com.seeq.link.sdk.interfaces.OAuth2PreAuthParameters;
import com.seeq.link.sdk.interfaces.OAuth2PreAuthResult;
import com.seeq.link.sdk.interfaces.PullDatasourceConnection;
import com.seeq.link.sdk.interfaces.SignalPullDatasourceConnection;
import com.seeq.link.sdk.interfaces.SyncMode;
import com.seeq.link.sdk.interfaces.SyncStatus;
import com.seeq.link.sdk.services.PropertyTransformer;
import com.seeq.link.sdk.utilities.BatchSizeHelper;
import com.seeq.link.sdk.utilities.Capsule;
import com.seeq.link.sdk.utilities.ExceptionHelper;
import com.seeq.link.sdk.utilities.RequestCancellation;
import com.seeq.link.sdk.utilities.Sample;
import com.seeq.link.sdk.utilities.TimeInstant;
import com.seeq.model.AssetBatchInputV1;
import com.seeq.model.AssetInputV1;
import com.seeq.model.AssetTreeBatchInputV1;
import com.seeq.model.AssetTreeSingleInputV1;
import com.seeq.model.ConditionBatchInputV1;
import com.seeq.model.ConditionInputV1;
import com.seeq.model.DatasourceOutputV1;
import com.seeq.model.ItemIdListInputV1;
import com.seeq.model.ItemUpdateOutputV1;
import com.seeq.model.LicenseStatusOutputV1;
import com.seeq.model.LicensedFeatureStatusOutputV1;
import com.seeq.model.PutScalarsInputV1;
import com.seeq.model.PutSignalsInputV1;
import com.seeq.model.PutUserGroupsInputV1;
import com.seeq.model.ScalarInputV1;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.model.SignalWithIdInputV1;
import com.seeq.model.UserGroupWithIdInputV1;
import com.seeq.utilities.exception.OperationCanceledException;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceConnectionV2Host
extends BaseDatasourceConnection<ConnectorV2Host>
implements DatasourceConnectionServiceV2 {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceConnectionV2Host.class);
    private final Logger guestLogger;
    private final DatasourceConnectionV2 connection;
    private DatasourceOutputV1 datasource;
    private List<PropertyTransformer.Spec> transforms;
    private static final String EXCLUDE_FROM_INDEXING = "Exclude From Indexing";
    private List<String> datasourceItemTypeCleanupFilter = null;
    private String datasourceItemDataIdRegexFilter = null;
    private String datasourceItemDataIdExcludeRegexFilter = null;
    private String datasourceItemNameRegexFilter = null;
    private String datasourceItemNameExcludeRegexFilter = null;
    private String newIncrementalIndexState = null;
    private boolean skipArchiving = false;
    private BatchSizeHelper signalBatchSizeHelper;
    private BatchSizeHelper conditionBatchSizeHelper;
    private BatchSizeHelper scalarBatchSizeHelper;
    private BatchSizeHelper assetBatchSizeHelper;
    private BatchSizeHelper rootAssetBatchSizeHelper;
    private BatchSizeHelper relationshipBatchSizeHelper;
    private BatchSizeHelper userGroupBatchSizeHelper;
    private Map<String, SignalWithIdInputV1> signalBatchInput = null;
    private Map<String, ConditionInputV1> conditionBatchInput = null;
    private Map<String, ScalarInputV1> scalarBatchInput = null;
    private Map<String, AssetInputV1> assetBatchInput = null;
    private Map<String, AssetInputV1> rootAssetBatchInput = null;
    private Map<RelationshipKey, AssetTreeSingleInputV1> relationshipBatchInput = null;
    private Map<String, UserGroupWithIdInputV1> userGroupBatchInput = null;
    private String syncToken = null;
    private static final Map<ExternalCalculationMessages.SignalDataType, ExternalCalcSignalDataType> SIGNAL_DATA_TYPE_MAP = ImmutableMap.of((Object)((Object)ExternalCalculationMessages.SignalDataType.NUMERIC), (Object)((Object)ExternalCalcSignalDataType.NUMERIC), (Object)((Object)ExternalCalculationMessages.SignalDataType.STRING), (Object)((Object)ExternalCalcSignalDataType.STRING));

    DatasourceConnectionV2Host(AgentService agentService, ConnectorV2Host connectorHost, DatasourceConnectionV2 connection, AgentMessages.DatasourceService[] services) {
        super(agentService, connectorHost, connection, services);
        this.connection = connection;
        this.guestLogger = LoggerFactory.getLogger((String)("com.seeq.link.plugin." + this.connection.getClass().getSimpleName()));
        this.transforms = null;
        this.initSignals();
        this.initConditions();
        this.initScalars();
        this.initAssets();
        this.initRootAssets();
        this.initRelationships();
        this.initUserGroups();
        this.signalBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.conditionBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.scalarBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.assetBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.rootAssetBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.relationshipBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.userGroupBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
    }

    @Override
    public void initialize() {
        this.connection.initialize(this);
    }

    @Override
    public boolean isLicensed(String featureName) {
        if (!this.getAgentService().isSeeqServerConnected()) {
            this.log().info("Waiting for Seeq Server connection to verify license");
            return false;
        }
        SystemApi systemApi = this.getAgentService().getApiProvider().createSystemApi();
        LicenseStatusOutputV1 licenseStatusOutput = null;
        try {
            licenseStatusOutput = systemApi.getLicense();
        }
        catch (ApiException apex) {
            this.log().error("Failed to get license from Seeq Server due to exception:", (Throwable)apex);
            return false;
        }
        if (licenseStatusOutput.getAdditionalFeatures().stream().noneMatch(o -> o.getName().equals(featureName))) {
            this.log().error("Seeq Server license does not include the feature {}", (Object)featureName);
            return false;
        }
        Optional<LicensedFeatureStatusOutputV1> licensedFeatureStatusOutputV1 = licenseStatusOutput.getAdditionalFeatures().stream().filter(o -> o.getName().equals(featureName)).findFirst();
        if (licensedFeatureStatusOutputV1.isPresent() && licensedFeatureStatusOutputV1.get().getValidity() != LicensedFeatureStatusOutputV1.ValidityEnum.VALID) {
            this.log().error("License for feature {} is not valid", (Object)featureName);
            return false;
        }
        this.log().info("License validated for feature {}", (Object)featureName);
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.connection.destroy();
    }

    @Override
    public void setConnectionState(Connection.ConnectionState newState) {
        if (newState == Connection.ConnectionState.CONNECTED) {
            this.setState(newState, "");
        } else {
            this.setState(newState, this.getConnectionMessage());
        }
    }

    @Override
    public void setConnectionStatusMessage(String message) {
        this.setState(this.getState(), message);
    }

    @Override
    protected void handleConnectionMonitorException(String methodName, Exception exception) {
        super.handleConnectionMonitorException(methodName, exception);
        this.setState(this.getState(), ExceptionHelper.toExceptionMessage(exception));
    }

    @Override
    public Connection.ConnectionState getConnectionState() {
        return this.getState();
    }

    @Override
    public DatasourceOutputV1 getDatasource() {
        return this.datasource;
    }

    @Override
    public String getLastIncrementalIndexState() {
        return this.datasource.getDataVersionCheck();
    }

    @Override
    public void putIncrementalIndexState(String incrementalIndexState) {
        this.newIncrementalIndexState = incrementalIndexState;
    }

    @Override
    public void skipArchiving() {
        this.skipArchiving = true;
    }

    @Override
    public void storeDatasourceProperties(boolean storedInSeeq, List<ScalarPropertyV1> additionalProperties) {
        this.updateExistingDatasource(this.getDatasource(), storedInSeeq, additionalProperties);
    }

    @Override
    public void deleteDatasourceProperties(List<String> additionalPropertiesToDelete) {
        Map<String, ScalarPropertyV1> existingAdditionalPropertiesByName = this.getDatasource().getAdditionalProperties().stream().collect(Collectors.toMap(ScalarPropertyV1::getName, p -> p));
        ItemsApi itemsApi = this.getAgentService().getIndexingApiProvider().createItemsApi();
        for (String propertyToRemove : additionalPropertiesToDelete) {
            if (existingAdditionalPropertiesByName.containsKey(propertyToRemove)) {
                itemsApi.deleteProperty(this.getDatasource().getId(), propertyToRemove);
                continue;
            }
            LOG.debug("The property {} is not one of the additionalProperties of the datasource. Skipping delete.", (Object)propertyToRemove);
        }
        this.datasource = this.getDatasourceAndCreationInfo().datasource;
    }

    private BaseDatasourceConnection.DatasourceAndCreationInfo getDatasourceAndCreationInfo() {
        boolean storedInSeeq = !this.isPullDatasourceConnection();
        return this.getOrCreateDatasource(storedInSeeq);
    }

    @Override
    public boolean isPullDatasourceConnection() {
        return this.connection instanceof PullDatasourceConnection;
    }

    @Override
    public boolean isIndexingDatasourceConnection() {
        return this.connection instanceof IndexingDatasourceConnection;
    }

    @Override
    public boolean isIndexingScheduleSupported() {
        if (this.connection instanceof IndexingDatasourceConnection) {
            return !(this.connection instanceof NonSchedulableIndexingConnection);
        }
        return false;
    }

    private boolean ensureDatasourceExists() {
        if (this.datasource != null) {
            return false;
        }
        BaseDatasourceConnection.DatasourceAndCreationInfo datasourceAndCreationInfo = this.getDatasourceAndCreationInfo();
        this.datasource = datasourceAndCreationInfo.datasource;
        return datasourceAndCreationInfo.newlyCreated;
    }

    @Override
    public void metadataSync(SyncMode syncMode) throws Exception {
        IndexingDatasourceConnection indexingConnection = (IndexingDatasourceConnection)this.connection;
        boolean newlyCreated = this.ensureDatasourceExists();
        this.datasource = this.getDatasourceAndCreationInfo().datasource;
        String requestId = "Cleaning up datasource " + this.datasource.getId();
        this.cancelRequest(requestId);
        this.newIncrementalIndexState = this.datasource.getDataVersionCheck();
        this.itemsWithErrors = 0;
        this.initSignals();
        this.initConditions();
        this.initScalars();
        this.initAssets();
        this.initRootAssets();
        this.initRelationships();
        this.initUserGroups();
        this.signalBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.conditionBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.scalarBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.assetBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.rootAssetBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.relationshipBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.userGroupBatchSizeHelper = this.getAgentService().createBatchSizeHelper();
        this.syncToken = ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT);
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        this.sendSyncToken(this.datasource.getId(), this.syncToken);
        this.skipArchiving = false;
        this.setTransforms(indexingConnection.getConfiguration().getTransforms());
        indexingConnection.index(syncMode);
        this.flushRelationships();
        if (syncMode == SyncMode.FULL && !newlyCreated && !this.skipArchiving) {
            this.cleanUpStaleItems(this.datasource.getId(), this.syncToken, this.datasourceItemTypeCleanupFilter, this.datasourceItemDataIdRegexFilter, this.datasourceItemDataIdExcludeRegexFilter, this.datasourceItemNameRegexFilter, this.datasourceItemNameExcludeRegexFilter, requestId);
        } else if (syncMode != SyncMode.FULL) {
            LOG.debug("Skipping datasource archiving because SyncMode is not FULL");
        } else if (newlyCreated) {
            LOG.debug("Skipping datasource archiving because datasource was newly created");
        } else {
            LOG.debug("Skipping datasource archiving because skipArchiving() was called by connection");
        }
        this.setSyncStatus(SyncStatus.SYNC_COMPLETE);
        this.sendSyncCompleteInfo(this.datasource.getId(), this.newIncrementalIndexState);
        this.syncToken = null;
    }

    private static boolean shouldExcludeFromIndexing(List<ScalarPropertyV1> properties) {
        ScalarPropertyV1 excludeFromIndexingProperty = DatasourceConnectionV2Host.excludeFromIndexingProperty(properties);
        return excludeFromIndexingProperty != null && excludeFromIndexingProperty.getValue() instanceof Boolean && (Boolean)excludeFromIndexingProperty.getValue() != false;
    }

    private static ScalarPropertyV1 excludeFromIndexingProperty(List<ScalarPropertyV1> properties) {
        return properties.stream().filter(p -> p.getName().equals(EXCLUDE_FROM_INDEXING)).findFirst().orElse(null);
    }

    @VisibleForTesting
    int getItemsWithErrors() {
        return this.itemsWithErrors;
    }

    @Override
    public void setTransforms(List<PropertyTransformer.Spec> transforms) {
        this.transforms = transforms;
    }

    @Override
    public List<ItemUpdateOutputV1> putSignal(SignalWithIdInputV1 signalDefinition) throws ApiException {
        Preconditions.checkArgument((signalDefinition.getDataId() != null ? 1 : 0) != 0, (Object)"DataId cannot be null. It must be the unique identifier that is used to request signal data from the source.");
        Preconditions.checkArgument((signalDefinition.getName() != null ? 1 : 0) != 0, (Object)"Name cannot be null. It is the text that will be used as the primary way to reference this signal.");
        signalDefinition.setDatasourceId(this.getDatasourceId());
        signalDefinition.setDatasourceClass(this.getDatasourceClass());
        if (this.transforms != null) {
            if (DatasourceConnectionV2Host.shouldExcludeFromIndexing((signalDefinition = PropertyTransformer.transform(signalDefinition, this.transforms)).getAdditionalProperties())) {
                return null;
            }
            signalDefinition.getAdditionalProperties().remove(DatasourceConnectionV2Host.excludeFromIndexingProperty(signalDefinition.getAdditionalProperties()));
        }
        signalDefinition.setSyncToken(this.syncToken);
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        this.signalBatchInput.put(signalDefinition.getDataId(), signalDefinition);
        if (this.signalBatchInput.size() >= this.signalBatchSizeHelper.getBatchSize()) {
            itemsFlushed = this.flushSignals();
        }
        return itemsFlushed;
    }

    private void initSignals() {
        this.signalBatchInput = new HashMap<String, SignalWithIdInputV1>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushSignals() throws ApiException {
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        try {
            if (this.signalBatchInput.size() != 0) {
                PutSignalsInputV1 batchInput = new PutSignalsInputV1();
                batchInput.setSignals((List)ImmutableList.copyOf(this.signalBatchInput.values()));
                SignalsApi signalsApi = this.getAgentService().getIndexingApiProvider().createSignalsApi();
                this.signalBatchSizeHelper.start();
                itemsFlushed = signalsApi.putSignals(batchInput).getItemUpdates();
                this.signalBatchSizeHelper.stop(this.signalBatchInput.size());
                this.logAndCountBadItems(itemsFlushed);
                StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (Signals): %d items took %.2f seconds", this.signalBatchInput.size(), (double)this.signalBatchSizeHelper.getLastDuration().toMillis() / 1000.0));
                double ips = this.signalBatchSizeHelper.getLastItemsPerSecond();
                if (Double.isFinite(ips)) {
                    logStr.append(String.format(" at %.1f per second", ips));
                }
                LOG.debug(logStr.toString());
            }
        }
        finally {
            this.initSignals();
        }
        return itemsFlushed;
    }

    private void initUserGroups() {
        this.userGroupBatchInput = new HashMap<String, UserGroupWithIdInputV1>();
    }

    @Override
    public List<ItemUpdateOutputV1> putUserGroup(UserGroupWithIdInputV1 userGroupDefinition) throws ApiException {
        Preconditions.checkArgument((userGroupDefinition.getDataId() != null ? 1 : 0) != 0, (Object)"DataId cannot be null. It must be the unique identifier that is used to identify the user group in the source.");
        Preconditions.checkArgument((userGroupDefinition.getName() != null ? 1 : 0) != 0, (Object)"Name cannot be null. It is the text that will be used as the primary way to reference this user group.");
        if (userGroupDefinition.getDatasourceId() == null) {
            userGroupDefinition.setDatasourceId(this.getDatasourceId());
        }
        if (userGroupDefinition.getDatasourceClass() == null) {
            userGroupDefinition.setDatasourceClass(this.getDatasourceClass());
        }
        if (this.transforms != null) {
            userGroupDefinition = PropertyTransformer.transform(userGroupDefinition, this.transforms);
        }
        userGroupDefinition.setSyncToken(this.syncToken);
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        this.userGroupBatchInput.put(userGroupDefinition.getDataId(), userGroupDefinition);
        if (this.userGroupBatchInput.size() >= this.userGroupBatchSizeHelper.getBatchSize()) {
            itemsFlushed = this.flushUserGroups();
        }
        return itemsFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushUserGroups() throws ApiException {
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        try {
            if (this.userGroupBatchInput.size() != 0) {
                PutUserGroupsInputV1 batchInput = new PutUserGroupsInputV1();
                batchInput.setUserGroups((List)ImmutableList.copyOf(this.userGroupBatchInput.values()));
                UserGroupsApi userGroupsApi = this.getAgentService().getIndexingApiProvider().createUserGroupsApi();
                this.userGroupBatchSizeHelper.start();
                itemsFlushed = userGroupsApi.putUserGroups(batchInput).getItemUpdates();
                this.userGroupBatchSizeHelper.stop(this.userGroupBatchInput.size());
                this.logAndCountBadItems(itemsFlushed);
                StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (User Groups): %d items took %.2f seconds", this.userGroupBatchInput.size(), (double)this.userGroupBatchSizeHelper.getLastDuration().toMillis() / 1000.0));
                double ips = this.userGroupBatchSizeHelper.getLastItemsPerSecond();
                if (Double.isFinite(ips)) {
                    logStr.append(String.format(" at %.1f per second", ips));
                }
                LOG.debug(logStr.toString());
            }
        }
        finally {
            this.initUserGroups();
        }
        return itemsFlushed;
    }

    @Override
    public List<ItemUpdateOutputV1> putCondition(ConditionInputV1 conditionDefinition) throws ApiException {
        Preconditions.checkArgument((conditionDefinition.getDataId() != null ? 1 : 0) != 0, (Object)"DataId cannot be null. It must be the unique identifier that is used to request condition data from the source.");
        Preconditions.checkArgument((conditionDefinition.getName() != null ? 1 : 0) != 0, (Object)"Name cannot be null. It is the text that will be used as the primary way to reference this condition.");
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        if (this.transforms != null) {
            if (DatasourceConnectionV2Host.shouldExcludeFromIndexing((conditionDefinition = PropertyTransformer.transform(conditionDefinition, this.transforms)).getProperties())) {
                return null;
            }
            conditionDefinition.getProperties().remove(DatasourceConnectionV2Host.excludeFromIndexingProperty(conditionDefinition.getProperties()));
        }
        conditionDefinition.setDatasourceId(this.getDatasourceId());
        conditionDefinition.setDatasourceClass(this.getDatasourceClass());
        conditionDefinition.setSyncToken(this.syncToken);
        this.conditionBatchInput.put(conditionDefinition.getDataId(), conditionDefinition);
        if (this.conditionBatchInput.size() >= this.conditionBatchSizeHelper.getBatchSize()) {
            itemsFlushed = this.flushConditions();
        }
        return itemsFlushed;
    }

    private void initConditions() {
        this.conditionBatchInput = new HashMap<String, ConditionInputV1>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushConditions() throws ApiException {
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        try {
            if (this.conditionBatchInput.size() != 0) {
                ConditionBatchInputV1 batchInput = new ConditionBatchInputV1();
                batchInput.setConditions(new ArrayList<ConditionInputV1>(this.conditionBatchInput.values()));
                ConditionsApi conditionsApi = this.getAgentService().getIndexingApiProvider().createConditionsApi();
                this.conditionBatchSizeHelper.start();
                itemsFlushed = conditionsApi.putConditions(batchInput).getItemUpdates();
                this.conditionBatchSizeHelper.stop(this.conditionBatchInput.size());
                this.logAndCountBadItems(itemsFlushed);
                StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (Conditions): %d items took %.2f seconds", this.conditionBatchInput.size(), (double)this.conditionBatchSizeHelper.getLastDuration().toMillis() / 1000.0));
                double ips = this.conditionBatchSizeHelper.getLastItemsPerSecond();
                if (Double.isFinite(ips)) {
                    logStr.append(String.format(" at %.1f per second", ips));
                }
                LOG.debug(logStr.toString());
            }
        }
        finally {
            this.initConditions();
        }
        return itemsFlushed;
    }

    @Override
    public List<ItemUpdateOutputV1> putScalar(ScalarInputV1 scalarDefinition) throws ApiException {
        Preconditions.checkArgument((scalarDefinition.getDataId() != null ? 1 : 0) != 0, (Object)"DataId cannot be null. It must be the unique identifier for a scalar from the source.");
        Preconditions.checkArgument((scalarDefinition.getName() != null ? 1 : 0) != 0, (Object)"Name cannot be null. It is the text that will be used as the primary way to reference this scalar.");
        Preconditions.checkArgument((scalarDefinition.getFormula() != null ? 1 : 0) != 0, (Object)"Formula cannot be null. It is the value for this scalar.");
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        if (this.transforms != null) {
            if (DatasourceConnectionV2Host.shouldExcludeFromIndexing((scalarDefinition = PropertyTransformer.transform(scalarDefinition, this.transforms)).getProperties())) {
                return null;
            }
            scalarDefinition.getProperties().remove(DatasourceConnectionV2Host.excludeFromIndexingProperty(scalarDefinition.getProperties()));
        }
        scalarDefinition.setSyncToken(this.syncToken);
        this.scalarBatchInput.put(scalarDefinition.getDataId(), scalarDefinition);
        if (this.scalarBatchInput.size() >= this.scalarBatchSizeHelper.getBatchSize()) {
            itemsFlushed = this.flushScalars();
        }
        return itemsFlushed;
    }

    private void initScalars() {
        this.scalarBatchInput = new HashMap<String, ScalarInputV1>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushScalars() throws ApiException {
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        try {
            if (this.scalarBatchInput.size() != 0) {
                PutScalarsInputV1 batchInput = new PutScalarsInputV1();
                batchInput.setScalars(new ArrayList<ScalarInputV1>(this.scalarBatchInput.values()));
                batchInput.setDatasourceId(this.getDatasourceId());
                batchInput.setDatasourceClass(this.getDatasourceClass());
                ScalarsApi scalarsApi = this.getAgentService().getIndexingApiProvider().createScalarsApi();
                this.scalarBatchSizeHelper.start();
                itemsFlushed = scalarsApi.putScalars(batchInput).getItemUpdates();
                this.scalarBatchSizeHelper.stop(this.scalarBatchInput.size());
                this.logAndCountBadItems(itemsFlushed);
                StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (Scalars): %d items took %.2f seconds", this.scalarBatchInput.size(), (double)this.scalarBatchSizeHelper.getLastDuration().toMillis() / 1000.0));
                double ips = this.scalarBatchSizeHelper.getLastItemsPerSecond();
                if (Double.isFinite(ips)) {
                    logStr.append(String.format(" at %.1f per second", ips));
                }
                LOG.debug(logStr.toString());
            }
        }
        finally {
            this.initScalars();
        }
        return itemsFlushed;
    }

    private void initAssets() {
        this.assetBatchInput = new HashMap<String, AssetInputV1>();
    }

    private void initRootAssets() {
        this.rootAssetBatchInput = new HashMap<String, AssetInputV1>();
    }

    @Override
    public List<ItemUpdateOutputV1> putAsset(AssetInputV1 assetDefinition) throws ApiException {
        return this.putAssetInternal(assetDefinition, this.syncToken, this.assetBatchInput, this.assetBatchSizeHelper, this::flushAssets);
    }

    @Override
    public List<ItemUpdateOutputV1> putRootAsset(AssetInputV1 assetDefinition) throws ApiException {
        return this.putAssetInternal(assetDefinition, this.syncToken, this.rootAssetBatchInput, this.rootAssetBatchSizeHelper, this::flushRootAssets);
    }

    private List<ItemUpdateOutputV1> putAssetInternal(AssetInputV1 assetDefinition, String syncToken, Map<String, AssetInputV1> batchInput, BatchSizeHelper batchSizeHelper, CheckedSupplier<List<ItemUpdateOutputV1>> flushFunction) throws ApiException {
        Preconditions.checkArgument((assetDefinition.getDataId() != null ? 1 : 0) != 0, (Object)"DataId cannot be null. It must be the unique identifier that is used to identity an asset despite name changes.");
        Preconditions.checkArgument((assetDefinition.getName() != null ? 1 : 0) != 0, (Object)"Name cannot be null. It is the text that will be used as the primary way to reference this asset.");
        if (this.transforms != null) {
            if (DatasourceConnectionV2Host.shouldExcludeFromIndexing((assetDefinition = PropertyTransformer.transform(assetDefinition, this.transforms)).getProperties())) {
                return null;
            }
            assetDefinition.getProperties().remove(DatasourceConnectionV2Host.excludeFromIndexingProperty(assetDefinition.getProperties()));
        }
        assetDefinition.setSyncToken(syncToken);
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        this.ensureDatasourceExists();
        assetDefinition.setHostId(this.datasource.getId());
        batchInput.put(assetDefinition.getDataId(), assetDefinition);
        if (batchInput.size() >= batchSizeHelper.getBatchSize()) {
            itemsFlushed = flushFunction.get();
        }
        return itemsFlushed;
    }

    @Override
    public List<ItemUpdateOutputV1> flushAssets() throws ApiException {
        List<ItemUpdateOutputV1> itemsFlushed;
        try {
            AssetBatchInputV1 batchInput = new AssetBatchInputV1();
            batchInput.setAssets(new ArrayList<AssetInputV1>(this.assetBatchInput.values()));
            itemsFlushed = this.flushAssetsInternal(batchInput, this.assetBatchSizeHelper, r -> {});
        }
        finally {
            this.initAssets();
        }
        return itemsFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushRootAssets() throws ApiException {
        List<ItemUpdateOutputV1> itemsFlushed;
        CheckedConsumer<List<ItemUpdateOutputV1>> makeItemsRootAssets = assetList -> {
            TreesApi treesApi = this.getAgentService().getIndexingApiProvider().createTreesApi();
            ItemIdListInputV1 itemIdList = new ItemIdListInputV1();
            itemIdList.setItems(assetList.stream().filter(o -> o.getItem() != null).map(o -> o.getItem().getId()).collect(Collectors.toList()));
            treesApi.moveNodesToRootOfTree(itemIdList);
        };
        try {
            AssetBatchInputV1 batchInput = new AssetBatchInputV1();
            batchInput.setAssets(new ArrayList<AssetInputV1>(this.rootAssetBatchInput.values()));
            itemsFlushed = this.flushAssetsInternal(batchInput, this.rootAssetBatchSizeHelper, makeItemsRootAssets);
        }
        finally {
            this.initRootAssets();
        }
        return itemsFlushed;
    }

    private List<ItemUpdateOutputV1> flushAssetsInternal(AssetBatchInputV1 batchInput, BatchSizeHelper batchSizeHelper, CheckedConsumer<List<ItemUpdateOutputV1>> responseConsumer) throws ApiException {
        this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        if (batchInput.getAssets().size() != 0) {
            AssetsApi assetsApi = this.getAgentService().getIndexingApiProvider().createAssetsApi();
            batchInput.setHostId(((AssetInputV1)batchInput.getAssets().get(0)).getHostId());
            batchSizeHelper.start();
            itemsFlushed = assetsApi.batchCreateAssets(batchInput).getItemUpdates();
            batchSizeHelper.stop(batchInput.getAssets().size());
            responseConsumer.accept(itemsFlushed);
            this.logAndCountBadItems(itemsFlushed);
            StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (Assets): %d items took %.2f seconds", batchInput.getAssets().size(), (double)batchSizeHelper.getLastDuration().toMillis() / 1000.0));
            double ips = batchSizeHelper.getLastItemsPerSecond();
            if (Double.isFinite(ips)) {
                logStr.append(String.format(" at %.1f per second", ips));
            }
            LOG.debug(logStr.toString());
        }
        return itemsFlushed;
    }

    private void initRelationships() {
        this.relationshipBatchInput = new HashMap<RelationshipKey, AssetTreeSingleInputV1>();
    }

    @Override
    public List<ItemUpdateOutputV1> putRelationship(AssetTreeSingleInputV1 relationshipDefinition) throws ApiException {
        Preconditions.checkArgument((relationshipDefinition.getChildDataId() != null ? 1 : 0) != 0, (Object)"Child data ID cannot be null.");
        Preconditions.checkArgument((relationshipDefinition.getParentDataId() != null ? 1 : 0) != 0, (Object)"Parent data ID cannot be null.");
        this.ensureDatasourceExists();
        this.relationshipBatchInput.put(new RelationshipKey(relationshipDefinition.getChildDataId(), relationshipDefinition.getParentDataId()), relationshipDefinition);
        List<ItemUpdateOutputV1> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        if (this.relationshipBatchInput.size() >= this.relationshipBatchSizeHelper.getBatchSize()) {
            itemsFlushed = this.flushRelationships();
        }
        return itemsFlushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ItemUpdateOutputV1> flushRelationships() throws ApiException {
        this.flushUserGroups();
        this.flushSignals();
        this.flushConditions();
        this.flushAssets();
        this.flushScalars();
        this.flushRootAssets();
        List<Object> itemsFlushed = new ArrayList<ItemUpdateOutputV1>();
        try {
            if (this.relationshipBatchInput.size() != 0) {
                AssetTreeBatchInputV1 batchInput = new AssetTreeBatchInputV1();
                batchInput.setChildHostId(this.datasource.getId());
                batchInput.setParentHostId(this.datasource.getId());
                batchInput.setRelationships(new ArrayList<AssetTreeSingleInputV1>(this.relationshipBatchInput.values()));
                batchInput.setDisableAssetTreeIndexUpdateDuringSync(Boolean.valueOf(this.getCurrentIndexingRequestSyncMode() == SyncMode.FULL));
                TreesApi treesApi = this.getAgentService().getIndexingApiProvider().createTreesApi();
                this.relationshipBatchSizeHelper.start();
                itemsFlushed = treesApi.batchMoveNodesToParents(batchInput).getItemUpdates();
                this.relationshipBatchSizeHelper.stop(this.relationshipBatchInput.size());
                this.logAndCountBadItems(itemsFlushed);
                StringBuilder logStr = new StringBuilder(String.format("Sync Batch Stats (Relationships): %d items took %.2f seconds", this.relationshipBatchInput.size(), (double)this.relationshipBatchSizeHelper.getLastDuration().toMillis() / 1000.0));
                double ips = this.relationshipBatchSizeHelper.getLastItemsPerSecond();
                if (Double.isFinite(ips)) {
                    logStr.append(String.format(" at %.1f per second", ips));
                }
                LOG.debug(logStr.toString());
            }
        }
        finally {
            this.initRelationships();
        }
        return itemsFlushed;
    }

    @Override
    protected void connect() {
        this.connection.connect();
    }

    @Override
    protected void monitor() {
        if (!this.connection.monitor()) {
            this.disconnect();
            this.setConnectionState(Connection.ConnectionState.DISCONNECTED);
        }
    }

    @Override
    protected void disconnect() {
        this.connection.disconnect();
        this.setConnectionState(Connection.ConnectionState.DISCONNECTED);
    }

    @Override
    public Logger log() {
        return this.getLog();
    }

    @Override
    public void setDatasourceItemTypeCleanupFilter(List<String> itemTypeCleanupFilter) {
        this.datasourceItemTypeCleanupFilter = itemTypeCleanupFilter;
    }

    @Override
    public void setDatasourceItemDataIdRegexFilter(String regex) {
        this.datasourceItemDataIdRegexFilter = regex;
    }

    @Override
    public void setDatasourceItemDataIdExcludeRegexFilter(String regex) {
        this.datasourceItemDataIdExcludeRegexFilter = regex;
    }

    @Override
    public void setDatasourceItemNameRegexFilter(String regex) {
        this.datasourceItemNameRegexFilter = regex;
    }

    @Override
    public void setDatasourceItemNameExcludeRegexFilter(String regex) {
        this.datasourceItemNameExcludeRegexFilter = regex;
    }

    @Override
    public Logger getLog() {
        return this.guestLogger;
    }

    @Override
    public SignalConnectionMessages.SignalResponseMessage signalRequest(SignalConnectionMessages.SignalRequestMessage request) throws Exception {
        Preconditions.checkArgument((boolean)(this.connection instanceof SignalPullDatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain a SignalRequestMessage only if the connection is an instance of SignalPullDatasourceConnection");
        SignalPullDatasourceConnection pullConnection = (SignalPullDatasourceConnection)this.connection;
        SignalConnectionMessages.SignalResponseMessage.Builder response = SignalConnectionMessages.SignalResponseMessage.newBuilder();
        try (Stream<Sample> sampleInputs = pullConnection.getSamples(new GetSamplesParameters(request, cursor -> {
            if (cursor != null) {
                response.setCursor(cursor.getTimestamp());
            } else {
                response.clearCursor();
            }
        }));){
            Sample sample = null;
            Iterator sampleInputsIterator = sampleInputs.iterator();
            while (response.getSampleCount() < request.getSampleLimit() && sampleInputsIterator.hasNext()) {
                RequestCancellation.check();
                sample = (Sample)sampleInputsIterator.next();
                if (sample.getKey().getTimestamp() <= request.getStartTime()) {
                    response.clearSample();
                }
                response.addSample(DatasourceConnectionV2Host.signalValueBuilderFromSample(sample));
                if (sample.getKey().getTimestamp() < request.getEndTime()) continue;
            }
            response.setHasMoreSamples(sample != null && sample.getKey().getTimestamp() < request.getEndTime() && response.getSampleCount() == request.getSampleLimit());
        }
        return response.build();
    }

    @Override
    public ConditionConnectionMessages.ConditionResponseMessage conditionRequest(ConditionConnectionMessages.ConditionRequestMessage request) throws Exception {
        Preconditions.checkArgument((boolean)(this.connection instanceof ConditionPullDatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain a ConditionRequestMessage only if the connection is an instance of ConditionPullDatasourceConnection");
        ConditionPullDatasourceConnection pullConnection = (ConditionPullDatasourceConnection)this.connection;
        ConditionConnectionMessages.ConditionResponseMessage.Builder response = ConditionConnectionMessages.ConditionResponseMessage.newBuilder();
        try (Stream<Capsule> capsules = pullConnection.getCapsules(new GetCapsulesParameters(request, cursor -> {
            if (cursor != null) {
                response.setCursor(cursor.getTimestamp());
            } else {
                response.clearCursor();
            }
        }));){
            Capsule capsule = null;
            Iterator capsuleInputsIterator = capsules.iterator();
            while (capsuleInputsIterator.hasNext() && response.getCapsuleCount() < request.getCapsuleLimit()) {
                RequestCancellation.check();
                capsule = (Capsule)capsuleInputsIterator.next();
                if (capsule.getStart().getTimestamp() <= request.getStartTime()) {
                    response.clearCapsule();
                }
                response.addCapsule(capsule.toMessage());
                if (capsule.getStart().getTimestamp() < request.getEndTime()) continue;
            }
            response.setHasMoreCapsules(capsule != null && capsule.getStart().getTimestamp() < request.getEndTime() && response.getCapsuleCount() == request.getCapsuleLimit());
        }
        return response.build();
    }

    @Override
    public ExternalCalculationMessages.ExternalCalculationResponseMessage calculationRequest(ExternalCalculationMessages.ExternalCalculationRequestMessage request) {
        Preconditions.checkArgument((boolean)(this.connection instanceof ExternalCalculationDatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain ExternalCalculationRequest only if the connection is an instance of ExternalCalculationDatasourceConnection");
        ExternalCalculationDatasourceConnection calculationConnection = (ExternalCalculationDatasourceConnection)((Object)this.connection);
        try {
            calculationConnection.validateRequest(request);
        }
        catch (Exception e) {
            throw new OperationCanceledException((Throwable)e);
        }
        ExternalCalculationMessages.ExternalCalculationResponseMessage.Builder response = ExternalCalculationMessages.ExternalCalculationResponseMessage.newBuilder();
        int numberOfSignals = (int)request.getSignalsCount();
        int numberOfSamplesPerSignal = request.getSampleCount();
        Long windowSize = request.hasInputWindowSize() ? Long.valueOf(request.getInputWindowSize()) : null;
        ExternalCalcSignalDataType[] signalDataType = (ExternalCalcSignalDataType[])request.getSignalDataTypeList().stream().map(SIGNAL_DATA_TYPE_MAP::get).toArray(ExternalCalcSignalDataType[]::new);
        ExternalCalculationValidator detector = calculationConnection.createValidator().setWindowSize(windowSize);
        Lock validationLock = calculationConnection.getValidationLock();
        try {
            boolean haveEnoughSamples;
            validationLock.lockInterruptibly();
            boolean bl = haveEnoughSamples = numberOfSamplesPerSignal >= detector.getMinimumNumberOfSamples();
            if (calculationConnection.needsValidation() && haveEnoughSamples) {
                Stream<List<Sample>> completeAlignedSignalsStream = request.getSampleList().stream().map(DatasourceConnectionV2Host::toSampleList);
                BiFunction<Integer, Stream<List<Sample>>, Stream<Sample>> scriptCallbackBiFunction = (numberOfSamplesInTestStream, testStream) -> calculationConnection.getCalculatedResults(request.getScript(), (Stream<List<Sample>>)testStream, signalDataType, numberOfSignals, (int)numberOfSamplesInTestStream, windowSize);
                detector.setAlignedSignalsStreamComplete(completeAlignedSignalsStream).setSignalFragmentScriptCaller(scriptCallbackBiFunction).setScriptName(request.getScript());
                detector.doValidate();
                if (detector.isValid()) {
                    calculationConnection.markAsValid();
                }
            }
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException((Throwable)e);
        }
        finally {
            validationLock.unlock();
        }
        Stream<List<Sample>> alignedSignalsStream = request.getSampleList().stream().map(DatasourceConnectionV2Host::toSampleList);
        try (Stream<Sample> results = calculationConnection.getCalculatedResults(request.getScript(), alignedSignalsStream, signalDataType, numberOfSignals, numberOfSamplesPerSignal, windowSize);){
            Iterator resultsIterator = results.iterator();
            while (resultsIterator.hasNext()) {
                RequestCancellation.check();
                Sample sample = (Sample)resultsIterator.next();
                response.addSample(DatasourceConnectionV2Host.externalCalculationValueBuilderFromSample(sample));
            }
        }
        return response.build();
    }

    static List<Sample> toSampleList(ExternalCalculationMessages.SampleMultivaluedData multiValueData) {
        long timestamp = multiValueData.getTimestamp();
        return multiValueData.getValueList().stream().map(value -> DatasourceConnectionV2Host.toSample(timestamp, value)).collect(Collectors.toList());
    }

    static Sample toSample(long timestamp, ExternalCalculationMessages.ValueData value) {
        Sample sample = new Sample();
        sample.setKey(new TimeInstant(timestamp));
        if (value.hasDataStatus() && value.getDataStatus() == ExternalCalculationMessages.DataStatus.BAD) {
            sample.setValue(null);
        } else if (value.hasDoubleValue()) {
            sample.setValue(value.getDoubleValue());
        } else if (value.hasStringValue()) {
            sample.setValue(value.getStringValue());
        } else {
            sample.setValue(null);
        }
        return sample;
    }

    static ExternalCalculationMessages.SampleData.Builder externalCalculationValueBuilderFromSample(Sample sample) {
        TimeInstant timeInstant = sample.getKey();
        long timestamp = timeInstant.getTimestamp();
        ExternalCalculationMessages.SampleData.Builder valueBuilder = ExternalCalculationMessages.SampleData.newBuilder();
        ExternalCalculationMessages.ValueData.Builder valueData = ExternalCalculationMessages.ValueData.newBuilder();
        valueBuilder.setTimestamp(timestamp);
        if (sample.getValue() != null) {
            if (sample.getValue().getClass().equals(Byte.class) || sample.getValue().getClass().equals(Short.class) || sample.getValue().getClass().equals(Integer.class) || sample.getValue().getClass().equals(Long.class) || sample.getValue().getClass().equals(Float.class) || sample.getValue().getClass().equals(Double.class)) {
                valueData.setDoubleValue(((Number)sample.getValue()).doubleValue());
            } else {
                valueData.setStringValue(sample.getValue().toString());
            }
        } else {
            valueData.setDataStatus(ExternalCalculationMessages.DataStatus.BAD);
        }
        valueBuilder.setValue(valueData);
        return valueBuilder;
    }

    static SignalConnectionMessages.SignalResponseMessage.SampleData.Builder signalValueBuilderFromSample(Sample sample) {
        TimeInstant timeInstant = sample.getKey();
        long timestamp = timeInstant.getTimestamp();
        SignalConnectionMessages.SignalResponseMessage.SampleData.Builder valueBuilder = SignalConnectionMessages.SignalResponseMessage.SampleData.newBuilder();
        valueBuilder.setTimestamp(timestamp);
        if (sample.getValue() != null) {
            if (sample.getValue().getClass().equals(Byte.class) || sample.getValue().getClass().equals(Short.class) || sample.getValue().getClass().equals(Integer.class) || sample.getValue().getClass().equals(Long.class)) {
                valueBuilder.setLongValue(((Number)sample.getValue()).longValue());
            } else if (sample.getValue().getClass().equals(Float.class) || sample.getValue().getClass().equals(Double.class)) {
                valueBuilder.setDoubleValue(((Number)sample.getValue()).doubleValue());
            } else if (sample.getValue().getClass().equals(Boolean.class)) {
                valueBuilder.setBooleanValue((Boolean)sample.getValue());
            } else {
                valueBuilder.setStringValue(sample.getValue().toString());
            }
        } else {
            valueBuilder.setDataStatus(SignalConnectionMessages.DataStatus.BAD);
        }
        return valueBuilder;
    }

    @Override
    public AuthConnectionMessages.AuthResponseMessage authRequest(AuthConnectionMessages.AuthRequestMessage request) {
        Preconditions.checkArgument((boolean)(this.connection instanceof AuthDatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain a AuthRequest only if the connection is an instance of AuthDatasourceConnection");
        AuthDatasourceConnection authConnection = (AuthDatasourceConnection)((Object)this.connection);
        AuthResult authResult = authConnection.authRequest(DatasourceConnectionV2Host.toAuthParameters(request));
        return DatasourceConnectionV2Host.toResponseMessage(authResult).build();
    }

    @Override
    public OAuth2ConnectionMessages.OAuth2AuthResponseMessage oAuth2AuthRequest(OAuth2ConnectionMessages.OAuth2AuthRequestMessage oAuth2AuthRequest) {
        Preconditions.checkArgument((boolean)(this.connection instanceof OAuth2DatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain an OAuth2 Request only if the connection is an instance of OAuth2DatasourceConnection");
        OAuth2AuthResult authResult = ((OAuth2DatasourceConnection)((Object)this.connection)).oAuth2AuthRequest(DatasourceConnectionV2Host.toOAuth2AuthParameters(oAuth2AuthRequest));
        return DatasourceConnectionV2Host.toResponseMessage(authResult).build();
    }

    @Override
    public OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage oAuth2PreAuthRequest(OAuth2ConnectionMessages.OAuth2PreAuthRequestMessage oAuth2PreAuthRequest) {
        Preconditions.checkArgument((boolean)(this.connection instanceof OAuth2DatasourceConnection), (Object)"AgentMessages.DataDocument protobuf can contain an OAuth2 Request only if the connection is an instance of OAuth2DatasourceConnection");
        OAuth2PreAuthResult preAuthResult = ((OAuth2DatasourceConnection)((Object)this.connection)).oAuth2PreAuthRequest(DatasourceConnectionV2Host.toOAuth2PreAuthParameters(oAuth2PreAuthRequest));
        return DatasourceConnectionV2Host.toResponseMessage(preAuthResult).build();
    }

    @VisibleForTesting
    static AuthConnectionMessages.AuthResponseMessage.Builder toResponseMessage(AuthResult authResult) {
        AuthConnectionMessages.AuthResponseMessage.Builder response = AuthConnectionMessages.AuthResponseMessage.newBuilder();
        response.setAuthenticated(authResult.isAuthenticated());
        Optional.ofNullable(authResult.getUserId()).ifPresent(response::setUserId);
        Optional.ofNullable(authResult.getSecurityId()).ifPresent(response::setSecurityId);
        Optional.ofNullable(authResult.getName()).ifPresent(response::setName);
        Optional.ofNullable(authResult.getEmailAddress()).ifPresent(response::setEmailAddress);
        Optional.ofNullable(authResult.getContinuation()).ifPresent(response::setContinuation);
        Optional.ofNullable(authResult.getFirstName()).ifPresent(response::setFirstName);
        Optional.ofNullable(authResult.getLastName()).ifPresent(response::setLastName);
        if (authResult.getGroups() != null) {
            authResult.getGroups().stream().map(DatasourceConnectionV2Host::toUserGroupInfo).forEach(response::addUserGroup);
            response.setUserGroupsProvided(true);
        }
        Optional.ofNullable(authResult.getErrorMessage()).ifPresent(response::setMessage);
        return response;
    }

    @VisibleForTesting
    static OAuth2ConnectionMessages.OAuth2AuthResponseMessage.Builder toResponseMessage(OAuth2AuthResult authResult) {
        OAuth2ConnectionMessages.OAuth2AuthResponseMessage.Builder response = OAuth2ConnectionMessages.OAuth2AuthResponseMessage.newBuilder();
        Optional.ofNullable(authResult.getAccessToken()).ifPresent(response::setAccessToken);
        Optional.ofNullable(authResult.getAuthenticated()).ifPresent(response::setAuthenticated);
        Optional.ofNullable(authResult.getEmailAddress()).ifPresent(response::setEmailAddress);
        Optional.ofNullable(authResult.getFirstName()).ifPresent(response::setFirstName);
        Optional.ofNullable(authResult.getLastName()).ifPresent(response::setLastName);
        Optional.ofNullable(authResult.getName()).ifPresent(response::setName);
        Optional.ofNullable(authResult.getSubject()).ifPresent(response::setSubject);
        if (authResult.getUserGroups() != null) {
            authResult.getUserGroups().stream().map(DatasourceConnectionV2Host::toOAuth2UserGroupInfo).forEach(response::addUserGroup);
        }
        response.setUserGroupsProvided(authResult.getUserGroups() != null);
        return response;
    }

    private static OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage.Builder toResponseMessage(OAuth2PreAuthResult preAuthResult) {
        OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage.Builder response = OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage.newBuilder();
        Optional.ofNullable(preAuthResult.getAuthorizationRequestURI()).ifPresent(response::setAuthorizationRequestURI);
        return response;
    }

    private static AuthConnectionMessages.AuthResponseMessage.UserGroupInfo toUserGroupInfo(GroupInfo group) {
        AuthConnectionMessages.AuthResponseMessage.UserGroupInfo.Builder userGroupInfoBuilder = AuthConnectionMessages.AuthResponseMessage.UserGroupInfo.newBuilder();
        Optional.ofNullable(group.getSecurityId()).ifPresent(userGroupInfoBuilder::setSecurityId);
        Optional.ofNullable(group.getName()).ifPresent(userGroupInfoBuilder::setName);
        return userGroupInfoBuilder.build();
    }

    private static OAuth2ConnectionMessages.OAuth2AuthResponseMessage.UserGroupInfo toOAuth2UserGroupInfo(GroupInfo group) {
        OAuth2ConnectionMessages.OAuth2AuthResponseMessage.UserGroupInfo.Builder userGroupInfoBuilder = OAuth2ConnectionMessages.OAuth2AuthResponseMessage.UserGroupInfo.newBuilder();
        Optional.ofNullable(group.getSecurityId()).ifPresent(userGroupInfoBuilder::setSecurityId);
        Optional.ofNullable(group.getName()).ifPresent(userGroupInfoBuilder::setName);
        return userGroupInfoBuilder.build();
    }

    private static AuthParameters toAuthParameters(AuthConnectionMessages.AuthRequestMessage request) {
        AuthParameters authParameters = new AuthParameters();
        if (request.hasUsername()) {
            authParameters.setUsername(request.getUsername());
        }
        if (request.hasPassword()) {
            authParameters.setPassword(request.getPassword());
        }
        if (request.hasSequenceId()) {
            authParameters.setSequenceId(request.getSequenceId());
        }
        return authParameters;
    }

    private static OAuth2PreAuthParameters toOAuth2PreAuthParameters(OAuth2ConnectionMessages.OAuth2PreAuthRequestMessage request) {
        return new OAuth2PreAuthParameters();
    }

    private static OAuth2AuthParameters toOAuth2AuthParameters(OAuth2ConnectionMessages.OAuth2AuthRequestMessage request) {
        OAuth2AuthParameters parameters = new OAuth2AuthParameters();
        if (request.hasCode()) {
            parameters.setCode(request.getCode());
        }
        if (request.hasState()) {
            parameters.setState(request.getState());
        }
        return parameters;
    }

    @Override
    public void saveConfig() {
        this.connection.saveConfig();
    }

    @FunctionalInterface
    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws ApiException;
    }

    @FunctionalInterface
    private static interface CheckedSupplier<T> {
        public T get() throws ApiException;
    }

    private static class RelationshipKey {
        private final String childId;
        private final String parentId;

        @ConstructorProperties(value={"childId", "parentId"})
        @Generated
        public RelationshipKey(String childId, String parentId) {
            this.childId = childId;
            this.parentId = parentId;
        }

        @Generated
        public String getChildId() {
            return this.childId;
        }

        @Generated
        public String getParentId() {
            return this.parentId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationshipKey)) {
                return false;
            }
            RelationshipKey other = (RelationshipKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$childId = this.getChildId();
            String other$childId = other.getChildId();
            if (this$childId == null ? other$childId != null : !this$childId.equals(other$childId)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelationshipKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $childId = this.getChildId();
            result = result * 59 + ($childId == null ? 43 : $childId.hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatasourceConnectionV2Host.RelationshipKey(childId=" + this.getChildId() + ", parentId=" + this.getParentId() + ")";
        }
    }
}

