/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.google.common.collect.ImmutableList;
import com.seeq.link.messages.agent.AgentMessages;
import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.DatasourceConnectionV2Host;
import com.seeq.link.sdk.interfaces.AgentService;
import com.seeq.link.sdk.interfaces.AuthDatasourceConnection;
import com.seeq.link.sdk.interfaces.ConditionPullDatasourceConnection;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.interfaces.Connector;
import com.seeq.link.sdk.interfaces.ConnectorServiceV2;
import com.seeq.link.sdk.interfaces.ConnectorV2;
import com.seeq.link.sdk.interfaces.DatasourceConnection;
import com.seeq.link.sdk.interfaces.DatasourceConnectionV2;
import com.seeq.link.sdk.interfaces.ExternalCalculationDatasourceConnection;
import com.seeq.link.sdk.interfaces.IndexingDatasourceConnection;
import com.seeq.link.sdk.interfaces.OAuth2DatasourceConnection;
import com.seeq.link.sdk.interfaces.SignalPullDatasourceConnection;
import com.seeq.link.sdk.utilities.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorV2Host
implements Connector,
ConnectorServiceV2 {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorV2Host.class);
    private final Logger guestLogger;
    private final ConnectorV2 connector;
    private ConfigObject config;
    private AgentService agentService;
    private final List<DatasourceConnectionV2Host> connections = new ArrayList<DatasourceConnectionV2Host>();
    private final Event<Connection.StateChangedEventArgs> connectionStateChangedEvent = new Event();

    public ConnectorV2Host(ConnectorV2 connector) {
        this.connector = connector;
        this.guestLogger = LoggerFactory.getLogger((String)("com.seeq.link.plugin." + this.connector.getClass().getSimpleName()));
    }

    @Override
    public Logger log() {
        return this.guestLogger;
    }

    @Override
    public String getName() {
        return this.connector.getName();
    }

    @Override
    public synchronized List<DatasourceConnection> getConnections() {
        return ImmutableList.copyOf(this.connections);
    }

    @Override
    public Event<Connection.StateChangedEventArgs> getConnectionStateChangedEvent() {
        return this.connectionStateChangedEvent;
    }

    public static AgentMessages.DatasourceService[] determineServices(DatasourceConnectionV2 connection) {
        ArrayList<AgentMessages.DatasourceService> connectionServices = new ArrayList<AgentMessages.DatasourceService>();
        if (connection instanceof SignalPullDatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.SIGNAL);
        }
        if (connection instanceof ConditionPullDatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.CONDITION);
        }
        if (connection instanceof ExternalCalculationDatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.EXTERNAL_CALC);
        }
        if (connection instanceof AuthDatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.AUTH);
        }
        if (connection instanceof OAuth2DatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.OAUTH2);
        }
        if (connection instanceof IndexingDatasourceConnection) {
            connectionServices.add(AgentMessages.DatasourceService.CONNECTION_INDEX);
        }
        if (connectionServices.size() == 0) {
            connectionServices.add(AgentMessages.DatasourceService.API_ONLY);
        }
        return connectionServices.toArray(new AgentMessages.DatasourceService[connectionServices.size()]);
    }

    @Override
    public synchronized void addConnection(DatasourceConnectionV2 connection) {
        Optional<DatasourceConnectionV2Host> maybeDuplicateConnectionHost = this.connections.stream().filter(c -> c.getDatasourceId().equals(connection.getDatasourceId()) || c.getDatasourceName().equals(connection.getDatasourceName())).findFirst();
        if (maybeDuplicateConnectionHost.isPresent()) {
            throw new IllegalArgumentException(String.format("Connections with duplicate name or ID detected:\n'%s' '%s'\n'%s' '%s'\nTo fix, edit the '%s.json' configuration file and provide unique names and IDs.", maybeDuplicateConnectionHost.get().getDatasourceId(), maybeDuplicateConnectionHost.get().getDatasourceName(), connection.getDatasourceId(), connection.getDatasourceName(), this.connector.getName()));
        }
        DatasourceConnectionV2Host connectionHost = new DatasourceConnectionV2Host(this.agentService, this, connection, ConnectorV2Host.determineServices(connection));
        connectionHost.getStateChangedEvent().add((sender, args) -> this.connectionStateChangedEvent.dispatch(args.getSender(), (Connection.StateChangedEventArgs)args));
        connectionHost.initialize();
        this.connections.add(connectionHost);
    }

    @Override
    public AgentService getAgentService() {
        return this.agentService;
    }

    @Override
    public synchronized void initialize(AgentService agentService) throws Exception {
        this.agentService = agentService;
        this.agentService.getConfigService().registerChangeCallback(this.connector.getName(), this::onConfigChanged);
        this.connector.initialize(this);
        this.agentService.markConnectionsAsReinitialized(this.getConnections().stream().map(DatasourceConnection::getConnectionId).collect(Collectors.toList()));
    }

    @Override
    public synchronized void destroy() {
        this.agentService.getConfigService().unregisterChangeCallback(this.connector.getName());
        for (DatasourceConnectionV2Host connection : this.connections) {
            try {
                connection.destroy();
            }
            catch (Exception e) {
                this.log().error("Error encountered destroying connection '{}'", (Object)connection.getConnectionId(), (Object)e);
            }
        }
        this.connections.clear();
        try {
            this.connector.destroy();
        }
        catch (Exception e) {
            this.log().error("Error encountered destroying connector '{}'", (Object)this.connector.getName(), (Object)e);
        }
    }

    @Override
    public boolean processMessage(String destinationConnectorInstanceId, AgentMessages.DataDocument document) {
        Optional<DatasourceConnectionV2Host> connection = this.connections.stream().filter(c -> c.getConnectionId().equals(destinationConnectorInstanceId)).findFirst();
        if (connection.isPresent()) {
            connection.get().processMessage(document);
            return true;
        }
        return false;
    }

    @Override
    public ConfigObject loadConfig(ConfigObject[] supportedObjects) throws IOException {
        this.config = this.agentService.getConfigService().loadConfigObject(this.getName(), supportedObjects);
        return this.config;
    }

    @Override
    public void saveConfig() {
        if (this.config == null) {
            return;
        }
        this.saveConfig(this.config);
    }

    @Override
    public void saveConfig(ConfigObject configObject) {
        this.config = configObject;
        this.agentService.getConfigService().saveConfigObject(this.getName(), this.config);
    }

    private synchronized void onConfigChanged(String name) {
        LOG.info("{} configuration changed", (Object)this.getName());
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error("Error destroying connector", (Throwable)e);
        }
        try {
            this.initialize(this.agentService);
        }
        catch (Exception e) {
            LOG.error("Error initializing connector", (Throwable)e);
        }
    }
}

