/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.google.common.base.Preconditions;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.utilities.Event;
import com.seeq.link.sdk.utilities.ThreadCollection;
import com.seeq.utilities.AutoResetEvent;
import com.seeq.utilities.BackoffRetryHelper;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnection
implements Connection {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(BaseConnection.class);
    private volatile Connection.ConnectionState state = Connection.ConnectionState.DISABLED;
    private String connectionMessage = "";
    protected Exception lastException;
    private final Event<Connection.StateChangedEventArgs> stateChangedEvent = new Event();
    private final Object setStateLock = new Object();
    private final AutoResetEvent connectionMonitorWakeup = new AutoResetEvent(false);
    private Duration currentReconnectDelay = Duration.ofSeconds(5L);
    private Duration maxReconnectDelay = Duration.ofMinutes(1L);
    private Duration minReconnectDelay = Duration.ofSeconds(5L);
    private BackoffRetryHelper retryHelper = new BackoffRetryHelper((double)this.minReconnectDelay.toMillis(), (double)this.maxReconnectDelay.toMillis(), new StopWatch());
    private Duration monitorPeriod = Duration.ofSeconds(5L);
    private final ThreadCollection backgroundThreads = new ThreadCollection(this.getClass().getName());

    @Override
    public abstract void initialize();

    @Override
    public abstract void destroy();

    @Override
    public Connection.ConnectionState getState() {
        return this.state;
    }

    @Override
    public String getConnectionMessage() {
        return this.connectionMessage;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public Event<Connection.StateChangedEventArgs> getStateChangedEvent() {
        return this.stateChangedEvent;
    }

    protected abstract String getConnectionId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Connection.ConnectionState newState, String message) {
        Object object = this.setStateLock;
        synchronized (object) {
            if (this.state == newState && Objects.equals(this.connectionMessage, message)) {
                return;
            }
            if (this.state == Connection.ConnectionState.DISABLED && (newState == Connection.ConnectionState.CONNECTED || newState == Connection.ConnectionState.DISCONNECTED)) {
                return;
            }
            this.state = newState;
            this.connectionMessage = message;
            LOG.info("{} connection state changed to {}. {}", new Object[]{this.getConnectionId(), newState, message});
            this.stateChangedEvent.dispatch(this, new Connection.StateChangedEventArgs(this, newState, message));
        }
    }

    private void connectionMonitor() {
        try {
            Thread.currentThread().setName(String.format("Connection: %s", this.getConnectionId()));
            while (true) {
                if (this.getState().equals((Object)Connection.ConnectionState.DISCONNECTED)) {
                    try {
                        this.connect();
                    }
                    catch (Exception e) {
                        this.handleConnectionMonitorException("connect()", e);
                    }
                }
                if (!this.getState().equals((Object)Connection.ConnectionState.DISCONNECTED)) {
                    try {
                        this.monitor();
                    }
                    catch (Exception e) {
                        this.handleConnectionMonitorException("monitor()", e);
                    }
                }
                if (this.getState().equals((Object)Connection.ConnectionState.DISCONNECTED)) {
                    LOG.info("Waiting {} seconds to attempt reconnect for {}", (Object)this.currentReconnectDelay.getSeconds(), (Object)this.getConnectionId());
                    this.connectionMonitorWakeup.waitOne(this.currentReconnectDelay);
                    this.retryHelper.advance();
                    this.currentReconnectDelay = Duration.ofMillis((long)this.retryHelper.getWaitInterval());
                    this.boundCurrentReconnectDelay();
                    continue;
                }
                this.connectionMonitorWakeup.waitOne(this.monitorPeriod);
                this.currentReconnectDelay = this.minReconnectDelay;
                this.retryHelper.reset();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected void handleConnectionMonitorException(String methodName, Exception exception) {
        LOG.error("Exception thrown by {} method:", (Object)methodName, (Object)exception);
    }

    @Override
    public Duration getMinReconnectDelay() {
        return this.minReconnectDelay;
    }

    @Override
    public void setMinReconnectDelay(Duration value) {
        Preconditions.checkArgument((value.toMillis() > 0L ? 1 : 0) != 0, (Object)"MinReconnectDelay cannot be zero");
        this.minReconnectDelay = value;
        this.boundCurrentReconnectDelay();
        this.initBackoffRetryHelper();
    }

    @Override
    public Duration getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    @Override
    public void setMaxReconnectDelay(Duration value) {
        Preconditions.checkArgument((value.toMillis() > 0L ? 1 : 0) != 0, (Object)"MaxReconnectDelay cannot be zero");
        this.maxReconnectDelay = value;
        this.boundCurrentReconnectDelay();
        this.initBackoffRetryHelper();
    }

    private void boundCurrentReconnectDelay() {
        if (this.currentReconnectDelay.compareTo(this.maxReconnectDelay) > 0) {
            this.currentReconnectDelay = this.maxReconnectDelay;
        }
        if (this.currentReconnectDelay.compareTo(this.minReconnectDelay) < 0) {
            this.currentReconnectDelay = this.minReconnectDelay;
        }
    }

    private void initBackoffRetryHelper() {
        this.retryHelper = new BackoffRetryHelper((double)this.minReconnectDelay.toMillis(), (double)this.maxReconnectDelay.toMillis(), new StopWatch());
    }

    @Override
    public Duration getMonitorPeriod() {
        return this.monitorPeriod;
    }

    @Override
    public void setMonitorPeriod(Duration value) {
        Preconditions.checkArgument((value.toMillis() > 0L ? 1 : 0) != 0, (Object)"MonitorPeriod cannot be zero");
        this.monitorPeriod = value;
    }

    public ThreadCollection getBackgroundThreads() {
        return this.backgroundThreads;
    }

    @Override
    public void enable() {
        if (this.getState() != Connection.ConnectionState.DISABLED) {
            LOG.warn("{} connection already enabled", (Object)this.getConnectionId());
            return;
        }
        LOG.info("{} connection enabled", (Object)this.getConnectionId());
        this.state = Connection.ConnectionState.DISCONNECTED;
        this.backgroundThreads.setID(this.getConnectionId());
        this.backgroundThreads.spawn(this::connectionMonitor);
    }

    @Override
    public void disable() {
        if (this.getState() == Connection.ConnectionState.DISABLED) {
            LOG.warn("{} connection already disabled", (Object)this.getConnectionId());
        } else {
            LOG.info("{} connection disabling", (Object)this.getConnectionId());
            this.setState(Connection.ConnectionState.DISABLED, "");
            LOG.info("{} connection disabled", (Object)this.getConnectionId());
            LOG.info("{} disconnecting", (Object)this.getConnectionId());
            this.disconnect();
        }
        this.backgroundThreads.shutDownAll();
    }

    protected abstract void connect();

    protected abstract void monitor();

    protected abstract void disconnect();
}

