/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.seeq.link.sdk.utilities.TimeInstant;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.format.DateTimeParseException;

public class TimeInterval {
    private final TimeInstant startTime;
    private final TimeInstant endTime;

    public TimeInterval(TimeInstant start, TimeInstant end) {
        this.startTime = start;
        this.endTime = end;
    }

    public TimeInstant getStartTime() {
        return this.startTime;
    }

    public TimeInstant getEndTime() {
        return this.endTime;
    }

    public static Duration parseFriendlyDuration(String durationString) {
        try {
            return Duration.parse(("PT" + durationString).toUpperCase());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("'%s' not a valid duration. Examples of valid durations: '1h', '5m', '30s'", durationString), e);
        }
    }

    public static String toFriendlyString(Duration duration) {
        double seconds;
        long minutes;
        String str = "";
        long hours = duration.toHours();
        if (hours != 0L) {
            str = str + String.format("%dh", hours);
        }
        if ((minutes = duration.toMinutes() % 60L) != 0L) {
            str = str + String.format("%dm", minutes);
        }
        if ((seconds = (double)(duration.getSeconds() % 60L) + (double)duration.getNano() / 1.0E9) != 0.0) {
            DecimalFormat df = new DecimalFormat("#.######");
            str = str + String.format("%ss", df.format(seconds));
        }
        return str;
    }
}

