/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.seeq.link.sdk.utilities.ClassPathUtilities;
import com.seeq.link.sdk.utilities.Stopwatch;
import com.seeq.utilities.exception.OperationCanceledException;
import com.seeq.utilities.process.StackTraceInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCollection {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(ThreadCollection.class);
    public static final int NO_TIMEOUT = -1;
    public static final int UNINTERRUPTABLE_ID = -1;
    private static final long DEFAULT_TIMEOUT_CHECK_INTERVAL = 60L;
    private static final TimeUnit DEFAULT_TIMEOUT_CHECK_UNIT = TimeUnit.SECONDS;
    private final Object lockObj = new Object();
    private String id;
    private ScheduledExecutorService scheduledExecutorService;
    private final long timeoutCheckInterval;
    private final TimeUnit timeoutCheckUnit;
    private final ConcurrentHashMap<Thread, ThreadInfo> threads = new ConcurrentHashMap();

    public ThreadCollection() {
        this("Thread Collection ID not set");
    }

    public ThreadCollection(String id) {
        this(id, 60L, DEFAULT_TIMEOUT_CHECK_UNIT);
    }

    @VisibleForTesting
    ThreadCollection(String id, long timeoutCheckInterval, TimeUnit timeoutCheckUnit) {
        this.id = id;
        this.timeoutCheckInterval = timeoutCheckInterval;
        this.timeoutCheckUnit = timeoutCheckUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMonitorIfNotRunning() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Seeq ThreadCollection [" + this.id + "] - Thread %d").build());
                this.scheduledExecutorService.scheduleAtFixedRate(() -> this.threads.values().forEach(threadInfo -> {
                    if (threadInfo.isTimedOut()) {
                        LOG.warn("Interrupting request {} which has run for longer than the timeout of {}ms", (Object)threadInfo.getThread().getName(), (Object)threadInfo.getTimeoutMillis());
                        threadInfo.getThread().interrupt();
                    }
                }), this.timeoutCheckInterval, this.timeoutCheckInterval, this.timeoutCheckUnit);
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Thread spawn(Runnable callback) {
        return this.spawn(callback, -1L, -1L, 5);
    }

    public Thread spawn(Runnable callback, int priority) {
        return this.spawn(callback, -1L, -1L, priority);
    }

    public Thread spawn(Runnable callback, long timeoutMillis, long requestId) {
        return this.spawn(callback, timeoutMillis, requestId, 5);
    }

    public Thread spawn(Runnable callback, long timeoutMillis, long requestId, int priority) {
        this.startMonitorIfNotRunning();
        Thread thread = new Thread(() -> {
            try {
                Thread.currentThread().setContextClassLoader(ClassPathUtilities.instance().getClassLoader());
                callback.run();
            }
            catch (Throwable e) {
                if (e instanceof OperationCanceledException) {
                    LOG.debug("Request {} canceled", (Object)requestId);
                } else {
                    LOG.error("Error in thread:", e);
                }
            }
            finally {
                this.threads.remove(Thread.currentThread());
            }
        });
        thread.setPriority(priority);
        this.threads.put(thread, new ThreadInfo(thread, timeoutMillis, requestId));
        thread.start();
        return thread;
    }

    public void interrupt(long requestId) {
        this.threads.values().stream().filter(threadInfo -> threadInfo.getRequestId() == requestId).forEach(threadInfo -> {
            LOG.info("Interrupting request with request ID {} due to cancellation or timeout", (Object)requestId);
            threadInfo.getThread().interrupt();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownAll() {
        Object object = this.lockObj;
        synchronized (object) {
            for (Thread thread : this.threads.keySet()) {
                this.shutdownThread(thread);
            }
            this.threads.clear();
            if (this.scheduledExecutorService != null) {
                LOG.debug("ThreadCollection[{}]: Shutting down monitor thread", (Object)this.id);
                this.scheduledExecutorService.shutdownNow();
                try {
                    this.scheduledExecutorService.awaitTermination(60L, DEFAULT_TIMEOUT_CHECK_UNIT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.scheduledExecutorService = null;
            }
        }
    }

    public int getCount() {
        return this.threads.size();
    }

    private void shutdownThread(Thread thread) {
        int timeoutInMilliseconds = 10000;
        LOG.info("{} shutting down thread: {}", (Object)this.id, (Object)thread.getName());
        while (true) {
            thread.interrupt();
            try {
                thread.join(10000L);
                if (!thread.isAlive()) break;
                LOG.info("{} continuing to try to shut down thread '{}'. Current stack trace:\n{}", new Object[]{this.id, thread.getName(), StackTraceInfo.getFullStackTrace((StackTraceElement[])thread.getStackTrace())});
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        LOG.info("{} successfully shut down thread: {}", (Object)this.id, (Object)thread.getName());
    }

    @VisibleForTesting
    protected boolean isShutdown() {
        return this.threads.isEmpty() && this.scheduledExecutorService == null;
    }

    private static class ThreadInfo {
        private final Thread thread;
        private final long timeoutMillis;
        private final long requestId;
        private final Stopwatch stopwatch;

        ThreadInfo(Thread thread, long timeoutMillis, long requestId) {
            this.thread = thread;
            this.timeoutMillis = timeoutMillis;
            this.requestId = requestId;
            this.stopwatch = new Stopwatch();
            this.stopwatch.start();
        }

        boolean isTimedOut() {
            return this.timeoutMillis >= 0L && this.stopwatch.elapsed(TimeUnit.MILLISECONDS) > this.timeoutMillis;
        }

        @Generated
        public Thread getThread() {
            return this.thread;
        }

        @Generated
        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @Generated
        public Stopwatch getStopwatch() {
            return this.stopwatch;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadInfo)) {
                return false;
            }
            ThreadInfo other = (ThreadInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeoutMillis() != other.getTimeoutMillis()) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            Thread this$thread = this.getThread();
            Thread other$thread = other.getThread();
            if (this$thread == null ? other$thread != null : !this$thread.equals(other$thread)) {
                return false;
            }
            Stopwatch this$stopwatch = this.getStopwatch();
            Stopwatch other$stopwatch = other.getStopwatch();
            return !(this$stopwatch == null ? other$stopwatch != null : !this$stopwatch.equals(other$stopwatch));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ThreadInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeoutMillis = this.getTimeoutMillis();
            result = result * 59 + (int)($timeoutMillis >>> 32 ^ $timeoutMillis);
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            Thread $thread = this.getThread();
            result = result * 59 + ($thread == null ? 43 : $thread.hashCode());
            Stopwatch $stopwatch = this.getStopwatch();
            result = result * 59 + ($stopwatch == null ? 43 : $stopwatch.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ThreadCollection.ThreadInfo(thread=" + this.getThread() + ", timeoutMillis=" + this.getTimeoutMillis() + ", requestId=" + this.getRequestId() + ", stopwatch=" + this.getStopwatch() + ")";
        }
    }
}

