/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class RequestTimings {
    public Duration datasourceDuration;
    public int datasourceSamplesCount;
    public int datasourceCapsulesCount;
    public Duration cacheDuration;
    public int cachePersistedSamplesCount;
    public int cachePersistedCapsulesCount;
    public int cacheInMemorySamplesCount;
    public int cacheInMemoryCapsulesCount;
    public Duration calcEngineProcessingDuration;
    public Duration calcEngineQueueDuration;
    public Duration requestQueueDuration;
    public Duration garbageCollectionDuration;
    public Duration metadataDuration;
    public int metadataItemsCount;
    public int metadataRelationshipsCount;

    private static Duration fromMillisecondsString(String milliseconds) {
        return Duration.of((long)(Float.parseFloat(milliseconds) * 1000.0f), ChronoUnit.MICROS);
    }

    public static RequestTimings fromApiResponseHeaders(Map<String, String> headers) {
        HashMap<String, String> pieces = new HashMap<String, String>();
        for (String header : new String[]{headers.get("Server-Timing"), headers.get("Server-Meters")}) {
            for (String tuple : header.split(",")) {
                HashMap<String, String> parts = new HashMap<String, String>();
                for (String part : tuple.split(";")) {
                    if (part.indexOf(61) == -1) continue;
                    String key = part.substring(0, part.indexOf(61));
                    String value = part.substring(part.indexOf(61) + 1);
                    parts.put(key, value);
                }
                pieces.put(((String)parts.get("desc")).replace("\"", ""), (String)parts.get("dur"));
            }
        }
        RequestTimings requestTimings = new RequestTimings();
        requestTimings.setDatasourceDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Datasource")));
        requestTimings.setDatasourceSamplesCount((int)Float.parseFloat((String)pieces.get("Datasource Samples Read")));
        requestTimings.setDatasourceCapsulesCount((int)Float.parseFloat((String)pieces.get("Datasource Capsules Read")));
        requestTimings.setCacheDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Cache")));
        requestTimings.setCachePersistedSamplesCount((int)Float.parseFloat((String)pieces.get("Cache Samples Read")));
        requestTimings.setCachePersistedCapsulesCount((int)Float.parseFloat((String)pieces.get("Cache Capsules Read")));
        requestTimings.setCacheInMemorySamplesCount((int)Float.parseFloat((String)pieces.get("Cache In-Memory Samples Read")));
        requestTimings.setCacheInMemoryCapsulesCount((int)Float.parseFloat((String)pieces.get("Cache In-Memory Capsules Read")));
        requestTimings.setCalcEngineProcessingDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Processing")));
        requestTimings.setCalcEngineQueueDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Calc Engine Queue")));
        requestTimings.setRequestQueueDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Request Queue")));
        requestTimings.setGarbageCollectionDuration(RequestTimings.fromMillisecondsString((String)pieces.get("GC")));
        requestTimings.setMetadataDuration(RequestTimings.fromMillisecondsString((String)pieces.get("Seeq Database")));
        requestTimings.setMetadataItemsCount((int)Float.parseFloat((String)pieces.get("Database Items Read")));
        requestTimings.setMetadataRelationshipsCount((int)Float.parseFloat((String)pieces.get("Database Relationships Read")));
        return requestTimings;
    }

    @Generated
    public RequestTimings() {
    }

    @Generated
    public Duration getDatasourceDuration() {
        return this.datasourceDuration;
    }

    @Generated
    public int getDatasourceSamplesCount() {
        return this.datasourceSamplesCount;
    }

    @Generated
    public int getDatasourceCapsulesCount() {
        return this.datasourceCapsulesCount;
    }

    @Generated
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Generated
    public int getCachePersistedSamplesCount() {
        return this.cachePersistedSamplesCount;
    }

    @Generated
    public int getCachePersistedCapsulesCount() {
        return this.cachePersistedCapsulesCount;
    }

    @Generated
    public int getCacheInMemorySamplesCount() {
        return this.cacheInMemorySamplesCount;
    }

    @Generated
    public int getCacheInMemoryCapsulesCount() {
        return this.cacheInMemoryCapsulesCount;
    }

    @Generated
    public Duration getCalcEngineProcessingDuration() {
        return this.calcEngineProcessingDuration;
    }

    @Generated
    public Duration getCalcEngineQueueDuration() {
        return this.calcEngineQueueDuration;
    }

    @Generated
    public Duration getRequestQueueDuration() {
        return this.requestQueueDuration;
    }

    @Generated
    public Duration getGarbageCollectionDuration() {
        return this.garbageCollectionDuration;
    }

    @Generated
    public Duration getMetadataDuration() {
        return this.metadataDuration;
    }

    @Generated
    public int getMetadataItemsCount() {
        return this.metadataItemsCount;
    }

    @Generated
    public int getMetadataRelationshipsCount() {
        return this.metadataRelationshipsCount;
    }

    @Generated
    public RequestTimings setDatasourceDuration(Duration datasourceDuration) {
        this.datasourceDuration = datasourceDuration;
        return this;
    }

    @Generated
    public RequestTimings setDatasourceSamplesCount(int datasourceSamplesCount) {
        this.datasourceSamplesCount = datasourceSamplesCount;
        return this;
    }

    @Generated
    public RequestTimings setDatasourceCapsulesCount(int datasourceCapsulesCount) {
        this.datasourceCapsulesCount = datasourceCapsulesCount;
        return this;
    }

    @Generated
    public RequestTimings setCacheDuration(Duration cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    @Generated
    public RequestTimings setCachePersistedSamplesCount(int cachePersistedSamplesCount) {
        this.cachePersistedSamplesCount = cachePersistedSamplesCount;
        return this;
    }

    @Generated
    public RequestTimings setCachePersistedCapsulesCount(int cachePersistedCapsulesCount) {
        this.cachePersistedCapsulesCount = cachePersistedCapsulesCount;
        return this;
    }

    @Generated
    public RequestTimings setCacheInMemorySamplesCount(int cacheInMemorySamplesCount) {
        this.cacheInMemorySamplesCount = cacheInMemorySamplesCount;
        return this;
    }

    @Generated
    public RequestTimings setCacheInMemoryCapsulesCount(int cacheInMemoryCapsulesCount) {
        this.cacheInMemoryCapsulesCount = cacheInMemoryCapsulesCount;
        return this;
    }

    @Generated
    public RequestTimings setCalcEngineProcessingDuration(Duration calcEngineProcessingDuration) {
        this.calcEngineProcessingDuration = calcEngineProcessingDuration;
        return this;
    }

    @Generated
    public RequestTimings setCalcEngineQueueDuration(Duration calcEngineQueueDuration) {
        this.calcEngineQueueDuration = calcEngineQueueDuration;
        return this;
    }

    @Generated
    public RequestTimings setRequestQueueDuration(Duration requestQueueDuration) {
        this.requestQueueDuration = requestQueueDuration;
        return this;
    }

    @Generated
    public RequestTimings setGarbageCollectionDuration(Duration garbageCollectionDuration) {
        this.garbageCollectionDuration = garbageCollectionDuration;
        return this;
    }

    @Generated
    public RequestTimings setMetadataDuration(Duration metadataDuration) {
        this.metadataDuration = metadataDuration;
        return this;
    }

    @Generated
    public RequestTimings setMetadataItemsCount(int metadataItemsCount) {
        this.metadataItemsCount = metadataItemsCount;
        return this;
    }

    @Generated
    public RequestTimings setMetadataRelationshipsCount(int metadataRelationshipsCount) {
        this.metadataRelationshipsCount = metadataRelationshipsCount;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestTimings)) {
            return false;
        }
        RequestTimings other = (RequestTimings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDatasourceSamplesCount() != other.getDatasourceSamplesCount()) {
            return false;
        }
        if (this.getDatasourceCapsulesCount() != other.getDatasourceCapsulesCount()) {
            return false;
        }
        if (this.getCachePersistedSamplesCount() != other.getCachePersistedSamplesCount()) {
            return false;
        }
        if (this.getCachePersistedCapsulesCount() != other.getCachePersistedCapsulesCount()) {
            return false;
        }
        if (this.getCacheInMemorySamplesCount() != other.getCacheInMemorySamplesCount()) {
            return false;
        }
        if (this.getCacheInMemoryCapsulesCount() != other.getCacheInMemoryCapsulesCount()) {
            return false;
        }
        if (this.getMetadataItemsCount() != other.getMetadataItemsCount()) {
            return false;
        }
        if (this.getMetadataRelationshipsCount() != other.getMetadataRelationshipsCount()) {
            return false;
        }
        Duration this$datasourceDuration = this.getDatasourceDuration();
        Duration other$datasourceDuration = other.getDatasourceDuration();
        if (this$datasourceDuration == null ? other$datasourceDuration != null : !((Object)this$datasourceDuration).equals(other$datasourceDuration)) {
            return false;
        }
        Duration this$cacheDuration = this.getCacheDuration();
        Duration other$cacheDuration = other.getCacheDuration();
        if (this$cacheDuration == null ? other$cacheDuration != null : !((Object)this$cacheDuration).equals(other$cacheDuration)) {
            return false;
        }
        Duration this$calcEngineProcessingDuration = this.getCalcEngineProcessingDuration();
        Duration other$calcEngineProcessingDuration = other.getCalcEngineProcessingDuration();
        if (this$calcEngineProcessingDuration == null ? other$calcEngineProcessingDuration != null : !((Object)this$calcEngineProcessingDuration).equals(other$calcEngineProcessingDuration)) {
            return false;
        }
        Duration this$calcEngineQueueDuration = this.getCalcEngineQueueDuration();
        Duration other$calcEngineQueueDuration = other.getCalcEngineQueueDuration();
        if (this$calcEngineQueueDuration == null ? other$calcEngineQueueDuration != null : !((Object)this$calcEngineQueueDuration).equals(other$calcEngineQueueDuration)) {
            return false;
        }
        Duration this$requestQueueDuration = this.getRequestQueueDuration();
        Duration other$requestQueueDuration = other.getRequestQueueDuration();
        if (this$requestQueueDuration == null ? other$requestQueueDuration != null : !((Object)this$requestQueueDuration).equals(other$requestQueueDuration)) {
            return false;
        }
        Duration this$garbageCollectionDuration = this.getGarbageCollectionDuration();
        Duration other$garbageCollectionDuration = other.getGarbageCollectionDuration();
        if (this$garbageCollectionDuration == null ? other$garbageCollectionDuration != null : !((Object)this$garbageCollectionDuration).equals(other$garbageCollectionDuration)) {
            return false;
        }
        Duration this$metadataDuration = this.getMetadataDuration();
        Duration other$metadataDuration = other.getMetadataDuration();
        return !(this$metadataDuration == null ? other$metadataDuration != null : !((Object)this$metadataDuration).equals(other$metadataDuration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestTimings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDatasourceSamplesCount();
        result = result * 59 + this.getDatasourceCapsulesCount();
        result = result * 59 + this.getCachePersistedSamplesCount();
        result = result * 59 + this.getCachePersistedCapsulesCount();
        result = result * 59 + this.getCacheInMemorySamplesCount();
        result = result * 59 + this.getCacheInMemoryCapsulesCount();
        result = result * 59 + this.getMetadataItemsCount();
        result = result * 59 + this.getMetadataRelationshipsCount();
        Duration $datasourceDuration = this.getDatasourceDuration();
        result = result * 59 + ($datasourceDuration == null ? 43 : ((Object)$datasourceDuration).hashCode());
        Duration $cacheDuration = this.getCacheDuration();
        result = result * 59 + ($cacheDuration == null ? 43 : ((Object)$cacheDuration).hashCode());
        Duration $calcEngineProcessingDuration = this.getCalcEngineProcessingDuration();
        result = result * 59 + ($calcEngineProcessingDuration == null ? 43 : ((Object)$calcEngineProcessingDuration).hashCode());
        Duration $calcEngineQueueDuration = this.getCalcEngineQueueDuration();
        result = result * 59 + ($calcEngineQueueDuration == null ? 43 : ((Object)$calcEngineQueueDuration).hashCode());
        Duration $requestQueueDuration = this.getRequestQueueDuration();
        result = result * 59 + ($requestQueueDuration == null ? 43 : ((Object)$requestQueueDuration).hashCode());
        Duration $garbageCollectionDuration = this.getGarbageCollectionDuration();
        result = result * 59 + ($garbageCollectionDuration == null ? 43 : ((Object)$garbageCollectionDuration).hashCode());
        Duration $metadataDuration = this.getMetadataDuration();
        result = result * 59 + ($metadataDuration == null ? 43 : ((Object)$metadataDuration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequestTimings(datasourceDuration=" + this.getDatasourceDuration() + ", datasourceSamplesCount=" + this.getDatasourceSamplesCount() + ", datasourceCapsulesCount=" + this.getDatasourceCapsulesCount() + ", cacheDuration=" + this.getCacheDuration() + ", cachePersistedSamplesCount=" + this.getCachePersistedSamplesCount() + ", cachePersistedCapsulesCount=" + this.getCachePersistedCapsulesCount() + ", cacheInMemorySamplesCount=" + this.getCacheInMemorySamplesCount() + ", cacheInMemoryCapsulesCount=" + this.getCacheInMemoryCapsulesCount() + ", calcEngineProcessingDuration=" + this.getCalcEngineProcessingDuration() + ", calcEngineQueueDuration=" + this.getCalcEngineQueueDuration() + ", requestQueueDuration=" + this.getRequestQueueDuration() + ", garbageCollectionDuration=" + this.getGarbageCollectionDuration() + ", metadataDuration=" + this.getMetadataDuration() + ", metadataItemsCount=" + this.getMetadataItemsCount() + ", metadataRelationshipsCount=" + this.getMetadataRelationshipsCount() + ")";
    }
}

