/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemGlob {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemGlob.class);

    private static List<Path> walkDirectoryTree(Path root) {
        return FileSystemGlob.walkDirectoryTree(root, root.toString());
    }

    private static List<Path> walkDirectoryTree(final Path root, String relativizeWith) {
        if (relativizeWith.charAt(relativizeWith.length() - 1) != File.separatorChar) {
            relativizeWith = relativizeWith + File.separatorChar;
        }
        final ArrayList<Path> fileList = new ArrayList<Path>();
        final String relativizeWithFinal = relativizeWith;
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    fileList.add(Paths.get(file.toString().replace(relativizeWithFinal, ""), new String[0]));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(root)) {
                        fileList.add(Paths.get(dir.toString().replace(relativizeWithFinal, ""), new String[0]));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            return new ArrayList<Path>();
        }
        return fileList;
    }

    public static List<Path> find(String globPattern, Path rootForRelativePaths) {
        String pattern;
        if (globPattern.length() == 0) {
            return new ArrayList<Path>();
        }
        globPattern = globPattern.replaceAll("/", "\\" + File.separatorChar);
        String[] pieces = globPattern.split("\\" + File.separatorChar);
        ArrayList<String> rootPieces = new ArrayList<String>();
        ArrayList<String> patternPieces = null;
        for (String piece : pieces) {
            if (patternPieces != null || piece.contains("*") || piece.contains("?")) {
                if (patternPieces == null) {
                    patternPieces = new ArrayList<String>();
                }
                patternPieces.add(piece);
                continue;
            }
            rootPieces.add(piece);
        }
        Path root = Paths.get(String.join((CharSequence)Character.toString(File.separatorChar), rootPieces), new String[0]);
        if (patternPieces == null) {
            pattern = root.getFileName().toString();
            if ((root = root.getParent()) == null) {
                root = Paths.get("", new String[0]);
            }
        } else {
            pattern = String.join((CharSequence)"/", patternPieces);
        }
        if (!root.isAbsolute()) {
            try {
                root = Paths.get(rootForRelativePaths.resolve(root).toFile().getCanonicalFile().toString(), new String[0]);
            }
            catch (IOException e) {
                return new ArrayList<Path>();
            }
        }
        List<Path> potentialFiles = FileSystemGlob.walkDirectoryTree(root);
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        LOG.info("Filter all items in '{}' via '{}' matcher", (Object)root, (Object)pattern);
        ArrayList<Path> filteredFiles = new ArrayList<Path>();
        for (Path potentialFile : potentialFiles) {
            if (!pathMatcher.matches(potentialFile)) continue;
            filteredFiles.add(potentialFile);
        }
        ArrayList<Path> finalFiles = new ArrayList<Path>();
        for (Path filteredFile : filteredFiles) {
            Path fullPath = root.resolve(filteredFile);
            finalFiles.add(fullPath);
            LOG.info("Found next matched file: '{}'", (Object)fullPath);
        }
        return finalFiles;
    }
}

