/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.seeq.link.sdk.utilities.EventListener;
import java.util.Arrays;

public class Event<M> {
    private Object[] listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerRegistration add(EventListener<M> listener) {
        Event event = this;
        synchronized (event) {
            if (this.listeners == null) {
                this.listeners = new Object[]{listener};
            } else {
                this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
                this.listeners[this.listeners.length - 1] = listener;
            }
        }
        return new ListenerRegistration(this, listener);
    }

    public void dispatch(Object source, M message) {
        Object[] local = this.listeners;
        if (local != null) {
            for (Object listener : local) {
                ((EventListener)listener).onNotify(source, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EventListener<?> listener) {
        Event event = this;
        synchronized (event) {
            if (this.listeners.length > 1) {
                Object[] newObservers = new Object[this.listeners.length - 1];
                int j = 0;
                for (int i = 0; i < this.listeners.length; ++i) {
                    if (this.listeners[i].equals(listener)) continue;
                    newObservers[j++] = this.listeners[i];
                }
                this.listeners = newObservers;
            } else {
                this.listeners = null;
            }
        }
    }

    public static class ListenerRegistration {
        private final Event<?> event;
        private final EventListener<?> listener;
        private boolean unregistered;

        private <M> ListenerRegistration(Event<M> event, EventListener<M> listener) {
            this.event = event;
            this.listener = listener;
        }

        public void remove() {
            if (!this.unregistered) {
                this.unregistered = true;
                this.event.remove(this.listener);
            }
        }

        public boolean isSubscribed() {
            return !this.unregistered;
        }
    }
}

