/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationHelper {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DurationHelper.class);

    public static ParsedDuration parseConfigString(String durationString, String defaultDurationString, String variableName) {
        if (durationString == null) {
            LOG.info("{} is null, using default ({})", (Object)variableName, (Object)defaultDurationString);
            return DurationHelper.parseConfigString(defaultDurationString, defaultDurationString, variableName);
        }
        Pattern regex = Pattern.compile("\\s*(\\d+)\\s*(\\w+)\\s*");
        Matcher matcher = regex.matcher(durationString);
        if (!matcher.matches()) {
            LOG.error("Could not parse {} '{}', setting to default ({})", new Object[]{variableName, durationString, defaultDurationString});
            durationString = defaultDurationString;
            matcher = regex.matcher(defaultDurationString);
            matcher.matches();
        }
        int quantity = Integer.parseInt(matcher.group(1));
        String unit = matcher.group(2).toLowerCase();
        if (unit.startsWith("y")) {
            return new ParsedDuration(Period.ofYears(quantity), durationString);
        }
        if (unit.startsWith("mo")) {
            return new ParsedDuration(Period.ofMonths(quantity), durationString);
        }
        if (unit.startsWith("w")) {
            return new ParsedDuration(Period.ofWeeks(quantity), durationString);
        }
        if (unit.startsWith("d")) {
            return new ParsedDuration(Period.ofDays(quantity), durationString);
        }
        if (unit.startsWith("h")) {
            return new ParsedDuration(Duration.ofHours(quantity), durationString);
        }
        if (unit.startsWith("min")) {
            return new ParsedDuration(Duration.ofMinutes(quantity), durationString);
        }
        if (unit.startsWith("s")) {
            return new ParsedDuration(Duration.ofSeconds(quantity), durationString);
        }
        LOG.error("Unrecognized time unit on {} '{}', setting to default ({})", new Object[]{variableName, durationString, defaultDurationString});
        return DurationHelper.parseConfigString(defaultDurationString, defaultDurationString, variableName);
    }

    public static class ParsedDuration {
        TemporalAmount amount;
        String usedDurationString;

        public Duration asDuration() {
            return Duration.from(this.amount);
        }

        @Generated
        public TemporalAmount getAmount() {
            return this.amount;
        }

        @Generated
        public String getUsedDurationString() {
            return this.usedDurationString;
        }

        @Generated
        public ParsedDuration setAmount(TemporalAmount amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public ParsedDuration setUsedDurationString(String usedDurationString) {
            this.usedDurationString = usedDurationString;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedDuration)) {
                return false;
            }
            ParsedDuration other = (ParsedDuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TemporalAmount this$amount = this.getAmount();
            TemporalAmount other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
                return false;
            }
            String this$usedDurationString = this.getUsedDurationString();
            String other$usedDurationString = other.getUsedDurationString();
            return !(this$usedDurationString == null ? other$usedDurationString != null : !this$usedDurationString.equals(other$usedDurationString));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParsedDuration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TemporalAmount $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
            String $usedDurationString = this.getUsedDurationString();
            result = result * 59 + ($usedDurationString == null ? 43 : $usedDurationString.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DurationHelper.ParsedDuration(amount=" + this.getAmount() + ", usedDurationString=" + this.getUsedDurationString() + ")";
        }

        @ConstructorProperties(value={"amount", "usedDurationString"})
        @Generated
        public ParsedDuration(TemporalAmount amount, String usedDurationString) {
            this.amount = amount;
            this.usedDurationString = usedDurationString;
        }
    }
}

