/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ConnectorHelper {
    private final Map<String, String> uniqueIdMap = new HashMap<String, String>();
    private final Set<String> uniqueNameSet = new HashSet<String>();

    public boolean isIdUnique(String connectionId, String connectionName, String connectorName, Logger LOG) {
        if (this.uniqueIdMap.containsKey(connectionId)) {
            LOG.error("'{}' has the same ID {} as '{}'. To connect, edit the configuration file '{}.json' to give '{}' a unique ID.", new Object[]{connectionName, connectionId, this.uniqueIdMap.get(connectionId), connectorName, connectionName});
            return false;
        }
        if (this.uniqueNameSet.contains(connectionName)) {
            LOG.error("'{}' has the same name as another connection of the same type. To connect, edit the configuration file '{}.json' to give it a unique name.", (Object)connectionName, (Object)connectorName);
            return false;
        }
        this.uniqueIdMap.put(connectionId, connectionName);
        this.uniqueNameSet.add(connectionName);
        return true;
    }
}

