/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.seeq.link.messages.connector.condition.ConditionConnectionMessages;
import com.seeq.link.sdk.utilities.TimeInstant;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class Capsule {
    public final TimeInstant start;
    public final TimeInstant end;
    public final List<Property> properties;

    public Capsule(TimeInstant start, TimeInstant end, List<Property> properties) {
        Preconditions.checkArgument((start.getTimestamp() <= end.getTimestamp() ? 1 : 0) != 0, (Object)"Start must be less than or equal to end");
        Preconditions.checkArgument((properties.stream().map(Property::getName).distinct().count() == (long)properties.size() ? 1 : 0) != 0, (Object)"Properties should only contain one of each name");
        this.start = start;
        this.end = end;
        this.properties = (List)properties.stream().filter(p -> p.getName() != null).filter(p -> p.getValue() != null).filter(p -> !p.getValue().trim().isEmpty()).filter(p -> !p.getName().trim().isEmpty()).collect(ImmutableList.toImmutableList());
    }

    public ConditionConnectionMessages.ConditionResponseMessage.CapsuleData toMessage() {
        return ConditionConnectionMessages.ConditionResponseMessage.CapsuleData.newBuilder().setStart(this.start.getTimestamp()).setEnd(this.end.getTimestamp()).addAllProperty(this.properties.stream().map(Property::toMessage).collect(Collectors.toList())).build();
    }

    @Generated
    public TimeInstant getStart() {
        return this.start;
    }

    @Generated
    public TimeInstant getEnd() {
        return this.end;
    }

    @Generated
    public List<Property> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capsule)) {
            return false;
        }
        Capsule other = (Capsule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeInstant this$start = this.getStart();
        TimeInstant other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        TimeInstant this$end = this.getEnd();
        TimeInstant other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Capsule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimeInstant $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        TimeInstant $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Capsule(start=" + this.getStart() + ", end=" + this.getEnd() + ", properties=" + this.getProperties() + ")";
    }

    public static class Property {
        final String name;
        final String value;
        final String unit;

        public Property(String name, String value, String unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }

        ConditionConnectionMessages.ConditionResponseMessage.CapsuleData.Property toMessage() {
            return ConditionConnectionMessages.ConditionResponseMessage.CapsuleData.Property.newBuilder().setName(this.name).setValue(this.value).setUnits(this.unit).build();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Capsule.Property(name=" + this.getName() + ", value=" + this.getValue() + ", unit=" + this.getUnit() + ")";
        }
    }
}

