/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.utilities;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.seeq.api.DatasourcesApi;
import com.seeq.link.sdk.interfaces.DatasourceConnectionServiceV2;
import com.seeq.model.DatasourceOutputListV1;
import com.seeq.model.DatasourceOutputV1;
import com.seeq.model.ScalarPropertyV1;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AuthConnectionHelper {
    public static Set<String> getGroupsToSyncForDatasource(String datasourceClass, String datasourceId, DatasourceConnectionServiceV2 connectionService) {
        final DatasourcesApi datasourcesApi = connectionService.getAgentService().getApiProvider().createDatasourcesApi();
        AbstractIterator<Iterator<DatasourceOutputV1>> allDatasourcesIterators = new AbstractIterator<Iterator<DatasourceOutputV1>>(){
            private static final int CHUNK_SIZE = 100;
            private int offset = 0;
            private boolean reachedTheEnd = false;

            protected Iterator<DatasourceOutputV1> computeNext() {
                if (this.reachedTheEnd) {
                    return (Iterator)this.endOfData();
                }
                DatasourceOutputListV1 datasources = datasourcesApi.getDatasources(null, null, Integer.valueOf(this.offset), Integer.valueOf(100), Boolean.valueOf(false));
                this.offset += 100;
                if (datasources.getNext() == null) {
                    this.reachedTheEnd = true;
                }
                return datasources.getDatasources().iterator();
            }
        };
        ScalarPropertyV1 referencedDatasourceClass = new ScalarPropertyV1().name("Referenced Datasource Class").value((Object)datasourceClass).unitOfMeasure("string");
        ScalarPropertyV1 referencedDatasourceId = new ScalarPropertyV1().name("Referenced Datasource ID").value((Object)datasourceId).unitOfMeasure("string");
        return Streams.stream((Iterator)Iterators.concat((Iterator)allDatasourcesIterators)).filter(d -> {
            List additionalProperties = d.getAdditionalProperties();
            return additionalProperties.contains(referencedDatasourceClass) && additionalProperties.contains(referencedDatasourceId);
        }).flatMap(d -> d.getAdditionalProperties().stream()).filter(p -> p.getName().equals("Additional Groups To Sync")).map(ScalarPropertyV1::getValue).filter(v -> v instanceof String).map(v -> (String)v).map(g2syncStr -> Arrays.asList(g2syncStr.split("\\s*,\\s*"))).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

