/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.seeq.link.sdk.services.Transformable;
import com.seeq.link.sdk.services.TransformableAsset;
import com.seeq.link.sdk.services.TransformableCondition;
import com.seeq.link.sdk.services.TransformableScalar;
import com.seeq.link.sdk.services.TransformableSignal;
import com.seeq.link.sdk.services.TransformableUserGroup;
import com.seeq.model.AssetInputV1;
import com.seeq.model.ConditionInputV1;
import com.seeq.model.ScalarInputV1;
import com.seeq.model.SignalWithIdInputV1;
import com.seeq.model.UserGroupWithIdInputV1;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyTransformer {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(PropertyTransformer.class);

    public static ScalarInputV1 transform(ScalarInputV1 input, List<Spec> transforms) {
        return PropertyTransformer.transform(new TransformableScalar(input), transforms).getInputObject();
    }

    public static SignalWithIdInputV1 transform(SignalWithIdInputV1 input, List<Spec> transforms) {
        return PropertyTransformer.transform(new TransformableSignal(input), transforms).getInputObject();
    }

    public static UserGroupWithIdInputV1 transform(UserGroupWithIdInputV1 input, List<Spec> transforms) {
        return PropertyTransformer.transform(new TransformableUserGroup(input), transforms).getInputObject();
    }

    public static ConditionInputV1 transform(ConditionInputV1 input, List<Spec> transforms) {
        return PropertyTransformer.transform(new TransformableCondition(input), transforms).getInputObject();
    }

    public static AssetInputV1 transform(AssetInputV1 input, List<Spec> transforms) {
        return PropertyTransformer.transform(new TransformableAsset(input), transforms).getInputObject();
    }

    public static <T> Transformable<T> transform(Transformable<T> input, List<Spec> transforms) {
        Transformable<T> output = input.copy();
        for (Spec transform : transforms) {
            HashMap<String, String> variables = new HashMap<String, String>();
            boolean isMatch = true;
            for (Input transformInput : transform.getInputs()) {
                Object inputValueObject = transformInput.getValue();
                Object propertyValueObject = output.getProperty(transformInput.getProperty());
                if (inputValueObject instanceof String) {
                    String propertyValueString = PropertyTransformer.toStr(propertyValueObject);
                    if (propertyValueString == null) {
                        isMatch = false;
                        break;
                    }
                    String inputValueString = (String)inputValueObject;
                    Pattern regex = Pattern.compile((String)inputValueString);
                    Matcher matcher = regex.matcher((CharSequence)propertyValueString);
                    if (!matcher.matches()) {
                        isMatch = false;
                        break;
                    }
                    for (String groupName : regex.groupNames()) {
                        if (groupName.equals("0")) continue;
                        String group = matcher.group(groupName);
                        variables.put(groupName, group);
                    }
                    continue;
                }
                isMatch = Objects.equals(inputValueObject, propertyValueObject);
            }
            if (!isMatch) continue;
            for (Output transformOutput : transform.getOutputs()) {
                Object outputValueObject;
                Object newPropertyObject = outputValueObject = transformOutput.getValue();
                String newPropertyUnits = transformOutput.getUnitOfMeasure();
                if (outputValueObject instanceof String) {
                    String newPropertyString = (String)outputValueObject;
                    for (Map.Entry entry : variables.entrySet()) {
                        newPropertyString = newPropertyString.replace("${" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                        if (newPropertyUnits == null) continue;
                        newPropertyUnits = newPropertyUnits.replace("${" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
                    }
                    if (transform.isLog()) {
                        if (Pattern.compile((String)"\\$\\{[^\\}]+\\}").matcher((CharSequence)newPropertyString).matches()) {
                            LOG.error("Variable(s) in output were not found in capture groups: {}", (Object)newPropertyString);
                        }
                        LOG.debug("Transforming: '{}' Property: '{}' Transform: '{}' --> '{}{}' {}", new Object[]{input.toString(), transformOutput.getProperty(), output.getProperty(transformOutput.getProperty()), newPropertyString, newPropertyUnits == null ? "" : newPropertyUnits, transform.isEnabled() ? "" : "<<DISABLED>>"});
                    }
                    newPropertyObject = newPropertyString;
                }
                if (newPropertyUnits != null && newPropertyObject instanceof String) {
                    try {
                        newPropertyObject = Long.parseLong((String)newPropertyObject);
                    }
                    catch (NumberFormatException e) {
                        try {
                            newPropertyObject = Double.parseDouble((String)newPropertyObject);
                        }
                        catch (NumberFormatException e2) {
                            if (transform.isLog()) {
                                LOG.warn("Unable to parse {} as numeric; units {} will be ignored", newPropertyObject, (Object)newPropertyUnits);
                            }
                            newPropertyUnits = null;
                        }
                    }
                }
                if (!transform.isEnabled()) continue;
                output.setProperty(transformOutput.getProperty(), newPropertyObject, newPropertyUnits);
            }
        }
        return output;
    }

    public static String toStr(Object s) {
        return s == null ? null : s.toString();
    }

    @Generated
    private PropertyTransformer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Spec {
        private List<Input> inputs = new ArrayList<Input>();
        private List<Output> outputs = new ArrayList<Output>();
        private boolean enabled = true;
        private boolean log;

        @Generated
        public Spec() {
        }

        @Generated
        public List<Input> getInputs() {
            return this.inputs;
        }

        @Generated
        public List<Output> getOutputs() {
            return this.outputs;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isLog() {
            return this.log;
        }

        @Generated
        public Spec setInputs(List<Input> inputs) {
            this.inputs = inputs;
            return this;
        }

        @Generated
        public Spec setOutputs(List<Output> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Generated
        public Spec setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public Spec setLog(boolean log) {
            this.log = log;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Spec)) {
                return false;
            }
            Spec other = (Spec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isLog() != other.isLog()) {
                return false;
            }
            List<Input> this$inputs = this.getInputs();
            List<Input> other$inputs = other.getInputs();
            if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
                return false;
            }
            List<Output> this$outputs = this.getOutputs();
            List<Output> other$outputs = other.getOutputs();
            return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Spec;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isLog() ? 79 : 97);
            List<Input> $inputs = this.getInputs();
            result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
            List<Output> $outputs = this.getOutputs();
            result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PropertyTransformer.Spec(inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", enabled=" + this.isEnabled() + ", log=" + this.isLog() + ")";
        }
    }

    public static class Output {
        private String property;
        private Object value;
        private String unitOfMeasure;

        public Output(String property, Object value) {
            this(property, value, null);
        }

        @Generated
        public String getProperty() {
            return this.property;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public String getUnitOfMeasure() {
            return this.unitOfMeasure;
        }

        @Generated
        public Output setProperty(String property) {
            this.property = property;
            return this;
        }

        @Generated
        public Output setValue(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public Output setUnitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$unitOfMeasure = this.getUnitOfMeasure();
            String other$unitOfMeasure = other.getUnitOfMeasure();
            return !(this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $unitOfMeasure = this.getUnitOfMeasure();
            result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PropertyTransformer.Output(property=" + this.getProperty() + ", value=" + this.getValue() + ", unitOfMeasure=" + this.getUnitOfMeasure() + ")";
        }

        @Generated
        public Output() {
        }

        @ConstructorProperties(value={"property", "value", "unitOfMeasure"})
        @Generated
        public Output(String property, Object value, String unitOfMeasure) {
            this.property = property;
            this.value = value;
            this.unitOfMeasure = unitOfMeasure;
        }
    }

    public static class Input {
        private String property;
        private Object value;

        @Generated
        public String getProperty() {
            return this.property;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public Input setProperty(String property) {
            this.property = property;
            return this;
        }

        @Generated
        public Input setValue(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Input;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PropertyTransformer.Input(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public Input() {
        }

        @ConstructorProperties(value={"property", "value"})
        @Generated
        public Input(String property, Object value) {
            this.property = property;
            this.value = value;
        }
    }
}

