/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.services;

import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.ConfigObjectWrapper;
import com.seeq.link.sdk.interfaces.FileConfigObjectProvider;
import com.seeq.link.sdk.services.JsonConfigObjectMapper;
import com.seeq.utilities.FileChangeListener;
import com.seeq.utilities.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileConfigObjectProvider
implements FileConfigObjectProvider,
FileChangeListener {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileConfigObjectProvider.class);
    private final JsonConfigObjectMapper configObjectMapper = new JsonConfigObjectMapper();
    private Duration changeDebouncePeriod = Duration.ofSeconds(1L);
    private Path dataPath;
    private final HashMap<String, FileWatcher> watchers = new HashMap();
    private final HashMap<String, Consumer<String>> callbacks = new HashMap();

    public DefaultFileConfigObjectProvider() {
    }

    public DefaultFileConfigObjectProvider(Duration changeDebouncePeriod) {
        this.changeDebouncePeriod = changeDebouncePeriod;
    }

    private Path getFullPath(String name) {
        return this.dataPath.resolve(name + ".json");
    }

    @Override
    public void initialize(Path dataPath) {
        this.dataPath = dataPath;
    }

    @Override
    public ConfigObjectWrapper loadConfigObject(String name, ConfigObject[] defaultConfigObjects) throws IOException {
        Path filename = null;
        String json = null;
        Long fileLastModified = null;
        try {
            filename = this.getFullPath(name);
            File file = filename.toFile();
            if (file.exists()) {
                json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                fileLastModified = file.lastModified();
            }
        }
        catch (Exception e) {
            if (filename == null) {
                LOG.error("Could not resolve config Object name \"{}\" to file path:\n{}", (Object)name, (Object)e);
            }
            throw new IOException(String.format("Could not read json file \"%s\":\n%s", filename, e));
        }
        return this.configObjectMapper.toConfigObjectWrapper(json, defaultConfigObjects, String.format("Error parsing JSON file \"%s\"", filename), fileLastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfigObject(String name, Object configObject) {
        block10: {
            Path filename = null;
            try {
                filename = this.getFullPath(name);
                if (!Files.exists(this.dataPath, new LinkOption[0])) {
                    Files.createDirectories(this.dataPath, new FileAttribute[0]);
                }
                String newJson = this.configObjectMapper.toJson(configObject);
                String existingJson = "";
                if (Files.exists(filename, new LinkOption[0])) {
                    existingJson = FileUtils.readFileToString((File)filename.toFile(), (String)"UTF-8");
                }
                if (existingJson.equals(newJson)) break block10;
                if (this.watchers.containsKey(name)) {
                    this.watchers.get(name).stop();
                }
                try {
                    LOG.debug("Saving configuration file '{}'", (Object)filename);
                    FileUtils.writeStringToFile((File)filename.toFile(), (String)newJson, (String)"UTF-8");
                }
                finally {
                    if (this.watchers.containsKey(name)) {
                        this.watchers.get(name).start();
                    }
                }
            }
            catch (Exception e) {
                if (filename == null) {
                    LOG.error("Could not resolve config Object name \"{}\" to file path:\n{}", (Object)name, (Object)e);
                }
                LOG.error("Could not write config file \"{}\":\n{}", (Object)filename, (Object)e);
            }
        }
    }

    @Override
    public void registerChangeCallback(String name, Consumer<String> callback) {
        Path fullPath = this.getFullPath(name);
        FileWatcher fileWatcher = new FileWatcher(fullPath.getParent(), fullPath.getFileName().toString(), (FileChangeListener)this, this.changeDebouncePeriod);
        this.watchers.put(name, fileWatcher);
        this.callbacks.put(name, callback);
        try {
            fileWatcher.start();
        }
        catch (IOException e) {
            LOG.error("Error encountered while registering FileWatcher", (Throwable)e);
        }
    }

    @Override
    public void unregisterChangeCallback(String name) {
        if (this.watchers.containsKey(name)) {
            this.watchers.get(name).stop();
        }
        this.watchers.remove(name);
        this.callbacks.remove(name);
    }

    private void fireRegisterChangeCallback(Path filePath) {
        String name = FilenameUtils.getBaseName((String)filePath.getFileName().toString());
        LOG.debug(name + " has been changed");
        Consumer<String> callback = this.callbacks.get(name);
        if (callback != null) {
            callback.accept(name);
        }
    }

    public void onFileModify(Path filePath) {
        this.fireRegisterChangeCallback(filePath);
    }

    public void onFileDelete(Path filePath) {
        this.fireRegisterChangeCallback(filePath);
    }
}

