/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk.interfaces;

import com.seeq.link.sdk.utilities.Event;
import java.time.Duration;

public interface Connection {
    public void initialize();

    public void destroy();

    public String getConnectionMessage();

    public Duration getMinReconnectDelay();

    public void setMinReconnectDelay(Duration var1);

    public Duration getMaxReconnectDelay();

    public void setMaxReconnectDelay(Duration var1);

    public ConnectionState getState();

    public Event<StateChangedEventArgs> getStateChangedEvent();

    public void enable();

    public void disable();

    public Duration getMonitorPeriod();

    public void setMonitorPeriod(Duration var1);

    public static enum ConnectionState {
        DISABLED,
        CONNECTING,
        CONNECTED,
        DISCONNECTED;

    }

    public static class StateChangedEventArgs {
        private final Connection sender;
        private final ConnectionState state;
        private final String message;

        public StateChangedEventArgs(Connection sender, ConnectionState state, String message) {
            this.sender = sender;
            this.state = state;
            this.message = message;
        }

        public Connection getSender() {
            return this.sender;
        }

        public ConnectionState getState() {
            return this.state;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

