/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.interfaces.ConfigService;
import java.io.IOException;

public abstract class Configurable<TConfig> {
    private ConfigService configService;
    private TConfig config;
    private ConfigObject[] supportedConfigObjects;

    public abstract String getName();

    public ConfigService getConfigService() {
        return this.configService;
    }

    protected TConfig getConfig() {
        return this.config;
    }

    protected void initialize(ConfigService configService, ConfigObject[] supportedConfigObjects) throws IOException {
        this.configService = configService;
        this.configService.registerChangeCallback(this.getName(), name -> this.onConfigFileChanged((String)name));
        this.supportedConfigObjects = supportedConfigObjects;
        this.loadConfig(this.getName());
    }

    public void destroy() {
        if (this.configService != null) {
            this.configService.unregisterChangeCallback(this.getName());
        }
    }

    protected TConfig migrateConfig(Object configObject) {
        throw new ClassCastException(String.format("No migration routine specified. Need to migrate %s. Please override Configurable.migrateConfig() in your connector.", configObject.getClass()));
    }

    public void saveConfig() {
        if (this.config == null) {
            return;
        }
        this.configService.saveConfigObject(this.getName(), this.config);
    }

    protected void loadConfig(String name) throws IOException {
        ConfigObject configObject = this.configService.loadConfigObject(name, this.supportedConfigObjects);
        this.config = this.supportedConfigObjects[0].getClass() != configObject.getClass() ? this.migrateConfig(configObject) : configObject;
        this.saveConfig();
    }

    private void onConfigFileChanged(String name) {
        this.onConfigChanged();
    }

    protected void onConfigChanged() {
    }
}

