/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.seeq.ApiClient;
import com.seeq.ApiException;
import com.seeq.api.AssetsApi;
import com.seeq.api.DatasourcesApi;
import com.seeq.api.ItemsApi;
import com.seeq.api.RequestsApi;
import com.seeq.api.SignalsApi;
import com.seeq.api.TreesApi;
import com.seeq.api.UserGroupsApi;
import com.seeq.link.messages.ErrorMessage;
import com.seeq.link.messages.agent.AgentMessages;
import com.seeq.link.messages.connector.auth.AuthConnectionMessages;
import com.seeq.link.messages.connector.command.ConnectionIndexMessages;
import com.seeq.link.messages.connector.condition.ConditionConnectionMessages;
import com.seeq.link.messages.connector.extcalc.ExternalCalculationMessages;
import com.seeq.link.messages.connector.oauth2.OAuth2ConnectionMessages;
import com.seeq.link.messages.connector.request.RequestMessages;
import com.seeq.link.messages.connector.signal.SignalConnectionMessages;
import com.seeq.link.sdk.BaseConnection;
import com.seeq.link.sdk.IndexingSchedule;
import com.seeq.link.sdk.IndexingState;
import com.seeq.link.sdk.interfaces.AgentService;
import com.seeq.link.sdk.interfaces.ConcurrentRequestsHandler;
import com.seeq.link.sdk.interfaces.ConcurrentRequestsHandlerProvider;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.interfaces.Connector;
import com.seeq.link.sdk.interfaces.DatasourceConnection;
import com.seeq.link.sdk.interfaces.DatasourceConnectionV2;
import com.seeq.link.sdk.interfaces.IndexingDatasourceConnection;
import com.seeq.link.sdk.interfaces.PullDatasourceConnection;
import com.seeq.link.sdk.interfaces.SyncMode;
import com.seeq.link.sdk.interfaces.SyncResult;
import com.seeq.link.sdk.interfaces.SyncStatus;
import com.seeq.link.sdk.services.PropertyTransformer;
import com.seeq.link.sdk.utilities.BatchSizeHelper;
import com.seeq.link.sdk.utilities.DefaultConcurrentRequestsHandler;
import com.seeq.link.sdk.utilities.RequestCancellation;
import com.seeq.link.sdk.utilities.TimeInstant;
import com.seeq.model.AssetBatchInputV1;
import com.seeq.model.AssetInputV1;
import com.seeq.model.AssetTreeBatchInputV1;
import com.seeq.model.AssetTreeSingleInputV1;
import com.seeq.model.DatasourceCleanUpInputV1;
import com.seeq.model.DatasourceCleanUpOutputV1;
import com.seeq.model.DatasourceInputV1;
import com.seeq.model.DatasourceOutputV1;
import com.seeq.model.ItemBatchOutputV1;
import com.seeq.model.ItemIdListInputV1;
import com.seeq.model.ItemUpdateOutputV1;
import com.seeq.model.PropertyInputV1;
import com.seeq.model.PutSignalsInputV1;
import com.seeq.model.PutUserGroupsInputV1;
import com.seeq.model.ScalarPropertyV1;
import com.seeq.model.SignalWithIdInputV1;
import com.seeq.model.UserGroupWithIdInputV1;
import com.seeq.utilities.ManualResetEvent;
import com.seeq.utilities.exception.OperationCanceledException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import lombok.Generated;
import org.apache.commons.lang.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDatasourceConnection<TConnector extends Connector>
extends BaseConnection
implements DatasourceConnection {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(BaseDatasourceConnection.class);
    private final AgentService agentService;
    private final TConnector connector;
    private final String datasourceClass;
    private final String datasourceName;
    private final String datasourceId;
    protected AgentMessages.DatasourceService[] services;
    private final String connectionId;
    private IndexingSchedule indexingSchedule = new IndexingSchedule();
    private SyncMode currentIndexingRequestSyncMode = SyncMode.NONE;
    private final IndexingState indexingState = new IndexingState();
    private int maxResultsPerRequest = Integer.MAX_VALUE;
    private final ConcurrentRequestsHandler concurrentRequestsHandler;
    int itemsWithErrors = 0;

    public AgentService getAgentService() {
        return this.agentService;
    }

    public TConnector getConnector() {
        return this.connector;
    }

    public BaseDatasourceConnection(AgentService agentService, TConnector connector, String datasourceClass, String datasourceName, String datasourceId, IndexingSchedule indexingSchedule, AgentMessages.DatasourceService[] services, Integer maxConcurrentRequests, Integer maxResultsPerRequest) {
        this.agentService = agentService;
        this.connector = connector;
        this.datasourceClass = datasourceClass;
        this.datasourceName = datasourceName;
        this.datasourceId = datasourceId;
        this.indexingSchedule = indexingSchedule;
        this.services = services;
        this.connectionId = this.generateConnectionId();
        maxConcurrentRequests = maxConcurrentRequests != null ? maxConcurrentRequests : Integer.MAX_VALUE;
        this.concurrentRequestsHandler = new DefaultConcurrentRequestsHandler(maxConcurrentRequests);
        if (maxResultsPerRequest != null) {
            this.maxResultsPerRequest = maxResultsPerRequest;
        }
    }

    BaseDatasourceConnection(AgentService agentService, TConnector connector, DatasourceConnectionV2 connectionV2, AgentMessages.DatasourceService[] services) {
        PullDatasourceConnection pullDatasourceConnection;
        this.agentService = agentService;
        this.connector = connector;
        this.datasourceClass = connectionV2.getDatasourceClass();
        this.datasourceName = connectionV2.getDatasourceName();
        this.datasourceId = connectionV2.getDatasourceId();
        this.indexingSchedule = connectionV2 instanceof IndexingDatasourceConnection ? ((IndexingDatasourceConnection)connectionV2).getConfiguration().getIndexing() : null;
        this.services = services;
        this.connectionId = this.generateConnectionId();
        if (connectionV2 instanceof PullDatasourceConnection && (pullDatasourceConnection = (PullDatasourceConnection)connectionV2).getMaxResultsPerRequest() != null) {
            this.maxResultsPerRequest = pullDatasourceConnection.getMaxResultsPerRequest();
        }
        int maxConcurrentRequests = Integer.MAX_VALUE;
        if (connectionV2 instanceof PullDatasourceConnection) {
            maxConcurrentRequests = Optional.ofNullable(((PullDatasourceConnection)connectionV2).getMaxConcurrentRequests()).orElse(Integer.MAX_VALUE);
        }
        this.concurrentRequestsHandler = connectionV2 instanceof ConcurrentRequestsHandlerProvider ? ((ConcurrentRequestsHandlerProvider)((Object)connectionV2)).getConcurrentRequestsHandler() : new DefaultConcurrentRequestsHandler(maxConcurrentRequests);
    }

    private String generateConnectionId() {
        String machineName;
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            machineName = "Unknown Machine Name";
        }
        return (this.agentService != null ? this.agentService.getDisplayName() + ": " : "") + machineName + ": " + this.datasourceClass + ": " + this.datasourceName + ": " + this.datasourceId;
    }

    @Override
    public void destroy() {
        this.disable();
    }

    @Override
    public String getDatasourceClass() {
        return this.datasourceClass;
    }

    @Override
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Override
    public String getDatasourceId() {
        return this.datasourceId;
    }

    @Override
    public abstract boolean isPullDatasourceConnection();

    @Override
    public abstract boolean isIndexingDatasourceConnection();

    @Override
    public AgentMessages.DatasourceService[] getServices() {
        return this.services;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public IndexingSchedule getIndexingSchedule() {
        return this.indexingSchedule;
    }

    @Override
    public SyncMode getCurrentIndexingRequestSyncMode() {
        return this.currentIndexingRequestSyncMode;
    }

    @Override
    public void setCurrentIndexingRequestSyncMode(SyncMode syncMode) {
        this.currentIndexingRequestSyncMode = syncMode;
    }

    @Override
    public IndexingState getIndexingState() {
        return this.indexingState;
    }

    public String toString() {
        return String.format("%s: %s [%s]", new Object[]{this.getDatasourceClass(), this.getDatasourceName(), this.getState()});
    }

    public SignalConnectionMessages.SignalResponseMessage signalRequest(SignalConnectionMessages.SignalRequestMessage request) throws Exception {
        throw new NotImplementedException("Connector does not respond to signal requests.");
    }

    public ConditionConnectionMessages.ConditionResponseMessage conditionRequest(ConditionConnectionMessages.ConditionRequestMessage request) throws Exception {
        throw new NotImplementedException("Connector does not respond to condition requests.");
    }

    public ExternalCalculationMessages.ExternalCalculationResponseMessage calculationRequest(ExternalCalculationMessages.ExternalCalculationRequestMessage calculationRequest) {
        throw new NotImplementedException("Connector does not respond to calculation requests.");
    }

    public AuthConnectionMessages.AuthResponseMessage authRequest(AuthConnectionMessages.AuthRequestMessage authRequest) {
        throw new NotImplementedException("Connector does not respond to Auth requests.");
    }

    public OAuth2ConnectionMessages.OAuth2AuthResponseMessage oAuth2AuthRequest(OAuth2ConnectionMessages.OAuth2AuthRequestMessage oAuth2AuthRequest) {
        throw new NotImplementedException("Connector does not respond to OAuth 2.0 requests.");
    }

    public OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage oAuth2PreAuthRequest(OAuth2ConnectionMessages.OAuth2PreAuthRequestMessage oAuth2PreAuthRequest) {
        throw new NotImplementedException("Connector does not respond to OAuth 2.0 requests.");
    }

    @Override
    public void processMessage(AgentMessages.DataDocument data) {
        RequestMessages.CancellationMessage cancellationMessage;
        if (this.getState() == Connection.ConnectionState.DISABLED) {
            this.getLog().info("Received data document but DatasourceConnection is disabled. Ignoring.");
            return;
        }
        RequestMessages.TransactionMessage transaction = data.getTransaction();
        if (transaction.hasCancellation() && (cancellationMessage = transaction.getCancellation()).hasRequestIdToCancel()) {
            long requestIdToCancel = cancellationMessage.getRequestIdToCancel();
            this.getBackgroundThreads().interrupt(requestIdToCancel);
            return;
        }
        RequestMessages.RequestMessage request = transaction.getRequest();
        long requestId = request.getRequestId();
        long timeoutMillis = request.hasTimeoutNanos() ? request.getTimeoutNanos() / 1000000L : -1L;
        Stopwatch queueDuration = Stopwatch.createStarted();
        this.concurrentRequestsHandler.runWhenPermitted(() -> {
            queueDuration.stop();
            Stopwatch datasourceDuration = Stopwatch.createStarted();
            Thread.currentThread().setName(String.format("%s [#%d]", this.getConnectionId(), requestId));
            AgentMessages.DataDocument.Builder responseDocument = AgentMessages.DataDocument.newBuilder();
            responseDocument.setDestinationConnectionId(this.getConnectionId());
            RequestMessages.TransactionMessage.Builder responseTransaction = RequestMessages.TransactionMessage.newBuilder();
            RequestMessages.ResponseMessage.Builder response = RequestMessages.ResponseMessage.newBuilder();
            response.setRequestId(requestId);
            if (request.hasSignalRequest()) {
                SignalConnectionMessages.SignalRequestMessage signalRequest = request.getSignalRequest();
                try {
                    String overrideLogSnippet = "";
                    if (this.maxResultsPerRequest < signalRequest.getSampleLimit()) {
                        overrideLogSnippet = " (by MaxResultsPerRequest in connection config)";
                        SignalConnectionMessages.SignalRequestMessage.Builder signalRequestBuilder = signalRequest.toBuilder();
                        signalRequestBuilder.setSampleLimit(Math.min(signalRequest.getSampleLimit(), this.maxResultsPerRequest));
                        signalRequest = signalRequestBuilder.build();
                    }
                    this.getLog().debug("Received SignalRequestMessage with RequestID {} for SignalId {} from {} to {}, limited{} to {}", new Object[]{requestId, signalRequest.getSignalId(), new TimeInstant(signalRequest.getStartTime()).toString(), new TimeInstant(signalRequest.getEndTime()).toString(), overrideLogSnippet, signalRequest.getSampleLimit()});
                    SignalConnectionMessages.SignalResponseMessage signalResponse = this.signalRequest(signalRequest);
                    this.getLog().debug("Returning SignalResponseMessage with RequestID {} for SignalId {} from {} to {}, with {} samples and HasMoreSamples=={}, took {} seconds", new Object[]{requestId, signalRequest.getSignalId(), new TimeInstant(signalRequest.getStartTime()).toString(), new TimeInstant(signalRequest.getEndTime()).toString(), signalResponse.getSampleCount(), signalResponse.getHasMoreSamples(), (double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0});
                    response.setSignalResponse(signalResponse);
                }
                catch (Exception e) {
                    SignalConnectionMessages.SignalResponseMessage.Builder signalResponse = SignalConnectionMessages.SignalResponseMessage.newBuilder();
                    signalResponse.setErrorInfo(this.buildErrorMessage(e, signalRequest));
                    response.setSignalResponse(signalResponse.build());
                }
            } else if (request.hasConditionRequest()) {
                ConditionConnectionMessages.ConditionRequestMessage conditionRequest = request.getConditionRequest();
                try {
                    String overrideLogSnippet = "";
                    if (this.maxResultsPerRequest < conditionRequest.getCapsuleLimit()) {
                        overrideLogSnippet = " (by MaxResultsPerRequest in connection config)";
                        ConditionConnectionMessages.ConditionRequestMessage.Builder conditionRequestBuilder = conditionRequest.toBuilder();
                        conditionRequestBuilder.setCapsuleLimit(Math.min(conditionRequest.getCapsuleLimit(), this.maxResultsPerRequest));
                        conditionRequest = conditionRequestBuilder.build();
                    }
                    this.getLog().debug("Received ConditionRequestMessage with RequestID {} for ConditionId {} from {} to {}, limited{} to {}", new Object[]{requestId, conditionRequest.getConditionId(), new TimeInstant(conditionRequest.getStartTime()).toString(), new TimeInstant(conditionRequest.getEndTime()).toString(), overrideLogSnippet, conditionRequest.getCapsuleLimit()});
                    ConditionConnectionMessages.ConditionResponseMessage conditionResponse = this.conditionRequest(conditionRequest);
                    this.getLog().debug("Returning ConditionResponseMessage with RequestID {} for ConditionId {} from {} to {}, with {} capsules and HasMoreCapsules=={}, took {} seconds", new Object[]{requestId, conditionRequest.getConditionId(), new TimeInstant(conditionRequest.getStartTime()).toString(), new TimeInstant(conditionRequest.getEndTime()).toString(), conditionResponse.getCapsuleCount(), conditionResponse.getHasMoreCapsules(), (double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0});
                    response.setConditionResponse(conditionResponse);
                }
                catch (Exception e) {
                    ConditionConnectionMessages.ConditionResponseMessage.Builder conditionResponse = ConditionConnectionMessages.ConditionResponseMessage.newBuilder();
                    conditionResponse.setErrorInfo(this.buildErrorMessage(e, conditionRequest));
                    response.setConditionResponse(conditionResponse.build());
                }
            } else if (request.hasExternalCalculationRequest()) {
                ExternalCalculationMessages.ExternalCalculationRequestMessage calculationRequest = request.getExternalCalculationRequest();
                try {
                    int numberOfSamples = 0;
                    if (calculationRequest.getSampleList() != null) {
                        numberOfSamples = calculationRequest.getSampleCount();
                    }
                    this.getLog().debug("Received ExternalCalculationRequest with RequestID {} for script {} with {} key (s) in the input signals", new Object[]{requestId, calculationRequest.getScript(), numberOfSamples});
                    ExternalCalculationMessages.ExternalCalculationResponseMessage calculationResponse = this.calculationRequest(calculationRequest);
                    this.getLog().debug("Returning ExternalCalculationResponse with RequestID {} for Script {} having {} samples in response, took {} seconds", new Object[]{requestId, calculationRequest.getScript(), calculationResponse.getSampleCount(), (double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0});
                    response.setExternalCalculationResponse(calculationResponse);
                }
                catch (Exception e) {
                    ExternalCalculationMessages.ExternalCalculationResponseMessage.Builder calculationResponse = ExternalCalculationMessages.ExternalCalculationResponseMessage.newBuilder();
                    long start = calculationRequest.getSampleCount() > 0 ? calculationRequest.getSampleList().get(0).getTimestamp() : 0L;
                    long end = calculationRequest.getSampleCount() > 0 ? calculationRequest.getSampleList().get(calculationRequest.getSampleCount() - 1).getTimestamp() : 0L;
                    calculationResponse.setErrorInfo(this.buildDataRequestErrorMessage(e, "external calculation", calculationRequest.getScript(), start, end));
                    response.setExternalCalculationResponse(calculationResponse.build());
                }
            } else if (request.hasAuthRequest()) {
                AuthConnectionMessages.AuthRequestMessage AuthRequest = request.getAuthRequest();
                try {
                    this.getLog().debug("Received AuthRequest with RequestID {}, length {}", (Object)requestId, (Object)data.getSerializedSize());
                    AuthConnectionMessages.AuthResponseMessage authResponse = this.authRequest(AuthRequest);
                    this.getLog().debug("Returning AuthResponse with RequestID {}, took {} seconds", (Object)requestId, (Object)((double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
                    response.setAuthResponse(authResponse);
                }
                catch (Exception e) {
                    AuthConnectionMessages.AuthResponseMessage.Builder authResponse = AuthConnectionMessages.AuthResponseMessage.newBuilder();
                    authResponse.setAuthenticated(false);
                    authResponse.setErrorInfo(this.buildErrorMessage(ErrorMessage.ErrorCode.EXCEPTION, e, String.format("Error processing Auth request with id %s", requestId)));
                    response.setAuthResponse(authResponse.build());
                }
            } else if (request.hasOAuth2AuthRequest()) {
                OAuth2ConnectionMessages.OAuth2AuthRequestMessage oAuth2AuthRequest = request.getOAuth2AuthRequest();
                try {
                    this.getLog().debug("Received OAuth2AuthRequest with RequestID {}, length {}", (Object)requestId, (Object)data.getSerializedSize());
                    OAuth2ConnectionMessages.OAuth2AuthResponseMessage oAuth2AuthResponse = this.oAuth2AuthRequest(oAuth2AuthRequest);
                    this.getLog().debug("Returning OAuth2AuthResponse with RequestID {}, took {} seconds", (Object)requestId, (Object)((double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
                    response.setOAuth2AuthResponse(oAuth2AuthResponse);
                }
                catch (Exception e) {
                    OAuth2ConnectionMessages.OAuth2AuthResponseMessage.Builder oAuth2AuthResponse = OAuth2ConnectionMessages.OAuth2AuthResponseMessage.newBuilder().setAuthenticated(false).setErrorInfo(this.buildErrorMessage(ErrorMessage.ErrorCode.EXCEPTION, e, String.format("Error processing OAuth 2.0 authentication request with id %s", requestId)));
                    response.setOAuth2AuthResponse(oAuth2AuthResponse.build());
                }
            } else if (request.hasOAuth2PreAuthRequest()) {
                OAuth2ConnectionMessages.OAuth2PreAuthRequestMessage oAuth2PreAuthRequest = request.getOAuth2PreAuthRequest();
                try {
                    this.getLog().debug("Received OAuth2PreAuthRequest with RequestID {}, length {}", (Object)requestId, (Object)data.getSerializedSize());
                    OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage oAuth2PreAuthResponse = this.oAuth2PreAuthRequest(oAuth2PreAuthRequest);
                    this.getLog().debug("Returning OAuth2PreAuthResponse with RequestID {}, took {} seconds", (Object)requestId, (Object)((double)datasourceDuration.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
                    response.setOAuth2PreAuthResponse(oAuth2PreAuthResponse);
                }
                catch (Exception e) {
                    OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage.Builder oAuth2PreAuthResponse = OAuth2ConnectionMessages.OAuth2PreAuthResponseMessage.newBuilder();
                    oAuth2PreAuthResponse.setErrorInfo(this.buildErrorMessage(ErrorMessage.ErrorCode.EXCEPTION, e, String.format("Error processing OAuth 2.0 pre-auth request with id %s", requestId)));
                    response.setOAuth2PreAuthResponse(oAuth2PreAuthResponse.build());
                }
            } else if (request.hasConnectionIndexRequest()) {
                ConnectionIndexMessages.ConnectionIndexRequestMessage connectionIndexRequest = request.getConnectionIndexRequest();
                ConnectionIndexMessages.ConnectionIndexResponseMessage.Builder connectionIndexResponse = ConnectionIndexMessages.ConnectionIndexResponseMessage.newBuilder();
                this.getLog().debug("Received ConnectionIndexRequestMessage with RequestID {}, length {}", (Object)requestId, (Object)data.getSerializedSize());
                this.agentService.requestIndex(this, BaseDatasourceConnection.toSyncMode(connectionIndexRequest.getSyncMode()));
                connectionIndexResponse.setMessage("Connection queued for indexing.");
                response.setConnectionIndexResponse(connectionIndexResponse.build());
            }
            datasourceDuration.stop();
            RequestMessages.MonitorData.Builder monitorData = RequestMessages.MonitorData.newBuilder();
            monitorData.setQueueNanos(queueDuration.elapsed(TimeUnit.NANOSECONDS));
            monitorData.setDatasourceNanos(datasourceDuration.elapsed(TimeUnit.NANOSECONDS));
            monitorData.setRequestNanos(monitorData.getQueueNanos() + monitorData.getDatasourceNanos());
            response.setMonitorData(monitorData.build());
            responseTransaction.setResponse(response.build());
            responseDocument.setTransaction(responseTransaction.build());
            this.sendMessage(responseDocument.build());
        }, this.getBackgroundThreads(), timeoutMillis, requestId, new ManualResetEvent(false));
    }

    @NotNull
    private static SyncMode toSyncMode(ConnectionIndexMessages.ConnectionIndexRequestMessage.SyncMode syncMode) {
        return SyncMode.valueOf(syncMode.name());
    }

    protected void sendMessage(AgentMessages.DataDocument data) {
        this.agentService.sendMessage(this, data);
    }

    public abstract Logger getLog();

    @Override
    public void spawnMetadataSync(SyncMode syncMode, Consumer<SyncResult> callback) {
        this.getBackgroundThreads().spawn(() -> {
            SyncResult syncResult = SyncResult.FAILED;
            try {
                Thread.currentThread().setName("Metadata sync for " + this.getConnectionId());
                this.getLog().info("Metadata sync starting, sync mode " + syncMode.toString());
                this.metadataSync(syncMode);
                this.getLog().info("Metadata sync success");
                syncResult = SyncResult.SUCCESS;
            }
            catch (OperationCanceledException e) {
                this.getLog().warn("Metadata sync interrupted");
                syncResult = SyncResult.INTERRUPTED;
            }
            catch (Throwable e) {
                this.getLog().error("Metadata sync failure:", e);
            }
            finally {
                callback.accept(syncResult);
            }
        });
    }

    public DatasourceAndCreationInfo getOrCreateDatasource(boolean storedInSeeq) {
        return this.getOrCreateDatasource(storedInSeeq, false, Collections.emptyList());
    }

    public DatasourceAndCreationInfo getOrCreateDatasource(boolean storedInSeeq, boolean enableCache) {
        return this.getOrCreateDatasource(storedInSeeq, enableCache, Collections.emptyList());
    }

    public DatasourceAndCreationInfo getOrCreateDatasource(boolean storedInSeeq, boolean enableCache, List<ScalarPropertyV1> additionalProperties) {
        DatasourcesApi datasourcesApi = this.getAgentService().getIndexingApiProvider().createDatasourcesApi();
        try {
            List datasources = datasourcesApi.getDatasources(this.getDatasourceClass(), this.getDatasourceId(), Integer.valueOf(0), Integer.valueOf(100), Boolean.valueOf(true)).getDatasources();
            if (datasources.size() == 0) {
                DatasourceInputV1 datasourceInput = new DatasourceInputV1();
                datasourceInput.setDatasourceClass(this.getDatasourceClass());
                datasourceInput.setDatasourceId(this.getDatasourceId());
                datasourceInput.setName(this.getDatasourceName());
                datasourceInput.setStoredInSeeq(Boolean.valueOf(storedInSeeq));
                datasourceInput.setCacheEnabled(Boolean.valueOf(enableCache));
                datasourceInput.setIndexingScheduleSupported(Boolean.valueOf(this.isIndexingScheduleSupported()));
                datasourceInput.setAdditionalProperties(additionalProperties);
                return new DatasourceAndCreationInfo(datasourcesApi.createDatasource(datasourceInput), true);
            }
            if (datasources.size() == 1) {
                DatasourceOutputV1 datasource = this.updateExistingDatasource((DatasourceOutputV1)datasources.get(0), storedInSeeq, additionalProperties);
                return new DatasourceAndCreationInfo(datasource, false);
            }
            String errorString = String.format("Multiple datasources matched when querying for datasourceClass=%s, datasourceIdentifier=%s!", this.getDatasourceClass(), this.getDatasourceId());
            throw new Exception(errorString);
        }
        catch (Exception e) {
            this.getLog().error("", (Throwable)e);
            return null;
        }
    }

    protected DatasourceOutputV1 updateExistingDatasource(DatasourceOutputV1 datasource, boolean storedInSeeq, List<ScalarPropertyV1> additionalProperties) {
        DatasourcesApi datasourcesApi = this.getAgentService().getIndexingApiProvider().createDatasourcesApi();
        String datasourceGuid = datasource.getId();
        ItemsApi itemsApi = this.getAgentService().getIndexingApiProvider().createItemsApi();
        ArrayList<ScalarPropertyV1> propertiesToChange = new ArrayList<ScalarPropertyV1>();
        if (!Objects.equals(storedInSeeq, datasource.getStoredInSeeq())) {
            propertiesToChange.add(new ScalarPropertyV1().name("Stored In Seeq").value((Object)storedInSeeq));
        }
        if (datasource.getIsArchived().booleanValue()) {
            propertiesToChange.add(new ScalarPropertyV1().name("Archived").value((Object)false));
        }
        if (!Objects.equals(this.isIndexingScheduleSupported(), datasource.getIndexingScheduleSupported())) {
            propertiesToChange.add(new ScalarPropertyV1().name("Indexing Schedule Supported").value((Object)this.isIndexingScheduleSupported()));
        }
        if (!additionalProperties.isEmpty()) {
            Map<String, ScalarPropertyV1> existingAdditionalPropertiesByName = datasource.getAdditionalProperties().stream().collect(Collectors.toMap(ScalarPropertyV1::getName, p -> p));
            for (ScalarPropertyV1 additionalPropertyToSet : additionalProperties) {
                boolean uomMatches;
                ScalarPropertyV1 existingProperty = existingAdditionalPropertiesByName.get(additionalPropertyToSet.getName());
                if (existingProperty == null) {
                    propertiesToChange.add(additionalPropertyToSet);
                    continue;
                }
                boolean valueMatches = additionalPropertyToSet.getValue().equals(existingProperty.getValue());
                boolean bl = uomMatches = existingProperty.getUnitOfMeasure().equals(additionalPropertyToSet.getUnitOfMeasure()) || additionalPropertyToSet.getUnitOfMeasure() == null && existingProperty.getUnitOfMeasure().equals("string");
                if (valueMatches && uomMatches) continue;
                propertiesToChange.add(additionalPropertyToSet);
            }
        }
        if (!propertiesToChange.isEmpty()) {
            String summaryString = propertiesToChange.stream().map(p -> "" + p.getName() + " = " + p.getValue()).reduce((x, y) -> x + ", " + y).orElse("");
            this.getLog().info("Changing properties of datasource with GUID {}: {}", (Object)datasourceGuid, (Object)summaryString);
            itemsApi.setProperties(datasourceGuid, propertiesToChange);
            datasource = datasourcesApi.getDatasource(datasourceGuid);
        }
        return datasource;
    }

    protected ErrorMessage.ErrorInfo buildErrorMessage(Exception e, SignalConnectionMessages.SignalRequestMessage request) {
        return this.buildDataRequestErrorMessage(e, "signal", request.getSignalId(), request.getStartTime(), request.getEndTime());
    }

    protected ErrorMessage.ErrorInfo buildErrorMessage(Exception e, ConditionConnectionMessages.ConditionRequestMessage request) {
        return this.buildDataRequestErrorMessage(e, "condition", request.getConditionId(), request.getStartTime(), request.getEndTime());
    }

    protected ErrorMessage.ErrorInfo buildDataRequestErrorMessage(Exception e, String requestType, String dataId, long start, long end) {
        return this.buildErrorMessage(ErrorMessage.ErrorCode.EXCEPTION, e, String.format("Error processing %s request for %s with start: %s and end: %s.", requestType, dataId, new TimeInstant(start), new TimeInstant(end)));
    }

    protected ErrorMessage.ErrorInfo buildErrorMessage(ErrorMessage.ErrorCode errorCode, Exception e, String message) {
        ErrorMessage.ErrorInfo.Builder errorMessage = ErrorMessage.ErrorInfo.newBuilder();
        errorMessage.setCode(errorCode);
        if (e != null) {
            errorMessage.setException(e.getClass().getName());
            errorMessage.setMessage((message + "  " + e.getMessage()).trim());
        } else {
            errorMessage.setMessage(message);
        }
        if (e instanceof OperationCanceledException) {
            this.getLog().debug("Request canceled");
        } else {
            this.getLog().error(errorMessage.getMessage(), (Throwable)e);
        }
        return errorMessage.build();
    }

    protected void setSyncStatus(SyncStatus syncStatus) throws OperationCanceledException {
        RequestCancellation.check();
        if (syncStatus != this.indexingState.getSyncStatus()) {
            this.indexingState.setSyncStatus(syncStatus);
            this.getAgentService().sendAgentInfoToServer();
        }
    }

    protected void sendSyncCompleteInfo(String datasourceItemId, String datasourceVersionCheck) {
        ItemsApi itemsApi = this.getAgentService().getIndexingApiProvider().createItemsApi();
        try {
            if (datasourceVersionCheck != null) {
                PropertyInputV1 versionCheckProperty = new PropertyInputV1();
                versionCheckProperty.setValue((Object)datasourceVersionCheck);
                itemsApi.setProperty(datasourceItemId, "Data Version Check", versionCheckProperty);
            }
        }
        catch (ApiException | ProcessingException e) {
            LOG.error("Could not update data version check to appserver", e);
        }
    }

    protected void sendSyncToken(String datasourceItemId, String syncToken) {
        ItemsApi itemsApi = this.getAgentService().getIndexingApiProvider().createItemsApi();
        try {
            if (syncToken != null) {
                PropertyInputV1 syncTokenProperty = new PropertyInputV1();
                syncTokenProperty.setValue((Object)syncToken);
                itemsApi.setProperty(datasourceItemId, "Sync Token", syncTokenProperty);
            }
        }
        catch (ApiException | ProcessingException e) {
            LOG.error("Could not update sync token to appserver", e);
        }
    }

    protected void logAndCountBadItems(List<ItemUpdateOutputV1> items) {
        List badItems = items.stream().filter(i -> i.getErrorMessage() != null).collect(Collectors.toList());
        if (badItems.size() > 0) {
            this.itemsWithErrors += badItems.size();
            this.getLog().error("Could not sync the following items:");
            for (ItemUpdateOutputV1 itemUpdate : badItems) {
                this.getLog().error("DataID: {} Item: '{}' ErrorMessage: {}", new Object[]{itemUpdate.getDataId(), itemUpdate.getItem() != null ? itemUpdate.getItem().getName() : "??", itemUpdate.getErrorMessage()});
            }
        }
    }

    protected Optional<String> batchSync(Iterator<SignalWithIdInputV1> signalInputs, String hostID, Iterator<AssetInputV1> assetInputs, Iterator<AssetTreeSingleInputV1> relationshipInputs, List<AssetInputV1> rootAssetInputs, Iterator<UserGroupWithIdInputV1> userGroupInputs, Optional<String> newDatasourceVersionCheck, List<PropertyTransformer.Spec> sampleSeriesTransforms, List<PropertyTransformer.Spec> userGroupsTransforms, boolean disableAssetTreeIndexUpdateDuringSync) throws Exception {
        String batchStats;
        AssetBatchInputV1 assetBatchInput;
        String batchStats2;
        Exception apiException = null;
        BatchSizeHelper batchSizeHelper = this.getAgentService().createBatchSizeHelper();
        SignalsApi signalsApi = this.getAgentService().getIndexingApiProvider().createSignalsApi();
        AssetsApi assetsApi = this.getAgentService().getIndexingApiProvider().createAssetsApi();
        TreesApi treesApi = this.getAgentService().getIndexingApiProvider().createTreesApi();
        UserGroupsApi userGroupsApi = this.getAgentService().getIndexingApiProvider().createUserGroupsApi();
        long progress = 0L;
        this.setSyncStatus(SyncStatus.SYNC_INITIALIZING);
        PutSignalsInputV1 putSignalsInput = new PutSignalsInputV1();
        ArrayList<SignalWithIdInputV1> signalList = new ArrayList<SignalWithIdInputV1>();
        putSignalsInput.setSignals(signalList);
        boolean hasMore = signalInputs.hasNext();
        if (hasMore) {
            this.getLog().info("Sync Progress (Signals) [{}] first batch size: {}", (Object)progress, (Object)batchSizeHelper.getBatchSize());
        }
        while (hasMore) {
            block25: {
                SignalWithIdInputV1 signalInput = signalInputs.next();
                hasMore = signalInputs.hasNext();
                if (sampleSeriesTransforms != null) {
                    signalInput = PropertyTransformer.transform(signalInput, sampleSeriesTransforms);
                }
                signalList.add(signalInput);
                ++progress;
                if (hasMore && signalList.size() < batchSizeHelper.getBatchSize()) continue;
                batchSizeHelper.start();
                try {
                    this.logAndCountBadItems(signalsApi.putSignals(putSignalsInput).getItemUpdates());
                }
                catch (Exception e) {
                    this.getLog().error("Error calling PutSignals:", (Throwable)e);
                    if (apiException != null) break block25;
                    apiException = e;
                }
            }
            batchSizeHelper.stop(signalList.size());
            batchStats2 = "last batch";
            if (hasMore) {
                batchStats2 = String.format("%.2f seconds at %.1f per second - next batch size: %d", (double)batchSizeHelper.getLastDuration().toMillis() / 1000.0, batchSizeHelper.getLastItemsPerSecond(), batchSizeHelper.getBatchSize());
                this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
            }
            this.getLog().info("Sync Progress (Signals) [{}] {}", (Object)progress, (Object)batchStats2);
            putSignalsInput = new PutSignalsInputV1();
            signalList = new ArrayList();
            putSignalsInput.setSignals(signalList);
        }
        if (!rootAssetInputs.isEmpty()) {
            assetBatchInput = new AssetBatchInputV1();
            assetBatchInput.setHostId(hostID);
            assetBatchInput.setAssets(rootAssetInputs);
            progress += (long)rootAssetInputs.size();
            this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
            ItemBatchOutputV1 assetBatchOutput = assetsApi.batchCreateAssets(assetBatchInput);
            ItemIdListInputV1 itemIdList = new ItemIdListInputV1();
            itemIdList.setItems(assetBatchOutput.getItemUpdates().stream().map(o -> o.getItem().getId()).collect(Collectors.toList()));
            treesApi.moveNodesToRootOfTree(itemIdList);
        }
        if (assetInputs != null) {
            assetBatchInput = new AssetBatchInputV1();
            assetBatchInput.setHostId(hostID);
            assetBatchInput.setAssets(new ArrayList());
            boolean hasMore2 = assetInputs.hasNext();
            if (hasMore2) {
                this.getLog().info("Sync Progress (Assets) [{}] first batch size: {}", (Object)progress, (Object)batchSizeHelper.getBatchSize());
            }
            while (hasMore2) {
                block26: {
                    AssetInputV1 assetInput = assetInputs.next();
                    hasMore2 = assetInputs.hasNext();
                    assetBatchInput.getAssets().add(assetInput);
                    ++progress;
                    if (hasMore2 && assetBatchInput.getAssets().size() < batchSizeHelper.getBatchSize()) continue;
                    batchSizeHelper.start();
                    try {
                        this.logAndCountBadItems(assetsApi.batchCreateAssets(assetBatchInput).getItemUpdates());
                    }
                    catch (Exception e) {
                        this.getLog().error("Error calling BatchCreateAssets:", (Throwable)e);
                        if (apiException != null) break block26;
                        apiException = e;
                    }
                }
                batchSizeHelper.stop(assetBatchInput.getAssets().size());
                batchStats = "last batch";
                if (hasMore2) {
                    batchStats = String.format("%.2f seconds at %.1f per second - next batch size: %d", (double)batchSizeHelper.getLastDuration().toMillis() / 1000.0, batchSizeHelper.getLastItemsPerSecond(), batchSizeHelper.getBatchSize());
                    this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
                }
                this.getLog().info("Sync Progress (Signals) [{}] {}", (Object)progress, (Object)batchStats);
                assetBatchInput = new AssetBatchInputV1();
                assetBatchInput.setHostId(hostID);
                assetBatchInput.setAssets(new ArrayList());
            }
        }
        AssetTreeBatchInputV1 treeBatchInput = new AssetTreeBatchInputV1();
        treeBatchInput.setParentHostId(hostID);
        treeBatchInput.setChildHostId(hostID);
        treeBatchInput.setDisableAssetTreeIndexUpdateDuringSync(Boolean.valueOf(disableAssetTreeIndexUpdateDuringSync));
        treeBatchInput.setRelationships(new ArrayList());
        boolean hasMore3 = relationshipInputs.hasNext();
        if (hasMore3) {
            this.getLog().info("Sync Progress (Relationships) [{}] first batch size: {}", (Object)progress, (Object)batchSizeHelper.getBatchSize());
        }
        while (hasMore3) {
            block27: {
                AssetTreeSingleInputV1 relationshipInput = relationshipInputs.next();
                hasMore3 = relationshipInputs.hasNext();
                treeBatchInput.getRelationships().add(relationshipInput);
                ++progress;
                if (hasMore3 && treeBatchInput.getRelationships().size() < batchSizeHelper.getBatchSize()) continue;
                batchSizeHelper.start();
                try {
                    this.logAndCountBadItems(treesApi.batchMoveNodesToParents(treeBatchInput).getItemUpdates());
                }
                catch (Exception e) {
                    this.getLog().error("Error calling BatchMoveNodesToParents:", (Throwable)e);
                    if (apiException != null) break block27;
                    apiException = e;
                }
            }
            batchSizeHelper.stop(treeBatchInput.getRelationships().size());
            batchStats = "last batch";
            if (hasMore3) {
                batchStats = String.format("%.2f seconds at %.1f per second - next batch size: %d", (double)batchSizeHelper.getLastDuration().toMillis() / 1000.0, batchSizeHelper.getLastItemsPerSecond(), batchSizeHelper.getBatchSize());
                this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
            }
            this.getLog().info("Sync Progress (Relationships) [{}] {}", (Object)progress, (Object)batchStats);
            treeBatchInput = new AssetTreeBatchInputV1();
            treeBatchInput.setParentHostId(hostID);
            treeBatchInput.setChildHostId(hostID);
            treeBatchInput.setDisableAssetTreeIndexUpdateDuringSync(Boolean.valueOf(disableAssetTreeIndexUpdateDuringSync));
            treeBatchInput.setRelationships(new ArrayList());
        }
        PutUserGroupsInputV1 putUserGroupsInput = new PutUserGroupsInputV1();
        ArrayList<UserGroupWithIdInputV1> userGroupList = new ArrayList<UserGroupWithIdInputV1>();
        putUserGroupsInput.setUserGroups(userGroupList);
        hasMore = userGroupInputs.hasNext();
        if (hasMore) {
            this.getLog().info("Sync Progress (UserGroups) [{}] first batch size: {}", (Object)progress, (Object)batchSizeHelper.getBatchSize());
        }
        while (hasMore) {
            block28: {
                UserGroupWithIdInputV1 userGroupInput = userGroupInputs.next();
                hasMore = userGroupInputs.hasNext();
                if (userGroupsTransforms != null) {
                    userGroupInput = PropertyTransformer.transform(userGroupInput, userGroupsTransforms);
                }
                userGroupList.add(userGroupInput);
                ++progress;
                if (hasMore && userGroupList.size() < batchSizeHelper.getBatchSize()) continue;
                batchSizeHelper.start();
                try {
                    this.logAndCountBadItems(userGroupsApi.putUserGroups(putUserGroupsInput).getItemUpdates());
                }
                catch (Exception e) {
                    this.getLog().error("Error calling PutUserGroups:", (Throwable)e);
                    if (apiException != null) break block28;
                    apiException = e;
                }
            }
            batchSizeHelper.stop(userGroupList.size());
            batchStats2 = "last batch";
            if (hasMore) {
                batchStats2 = String.format("%.2f seconds at %.1f per second - next batch size: %d", (double)batchSizeHelper.getLastDuration().toMillis() / 1000.0, batchSizeHelper.getLastItemsPerSecond(), batchSizeHelper.getBatchSize());
                this.setSyncStatus(SyncStatus.SYNC_IN_PROGRESS);
            }
            this.getLog().info("Sync Progress (UserGroups) [{}] {}", (Object)progress, (Object)batchStats2);
            putUserGroupsInput = new PutUserGroupsInputV1();
            userGroupList = new ArrayList();
            putUserGroupsInput.setUserGroups(userGroupList);
        }
        if (apiException == null) {
            return newDatasourceVersionCheck;
        }
        throw apiException;
    }

    protected Optional<String> batchSyncSampleSeries(Iterator<SignalWithIdInputV1> signalInputs, Optional<String> newDatasourceVersionCheck, List<PropertyTransformer.Spec> signalTransforms) throws Exception, InterruptedException {
        return this.batchSync(signalInputs, null, Collections.emptyIterator(), Collections.emptyIterator(), Collections.emptyList(), Collections.emptyIterator(), newDatasourceVersionCheck, signalTransforms, null, true);
    }

    protected void cancelRequest(String requestId) throws ApiException {
        RequestsApi requestsApi = this.getAgentService().getIndexingApiProvider().createRequestsApi();
        try {
            requestsApi.cancelRequest(URLEncoder.encode(requestId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                return;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUpStaleItems(String datasourceItemId, String syncToken, List<String> itemTypesFilter, String datasourceItemDataIdRegexFilter, String datasourceItemDataIdExcludeRegexFilter, String datasourceItemNameRegexFilter, String datasourceItemNameExcludeRegexFilter, String requestId) throws ApiException {
        ApiClient apiClient = this.getAgentService().getIndexingApiProvider().getApiClient();
        int originalReadTimeout = apiClient.getReadTimeout();
        try {
            apiClient.setReadTimeout(86400000);
            DatasourceCleanUpInputV1 datasourceCleanUpInput = new DatasourceCleanUpInputV1();
            datasourceCleanUpInput.setSyncToken(syncToken);
            datasourceCleanUpInput.setItemTypeFilter(itemTypesFilter);
            datasourceCleanUpInput.setItemDataIdRegexFilter(datasourceItemDataIdRegexFilter);
            datasourceCleanUpInput.setItemDataIdExcludeRegexFilter(datasourceItemDataIdExcludeRegexFilter);
            datasourceCleanUpInput.setItemNameRegexFilter(datasourceItemNameRegexFilter);
            datasourceCleanUpInput.setItemNameExcludeRegexFilter(datasourceItemNameExcludeRegexFilter);
            this.setSyncStatus(SyncStatus.SYNC_ARCHIVING_DELETED_ITEMS);
            try {
                requestId = URLEncoder.encode(requestId, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String path = "/datasources/" + datasourceItemId + "/cleanup";
            String method = "POST";
            List queryParams = Collections.emptyList();
            HashMap headerParams = Maps.newHashMap();
            headerParams.put("x-sq-request-id", requestId);
            String seeqContentType = "application/vnd.seeq.v1+json";
            String accept = apiClient.selectHeaderAccept(new String[]{seeqContentType});
            String contentType = apiClient.selectHeaderContentType(new String[]{seeqContentType});
            String[] authNames = new String[]{};
            DatasourceCleanUpOutputV1 datasourceCleanUpOutput = (DatasourceCleanUpOutputV1)apiClient.invokeAPI(path, method, queryParams, (Object)datasourceCleanUpInput, (Map)headerParams, Collections.emptyMap(), accept, contentType, authNames, (GenericType)new GenericType<DatasourceCleanUpOutputV1>(){});
            int numNewlyArchivedItems = datasourceCleanUpOutput.getNumNewlyArchivedItems();
            if (numNewlyArchivedItems > 0) {
                this.getLog().debug("Datasource clean-up complete for sync token {}; archived {} stale items", (Object)syncToken, (Object)numNewlyArchivedItems);
            } else {
                this.getLog().debug("Datasource clean-up complete for sync token {}; no items were stale", (Object)syncToken);
            }
        }
        finally {
            apiClient.setReadTimeout(originalReadTimeout);
        }
    }

    @Override
    public void saveConfig() {
        this.connector.saveConfig();
    }

    public static class DatasourceAndCreationInfo {
        public DatasourceOutputV1 datasource;
        public boolean newlyCreated;

        public DatasourceAndCreationInfo(DatasourceOutputV1 datasource, boolean newlyCreated) {
            this.datasource = datasource;
            this.newlyCreated = newlyCreated;
        }
    }
}

