/*
 * Decompiled with CFR 0.152.
 */
package com.seeq.link.sdk;

import com.google.common.collect.ImmutableList;
import com.seeq.link.messages.agent.AgentMessages;
import com.seeq.link.sdk.ConfigObject;
import com.seeq.link.sdk.Configurable;
import com.seeq.link.sdk.interfaces.AgentService;
import com.seeq.link.sdk.interfaces.ConfigService;
import com.seeq.link.sdk.interfaces.Connection;
import com.seeq.link.sdk.interfaces.DatasourceConnection;
import com.seeq.link.sdk.utilities.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConnector<TConfig>
extends Configurable<TConfig> {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(BaseConnector.class);
    private final List<DatasourceConnection> connections = new ArrayList<DatasourceConnection>();
    private AgentService agentService;
    private final Event<Connection.StateChangedEventArgs> connectionStateChangedEvent = new Event();

    protected AgentService getAgentService() {
        return this.agentService;
    }

    public abstract void initialize(AgentService var1) throws Exception;

    protected synchronized void initialize(AgentService agentService, ConfigObject[] defaultConfigObjects) throws IOException {
        this.agentService = agentService;
        super.initialize(agentService.getConfigService(), defaultConfigObjects);
        this.agentService.markConnectionsAsReinitialized(this.getConnections().stream().map(DatasourceConnection::getConnectionId).collect(Collectors.toList()));
    }

    @Override
    protected synchronized void initialize(ConfigService configService, ConfigObject[] defaultConfigObjects) {
        throw new UnsupportedOperationException("initialize(IConfigService configService, Object defaultConfigObject) should not be called from derived classes directly. Use initialize(AgentService agentService, ConfigObject[] defaultConfigObject) instead.");
    }

    protected synchronized void initializeConnection(DatasourceConnection connection) throws Exception {
        connection.getStateChangedEvent().add((sender, args) -> this.connectionStateChanged(args.getSender(), args.getState(), args.getMessage()));
        connection.initialize();
        this.connections.add(connection);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        for (DatasourceConnection connection : this.connections) {
            connection.destroy();
        }
        this.connections.clear();
    }

    public synchronized List<DatasourceConnection> getConnections() {
        return ImmutableList.copyOf(this.connections);
    }

    public boolean processMessage(String destinationConnectorInstanceId, AgentMessages.DataDocument data) {
        Optional<DatasourceConnection> connection = this.connections.stream().filter(c -> c.getConnectionId().equals(destinationConnectorInstanceId)).findFirst();
        if (connection.isPresent()) {
            connection.get().processMessage(data);
            return true;
        }
        return false;
    }

    public Event<Connection.StateChangedEventArgs> getConnectionStateChangedEvent() {
        return this.connectionStateChangedEvent;
    }

    protected void connectionStateChanged(Connection sender, Connection.ConnectionState state, String message) {
        this.connectionStateChangedEvent.dispatch(sender, new Connection.StateChangedEventArgs(sender, state, message));
    }

    @Override
    protected synchronized void onConfigChanged() {
        LOG.info("{} configuration changed", (Object)this.getName());
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.error("Error destroying connector", (Throwable)e);
        }
        try {
            this.initialize(this.getAgentService());
        }
        catch (Exception e) {
            LOG.error("Error initializing connector", (Throwable)e);
        }
    }
}

