/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.util;

import com.sdl.odata.api.ODataSystemException;
import com.sdl.odata.util.ReferenceUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public final class AnnotationsUtil {
    private AnnotationsUtil() {
    }

    public static <T extends Annotation> T checkAnnotationPresent(AnnotatedElement annotatedType, Class<T> annotationClass) {
        return AnnotationsUtil.getAnnotation(annotatedType, annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement annotatedType, Class<T> annotationClass) {
        return AnnotationsUtil.getAnnotation(annotatedType, annotationClass, null);
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement annotatedType, Class<T> annotationClass, String error) {
        if (annotatedType == null) {
            throw new IllegalArgumentException(error);
        }
        if (annotatedType.isAnnotationPresent(annotationClass)) {
            return annotatedType.getAnnotation(annotationClass);
        }
        if (ReferenceUtil.isNullOrEmpty(error)) {
            throw new ODataSystemException("Could not load annotation: " + annotationClass + " on source: " + annotatedType);
        }
        throw new ODataSystemException(error);
    }
}

