/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.renderer.ChunkedActionRenderResult;
import com.sdl.odata.api.renderer.ODataRenderer;
import com.sdl.odata.api.service.ODataContent;
import com.sdl.odata.api.service.ODataRequestContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ODataContentStreamer
implements ODataContent {
    private ODataRenderer oDataRenderer;
    private ODataRequestContext oDataRequestContext;
    private QueryResult queryResult;

    public ODataContentStreamer(ODataRenderer oDataRenderer, ODataRequestContext oDataRequestContext, QueryResult queryResult) {
        this.oDataRenderer = oDataRenderer;
        this.oDataRequestContext = oDataRequestContext;
        this.queryResult = queryResult;
    }

    @Override
    public void write(HttpServletResponse httpServletResponse) throws IOException, ODataException {
        boolean firstChunk = true;
        ChunkedActionRenderResult startRenderResult = null;
        ChunkedActionRenderResult bodyRenderResult = null;
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try (Stream resultStream = (Stream)this.queryResult.getData();){
            Iterator resultDataIterator = resultStream.iterator();
            Object currentDataChunk = null;
            while (resultDataIterator.hasNext()) {
                currentDataChunk = resultDataIterator.next();
                if (firstChunk) {
                    startRenderResult = this.oDataRenderer.renderStart(this.oDataRequestContext, QueryResult.from(currentDataChunk), (OutputStream)servletOutputStream);
                    this.addHeaders(startRenderResult, httpServletResponse);
                    servletOutputStream.flush();
                    firstChunk = false;
                }
                bodyRenderResult = this.oDataRenderer.renderBody(this.oDataRequestContext, QueryResult.from(currentDataChunk), startRenderResult);
                servletOutputStream.flush();
            }
            this.oDataRenderer.renderEnd(this.oDataRequestContext, QueryResult.from(currentDataChunk), bodyRenderResult == null ? startRenderResult : bodyRenderResult);
            servletOutputStream.flush();
        }
        catch (RuntimeException e) {
            this.writeWithFlush((OutputStream)servletOutputStream, System.lineSeparator() + "ODATA_CHUNKED_ERROR_MESSAGE:" + e.getMessage());
        }
    }

    private void addHeaders(ChunkedActionRenderResult result, HttpServletResponse httpServletResponse) {
        result.getHeaders().entrySet().forEach(headerEntry -> httpServletResponse.setHeader((String)headerEntry.getKey(), (String)headerEntry.getValue()));
    }

    private void writeWithFlush(OutputStream outputStream, String content) throws IOException {
        outputStream.write(content.getBytes());
        outputStream.flush();
    }
}

