/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.processor.query;

import com.sdl.odata.api.ODataException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class QueryResult {
    private final ResultType type;
    private final Object data;
    private final Map<String, Object> metadata;

    private QueryResult(Object data, ResultType type) {
        this.data = data;
        this.type = type;
        this.metadata = new HashMap<String, Object>();
    }

    public static QueryResult from(Object obj) {
        if (obj == null) {
            return new QueryResult(null, ResultType.NOTHING);
        }
        if (obj instanceof ODataException) {
            return new QueryResult(obj, ResultType.EXCEPTION);
        }
        if (obj instanceof List) {
            return new QueryResult(obj, ResultType.COLLECTION);
        }
        if (obj instanceof String) {
            return new QueryResult(obj, ResultType.RAW_JSON);
        }
        if (obj instanceof Stream) {
            return new QueryResult(obj, ResultType.STREAM);
        }
        return new QueryResult(obj, ResultType.OBJECT);
    }

    public QueryResult addMeta(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public QueryResult withCount(long count) {
        return this.addMeta("count", count);
    }

    public String toString() {
        return this.type.name() + ": " + this.data.toString();
    }

    public Object getData() {
        return this.data;
    }

    public ResultType getType() {
        return this.type;
    }

    public Map<String, Object> getMeta() {
        return this.metadata;
    }

    public static enum ResultType {
        COLLECTION,
        EXCEPTION,
        NOTHING,
        OBJECT,
        RAW_JSON,
        STREAM;

    }
}

