/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sdl.webapp.common.api.localization.Localization;
import com.sdl.webapp.common.api.model.MvcData;
import com.sdl.webapp.common.api.model.RegionModel;
import com.sdl.webapp.common.api.model.region.RegionModelImpl;
import com.sdl.webapp.common.exceptions.DxaException;
import java.util.Map;

public class SmartTargetRegion
extends RegionModelImpl {
    @JsonProperty(value="HasSmartTargetContent")
    private boolean isFallbackContentReplaced;
    @JsonProperty(value="MaxItems")
    private int maxItems;

    public SmartTargetRegion(RegionModel other) {
        super(other);
        if (other instanceof SmartTargetRegion) {
            SmartTargetRegion smartTargetRegion = (SmartTargetRegion)other;
            this.isFallbackContentReplaced = smartTargetRegion.isFallbackContentReplaced;
            this.maxItems = smartTargetRegion.maxItems;
        }
    }

    public SmartTargetRegion(String name) throws DxaException {
        super(name);
    }

    public SmartTargetRegion(String name, String qualifiedViewName) throws DxaException {
        super(name, qualifiedViewName);
    }

    public SmartTargetRegion(MvcData mvcData) throws DxaException {
        super(mvcData);
    }

    @JsonIgnore
    public String getStartQueryXpmMarkup() {
        Map xpmMetadata = this.getXpmMetadata();
        return String.valueOf(xpmMetadata != null && xpmMetadata.containsKey("Query") ? xpmMetadata.get("Query") : "");
    }

    public SmartTargetRegion deepCopy() {
        return new SmartTargetRegion((RegionModel)this);
    }

    public String getXpmMarkup(Localization localization) {
        return String.format("<!-- Start Promotion Region: { \"RegionID\": \"%s\" } -->", this.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartTargetRegion)) {
            return false;
        }
        SmartTargetRegion other = (SmartTargetRegion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isFallbackContentReplaced() != other.isFallbackContentReplaced()) {
            return false;
        }
        return this.getMaxItems() == other.getMaxItems();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartTargetRegion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isFallbackContentReplaced() ? 79 : 97);
        result = result * 59 + this.getMaxItems();
        return result;
    }

    public boolean isFallbackContentReplaced() {
        return this.isFallbackContentReplaced;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    @JsonProperty(value="HasSmartTargetContent")
    public void setFallbackContentReplaced(boolean isFallbackContentReplaced) {
        this.isFallbackContentReplaced = isFallbackContentReplaced;
    }

    @JsonProperty(value="MaxItems")
    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public String toString() {
        return "SmartTargetRegion(isFallbackContentReplaced=" + this.isFallbackContentReplaced() + ", maxItems=" + this.getMaxItems() + ")";
    }
}

