/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sdl.dxa.caching.NeverCached;
import com.sdl.webapp.common.api.model.PageModel;
import com.sdl.webapp.common.api.model.page.DefaultPageModel;
import com.tridion.smarttarget.query.ExperimentCookie;
import com.tridion.smarttarget.utils.CookieProcessor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NeverCached(qualifier="SmartTargetPageModel")
public class SmartTargetPageModel
extends DefaultPageModel
implements PageModel.WithResponseData {
    private static final Logger log = LoggerFactory.getLogger(SmartTargetPageModel.class);
    @JsonProperty(value="AllowDuplicates")
    private boolean allowDuplicates;
    @JsonIgnore
    private Map<String, ExperimentCookie> newExperimentCookies;

    public SmartTargetPageModel(PageModel other) {
        super(other);
        if (other instanceof SmartTargetPageModel) {
            SmartTargetPageModel smartTargetPageModel = (SmartTargetPageModel)other;
            this.allowDuplicates = smartTargetPageModel.allowDuplicates;
            if (smartTargetPageModel.newExperimentCookies != null) {
                this.newExperimentCookies = new HashMap<String, ExperimentCookie>(smartTargetPageModel.newExperimentCookies);
            }
        }
    }

    public PageModel deepCopy() {
        return new SmartTargetPageModel((PageModel)this);
    }

    public boolean setResponseData(HttpServletResponse servletResponse) {
        log.debug("Setting {} to servlet response", this.newExperimentCookies);
        CookieProcessor.saveExperimentCookies((ServletResponse)servletResponse, null, this.newExperimentCookies);
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartTargetPageModel)) {
            return false;
        }
        SmartTargetPageModel other = (SmartTargetPageModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllowDuplicates() != other.isAllowDuplicates()) {
            return false;
        }
        Map<String, ExperimentCookie> this$newExperimentCookies = this.newExperimentCookies;
        Map<String, ExperimentCookie> other$newExperimentCookies = other.newExperimentCookies;
        return !(this$newExperimentCookies == null ? other$newExperimentCookies != null : !((Object)this$newExperimentCookies).equals(other$newExperimentCookies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartTargetPageModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + (this.isAllowDuplicates() ? 79 : 97);
        Map<String, ExperimentCookie> $newExperimentCookies = this.newExperimentCookies;
        result = result * 59 + ($newExperimentCookies == null ? 43 : ((Object)$newExperimentCookies).hashCode());
        return result;
    }

    public String toString() {
        return "SmartTargetPageModel(allowDuplicates=" + this.isAllowDuplicates() + ", newExperimentCookies=" + this.newExperimentCookies + ")";
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public SmartTargetPageModel setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
        return this;
    }

    public void setNewExperimentCookies(Map<String, ExperimentCookie> newExperimentCookies) {
        this.newExperimentCookies = newExperimentCookies;
    }
}

