/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.markup;

import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetExperiment;
import com.sdl.webapp.common.api.WebRequestContext;
import com.sdl.webapp.common.api.model.ViewModel;
import com.sdl.webapp.common.markup.MarkupDecorator;
import com.sdl.webapp.common.markup.html.HtmlNode;
import com.sdl.webapp.common.markup.html.builders.HtmlBuilders;
import com.sdl.webapp.common.markup.html.builders.SimpleElementBuilder;
import com.tridion.smarttarget.SmartTargetException;
import com.tridion.smarttarget.analytics.AnalyticsManager;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TrackingMarkupDecorator
implements MarkupDecorator {
    private static final Logger log = LoggerFactory.getLogger(TrackingMarkupDecorator.class);
    private AnalyticsManager analyticsManager;

    @PostConstruct
    public void init() {
        try {
            this.setAnalyticsManager(AnalyticsManager.getConfiguredAnalyticsManager());
        }
        catch (SmartTargetException e) {
            log.warn("Analytics manager for XO markup decorator can't be initialized. Do you have a proper configuration?", (Throwable)e);
        }
    }

    public HtmlNode process(HtmlNode markup, ViewModel model, WebRequestContext webRequestContext) {
        if (!(model instanceof SmartTargetExperiment)) {
            log.debug("Skip XO tracking markup, because model is not XO experiment");
            return markup;
        }
        if (this.analyticsManager == null) {
            log.info("Analytics manager for XO markup decorator is not initialized. Do you have a proper configuration?");
            return markup;
        }
        log.trace("Trying to add XO tracking markup, because model is an XO experiment");
        markup = ((SimpleElementBuilder)HtmlBuilders.empty().withPureHtmlContent(this.processMarkupByAnalytics(markup, model))).build();
        return markup;
    }

    public int getOrder() {
        return 1;
    }

    String processMarkupByAnalytics(HtmlNode markup, ViewModel model) {
        SmartTargetExperiment experiment = (SmartTargetExperiment)model;
        try {
            this.analyticsManager.trackView(experiment.getExperimentDimensions(), Collections.emptyMap());
            this.analyticsManager.trackConversion(experiment.getExperimentDimensions(), Collections.emptyMap());
            return this.analyticsManager.addTrackingToLinks(markup.toHtml(), experiment.getExperimentDimensions(), Collections.emptyMap());
        }
        catch (SmartTargetException e) {
            log.warn("Exception while adding tracking to experiment links", (Throwable)e);
            return markup.toHtml();
        }
    }

    public void setAnalyticsManager(AnalyticsManager analyticsManager) {
        this.analyticsManager = analyticsManager;
    }
}

