/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.mapping;

import com.google.common.base.Strings;
import com.sdl.dxa.api.datamodel.model.ContentModelData;
import com.sdl.dxa.api.datamodel.model.PageModelData;
import com.sdl.dxa.api.datamodel.model.RegionModelData;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetExperiment;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetItem;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetPageModel;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetPromotion;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetRegion;
import com.sdl.dxa.tridion.mapping.PageModelBuilder;
import com.sdl.webapp.common.api.WebRequestContext;
import com.sdl.webapp.common.api.localization.Localization;
import com.sdl.webapp.common.api.model.EntityModel;
import com.sdl.webapp.common.api.model.PageModel;
import com.sdl.webapp.common.api.model.mvcdata.DefaultsMvcData;
import com.sdl.webapp.common.api.model.mvcdata.MvcDataCreator;
import com.sdl.webapp.common.util.TcmUtils;
import com.tridion.ambientdata.AmbientDataContext;
import com.tridion.ambientdata.claimstore.ClaimStore;
import com.tridion.smarttarget.SmartTargetException;
import com.tridion.smarttarget.analytics.tracking.ExperimentDimensions;
import com.tridion.smarttarget.query.Experiment;
import com.tridion.smarttarget.query.ExperimentCookie;
import com.tridion.smarttarget.query.Item;
import com.tridion.smarttarget.query.Promotion;
import com.tridion.smarttarget.query.ResultSet;
import com.tridion.smarttarget.query.ResultSetImpl;
import com.tridion.smarttarget.query.builder.Criteria;
import com.tridion.smarttarget.query.builder.PageCriteria;
import com.tridion.smarttarget.query.builder.PublicationCriteria;
import com.tridion.smarttarget.query.builder.QueryBuilder;
import com.tridion.smarttarget.query.builder.RegionCriteria;
import com.tridion.smarttarget.utils.AmbientDataHelper;
import com.tridion.smarttarget.utils.CookieProcessor;
import com.tridion.smarttarget.utils.TcmUri;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class SmartTargetPageBuilder
implements Ordered,
PageModelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SmartTargetPageBuilder.class);
    private static final String DUPLICATION_ON_SAME_PAGE_KEY = "allowDuplicationOnSamePage";
    private static final String PROMOTION_VIEW_NAME_CONFIG = "smarttarget.smartTargetEntityPromotion";
    private final HttpServletRequest httpServletRequest;
    private final WebRequestContext webRequestContext;

    @Autowired
    public SmartTargetPageBuilder(HttpServletRequest httpServletRequest, WebRequestContext webRequestContext) {
        this.httpServletRequest = httpServletRequest;
        this.webRequestContext = webRequestContext;
    }

    private static void setMaxItems(String maxItems, SmartTargetRegion regionModel) {
        regionModel.setMaxItems(100);
        if (maxItems != null) {
            regionModel.setMaxItems((int)Double.parseDouble(maxItems));
        }
    }

    private static String getPromotionViewName(Localization localization) {
        String promotionViewName = localization.getConfiguration(PROMOTION_VIEW_NAME_CONFIG);
        if (Strings.isNullOrEmpty((String)promotionViewName)) {
            log.warn("No view name for SmartTarget promotions is configured in CM, {}", (Object)PROMOTION_VIEW_NAME_CONFIG);
            promotionViewName = "SmartTarget:Entity:Promotion";
        }
        return promotionViewName;
    }

    private static ExperimentDimensions getExperimentDimensions(Localization localization, SmartTargetPageModel stPageModel, String currentRegionName) {
        ExperimentDimensions experimentDimensions = new ExperimentDimensions();
        experimentDimensions.setPublicationId(TcmUtils.buildPublicationTcmUri((String)localization.getId()));
        experimentDimensions.setPageId(TcmUtils.buildPageTcmUri((Object)localization.getId(), (Object)stPageModel.getId()));
        experimentDimensions.setRegion(currentRegionName);
        return experimentDimensions;
    }

    private static void setXpmMetadataForStaging(Localization localization, String query, SmartTargetRegion smartTargetRegion) {
        if (localization.isStaging()) {
            HashMap<String, String> xpmMetadata = new HashMap<String, String>(1);
            xpmMetadata.put("Query", query);
            smartTargetRegion.setXpmMetadata(xpmMetadata);
        }
    }

    private static boolean isPromotionToSkip(SmartTargetRegion smartTargetRegion, Promotion promotion) {
        return !promotion.isVisible() || !promotion.supportsRegion(smartTargetRegion.getName());
    }

    private static void clearFallbackContentIfNeeded(SmartTargetRegion smartTargetRegion) {
        if (!smartTargetRegion.isFallbackContentReplaced()) {
            smartTargetRegion.setEntities(new ArrayList());
            smartTargetRegion.setFallbackContentReplaced(true);
        }
    }

    private static SmartTargetPromotion createPromotionEntity(Promotion promotion, String promotionViewName, String regionName, ExperimentDimensions experimentDimensions, Localization localization) throws SmartTargetException {
        SmartTargetPromotion smartTargetPromotion = promotion instanceof Experiment ? new SmartTargetExperiment(experimentDimensions) : new SmartTargetPromotion();
        smartTargetPromotion.setMvcData(MvcDataCreator.creator().defaults(DefaultsMvcData.ENTITY).mergeIn(MvcDataCreator.creator().fromQualifiedName(promotionViewName).create()).create());
        HashMap<String, String> xpmMetadata = new HashMap<String, String>(2);
        xpmMetadata.put("PromotionID", promotion.getPromotionId());
        xpmMetadata.put("RegionID", regionName);
        smartTargetPromotion.setXpmMetadata(xpmMetadata);
        smartTargetPromotion.setTitle(promotion.getTitle());
        smartTargetPromotion.setSlogan(promotion.getSlogan());
        smartTargetPromotion.setId(promotion.getPromotionId());
        ArrayList<SmartTargetItem> smartTargetItems = new ArrayList<SmartTargetItem>(promotion.getItems().size());
        for (Item item : promotion.getItems()) {
            if (!item.isVisible()) continue;
            int itemId = item.getComponentUri().getItemId();
            String id = String.format("%s-%s", itemId, item.getTemplateUri().getItemId());
            smartTargetItems.add(new SmartTargetItem(id, localization));
        }
        smartTargetPromotion.setItems(smartTargetItems);
        return smartTargetPromotion;
    }

    public PageModel buildPageModel(@Nullable PageModel pageModel, @NotNull PageModelData modelData) {
        if (pageModel == null || pageModel.getRegions() == null || !pageModel.getRegions().containsClass(SmartTargetRegion.class) || modelData.getRegions() == null) {
            log.debug("There are no SmartTargetRegions on the page {}", (Object)pageModel);
            return pageModel;
        }
        Localization localization = this.webRequestContext.getLocalization();
        String allowDuplicationOnSamePage = modelData.getMetadata() == null ? null : String.valueOf(modelData.getMetadata().get((Object)DUPLICATION_ON_SAME_PAGE_KEY));
        SmartTargetPageModel stPageModel = new SmartTargetPageModel(pageModel).setAllowDuplicates(this.getAllowDuplicatesFromConfig(allowDuplicationOnSamePage, localization));
        pageModel.getRegions().stream().filter(regionModel -> regionModel instanceof SmartTargetRegion).map(regionModel -> (SmartTargetRegion)((Object)regionModel)).forEach(regionModel -> {
            RegionModelData regionModelData = modelData.getRegions().stream().filter(rmd -> rmd.getName().equals(regionModel.getName())).findFirst().orElse(null);
            ContentModelData metadata = regionModelData == null ? null : regionModelData.getMetadata();
            String maxItems = metadata == null ? null : (String)metadata.getAndCast((Object)"maxItems", String.class);
            SmartTargetPageBuilder.setMaxItems(maxItems, regionModel);
        });
        String promotionViewName = SmartTargetPageBuilder.getPromotionViewName(localization);
        log.debug("Using promotion view name {}", (Object)promotionViewName);
        this.processQueryAndPromotions(localization, stPageModel, promotionViewName);
        return stPageModel;
    }

    private boolean getAllowDuplicatesFromConfig(String allowDuplicationOnSamePage, @NonNull Localization localization) {
        if (localization == null) {
            throw new NullPointerException("localization");
        }
        String _allowDuplicationOnSamePage = allowDuplicationOnSamePage;
        if ((StringUtils.isEmpty((CharSequence)_allowDuplicationOnSamePage) || "Use core configuration".equalsIgnoreCase(_allowDuplicationOnSamePage)) && Strings.isNullOrEmpty((String)(_allowDuplicationOnSamePage = localization.getConfiguration("smarttarget.allowDuplicationOnSamePageConfig")))) {
            return true;
        }
        return Boolean.parseBoolean(_allowDuplicationOnSamePage);
    }

    String getViewNameForRegion(String regionName, String viewName) {
        return Strings.isNullOrEmpty((String)regionName) ? MvcDataCreator.creator().fromQualifiedName(viewName).create().getViewName() : regionName;
    }

    private boolean filterResultSet(SmartTargetPageModel stPageModel, List<Promotion> promotions, SmartTargetRegion smartTargetRegion, List<String> itemsAlreadyOnPage, ExperimentDimensions experimentDimensions, ExperimentCookies experimentCookies) {
        try {
            ResultSetImpl.filterPromotions(promotions, (String)smartTargetRegion.getName(), (int)smartTargetRegion.getMaxItems(), (boolean)stPageModel.isAllowDuplicates(), new ArrayList(), itemsAlreadyOnPage, experimentCookies.existingCookies, experimentCookies.newCookies, (ExperimentDimensions)experimentDimensions);
        }
        catch (SmartTargetException e) {
            log.error("Smart target exception while filtering ResultSet from ST", (Throwable)e);
            return false;
        }
        return true;
    }

    void processQueryAndPromotions(Localization localization, SmartTargetPageModel stPageModel, String promotionViewName) {
        try {
            TcmUri pageUri = new TcmUri(TcmUtils.buildPageTcmUri((Object)localization.getId(), (Object)stPageModel.getId()));
            ResultSet resultSet = this.executeSmartTargetQuery(stPageModel, pageUri);
            if (resultSet == null) {
                log.warn("SmartTarget API returned null as a result for query. This can be because of timeout. Skipping processing promotions.");
                return;
            }
            List promotions = resultSet.getPromotions() == null ? Collections.emptyList() : resultSet.getPromotions();
            log.debug("SmartTarget query returned {} Promotions.", (Object)promotions.size());
            this.filterPromotionsForPage(localization, stPageModel, promotions, promotionViewName);
        }
        catch (SmartTargetException e) {
            log.error("Smart target exception", (Throwable)e);
        }
    }

    ResultSet executeSmartTargetQuery(SmartTargetPageModel stPageModel, TcmUri pageUri) throws SmartTargetException {
        TcmUri publicationUri = new TcmUri(TcmUtils.buildPublicationTcmUri((int)pageUri.getPublicationId()));
        ClaimStore claimStore = AmbientDataContext.getCurrentClaimStore();
        String triggers = AmbientDataHelper.getTriggers((ClaimStore)claimStore);
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.parseQueryString(triggers);
        queryBuilder.addCriteria((Criteria)new PublicationCriteria(publicationUri)).addCriteria((Criteria)new PageCriteria(pageUri));
        for (SmartTargetRegion region : stPageModel.getRegions().get(SmartTargetRegion.class)) {
            queryBuilder.addCriteria((Criteria)new RegionCriteria(region.getName()));
        }
        return queryBuilder.execute();
    }

    private void filterPromotionsForPage(Localization localization, SmartTargetPageModel stPageModel, List<Promotion> promotions, String promotionViewName) throws SmartTargetException {
        Map existingExperimentCookies = CookieProcessor.getExperimentCookies((ServletRequest)this.httpServletRequest);
        HashMap<String, ExperimentCookie> newExperimentCookies = new HashMap<String, ExperimentCookie>();
        ArrayList<String> itemsAlreadyOnPage = new ArrayList<String>();
        for (SmartTargetRegion smartTargetRegion : stPageModel.getRegions().get(SmartTargetRegion.class)) {
            String currentRegionName;
            ExperimentDimensions experimentDimensions;
            if (!this.filterResultSet(stPageModel, promotions, smartTargetRegion, itemsAlreadyOnPage, experimentDimensions = SmartTargetPageBuilder.getExperimentDimensions(localization, stPageModel, currentRegionName = smartTargetRegion.getName()), ExperimentCookies.builder().newCookies(newExperimentCookies).existingCookies(existingExperimentCookies).build())) {
                return;
            }
            SmartTargetPageBuilder.setXpmMetadataForStaging(localization, ResultSetImpl.getExperienceManagerMarkup((String)currentRegionName, (int)smartTargetRegion.getMaxItems(), promotions), smartTargetRegion);
            for (Promotion promotion : promotions) {
                if (SmartTargetPageBuilder.isPromotionToSkip(smartTargetRegion, promotion)) continue;
                SmartTargetPageBuilder.clearFallbackContentIfNeeded(smartTargetRegion);
                SmartTargetPromotion promotionEntity = SmartTargetPageBuilder.createPromotionEntity(promotion, promotionViewName, currentRegionName, experimentDimensions, localization);
                smartTargetRegion.addEntity((EntityModel)promotionEntity);
            }
        }
        stPageModel.setNewExperimentCookies(newExperimentCookies);
    }

    public int getOrder() {
        return 1000;
    }

    private static class ExperimentCookies {
        Map<String, ExperimentCookie> existingCookies;
        Map<String, ExperimentCookie> newCookies;

        ExperimentCookies(Map<String, ExperimentCookie> existingCookies, Map<String, ExperimentCookie> newCookies) {
            this.existingCookies = existingCookies;
            this.newCookies = newCookies;
        }

        public static ExperimentCookiesBuilder builder() {
            return new ExperimentCookiesBuilder();
        }

        public static class ExperimentCookiesBuilder {
            private Map<String, ExperimentCookie> existingCookies;
            private Map<String, ExperimentCookie> newCookies;

            ExperimentCookiesBuilder() {
            }

            public ExperimentCookiesBuilder existingCookies(Map<String, ExperimentCookie> existingCookies) {
                this.existingCookies = existingCookies;
                return this;
            }

            public ExperimentCookiesBuilder newCookies(Map<String, ExperimentCookie> newCookies) {
                this.newCookies = newCookies;
                return this;
            }

            public ExperimentCookies build() {
                return new ExperimentCookies(this.existingCookies, this.newCookies);
            }

            public String toString() {
                return "SmartTargetPageBuilder.ExperimentCookies.ExperimentCookiesBuilder(existingCookies=" + this.existingCookies + ", newCookies=" + this.newCookies + ")";
            }
        }
    }
}

