/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.background.RetentionWorker;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import java.util.concurrent.TimeUnit;

public class InitAppOpen {
    private static InitAppOpen instance = null;

    public static InitAppOpen getInstance() {
        if (instance == null) {
            instance = new InitAppOpen();
        }
        return instance;
    }

    public void checkAppOpen() {
        try {
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            long installTime = basicData.getFirstAppOpenTime();
            WiseLog.d("!!!! basicData before check install Time" + basicData);
            WiseLog.d("!!!! installTime " + installTime);
            if (installTime == 0L) {
                basicData.setFirstAppOpenTime(System.currentTimeMillis());
                basicData.setIsFirstAppOpen("Y");
                InitAppOpen.setBackgroundService();
            } else {
                basicData.setIsFirstAppOpen("N");
            }
            BasicDataManager.getInstance().saveBasicData(basicData);
            WiseLog.d("!!!! basicData after check install Time" + basicData);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    private static void setBackgroundService() {
        PeriodicWorkRequest periodicWorkRequest = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(RetentionWorker.class, 24L, TimeUnit.HOURS).addTag("RETENTION")).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).build();
        WorkManager.getInstance().enqueue((WorkRequest)periodicWorkRequest);
    }
}

