package com.sdk.wisetracker.base.tracker.util;

import android.text.TextUtils;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.util.Calendar;

/**
 * 시간 정보 설정 util class
 */
public class TimeUtil {

    private static TimeUtil instance = null;

    public static TimeUtil getInstance() {
        if (instance == null) {
            instance = new TimeUtil();
        }
        return instance;
    }

    public static final int SECOND_MILLIS = 1000;
    public static final int MINUTE_MILLIS = 60 * SECOND_MILLIS;
    public static final int HOUR_MILLIS = 60 * MINUTE_MILLIS;
    public static final int DAY_MILLIS = 24 * HOUR_MILLIS;
    private int EXPIRE_DATE = 14;

    public int dailyTerm(long time) {
        return time == 0 ? 0 : (int) ((System.currentTimeMillis() - time) / TimeUtil.DAY_MILLIS);
    }

    public boolean newSession(long time) {
        return time == 0 || (int) ((System.currentTimeMillis() - time) / TimeUtil.MINUTE_MILLIS) > 30;
    }

    public void setExpireDate(String expireDate) {
        try {
            if (TextUtils.isEmpty(expireDate)) {
                return;
            }
            this.EXPIRE_DATE = Integer.valueOf(expireDate);
        } catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public boolean isExpire(long time) {
        if (time == 0) {
            return false;
        } else {
            long currentTime = System.currentTimeMillis();
            return ((currentTime - time) / DAY_MILLIS) >= EXPIRE_DATE;
        }
    }

    public int getDay(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int day = calendar.get(Calendar.DAY_OF_MONTH);
        return day;
    }

    public int getDayOfWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int week = calendar.get(Calendar.DAY_OF_WEEK);
        return week;
    }

    public int getWeekOfMonth(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int weekOfMonth = calendar.get(Calendar.WEEK_OF_MONTH);
        return weekOfMonth;
    }

    public int getMonth(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int month = calendar.get(Calendar.MONTH) + 1;
        return month;
    }

}
