package com.sdk.wisetracker.base.tracker.data.init;

import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.background.RetentionWorker;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;

import java.util.concurrent.TimeUnit;

/**
 * 앱 최초 실행 여부에 따라 리텐션 전송 JOB 추가 (최초 실행시에만 등록)
 */
public class InitAppOpen {

    private static InitAppOpen instance = null;

    public static InitAppOpen getInstance() {
        if (instance == null) {
            instance = new InitAppOpen();
        }
        return instance;
    }

    public void checkAppOpen() {
        try {
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            long installTime = basicData.getFirstAppOpenTime();
            WiseLog.d("!!!! basicData before check install Time" + basicData);
            WiseLog.d("!!!! installTime " + installTime);
            if (installTime == 0) {
                basicData.setFirstAppOpenTime(System.currentTimeMillis());
                basicData.setIsFirstAppOpen("Y");
                setBackgroundService();
            } else {
                basicData.setIsFirstAppOpen("N");
            }
            BasicDataManager.getInstance().saveBasicData(basicData);
            WiseLog.d("!!!! basicData after check install Time" + basicData);
        } catch (Exception e) {
            WiseLog.e(e);
        }
    }

    /**
     * 리텐션 Job 등록
     * Todo 리텐션 동작 확인을 위해 15분마다 리텐션 데이터 전송. SDK 배포시 24시간마다 전송되도록 수정 필요
     */
    private static void setBackgroundService() {
        PeriodicWorkRequest periodicWorkRequest = new PeriodicWorkRequest.Builder(RetentionWorker.class, 24, TimeUnit.HOURS)
                .addTag("RETENTION")
                .setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())
                .build();
        WorkManager.getInstance().enqueue(periodicWorkRequest);
        /*  add background service for retention
        WorkManager.getInstance().enqueue(new OneTimeWorkRequest.Builder(RetentionWorker.class)
                .setInitialDelay(1440, TimeUnit.MINUTES)
                .setConstraints(new Constraints.Builder()
                        .setRequiredNetworkType(NetworkType.CONNECTED)
                        .build())
                .build());
        */
    }

}
