/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BaseDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.FingerPrintDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.util.ValueOf;
import java.util.Iterator;
import java.util.Set;

public class DeepLinkDataManager
extends BaseDataManager {
    private static DeepLinkDataManager instance = null;

    public static DeepLinkDataManager getInstance() {
        if (instance == null) {
            instance = new DeepLinkDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
        this.checkValidation();
    }

    @Override
    public void afterTransaction() {
        this.session.setOpenDeepLink(null);
        this.session.setDeepLinkReferrer(null);
        super.afterTransaction();
    }

    private void checkValidation() {
        try {
            String source = this.session.getAdSource();
            String campaign = this.session.getAdCampaign();
            if (TextUtils.isEmpty((CharSequence)source) || TextUtils.isEmpty((CharSequence)campaign)) {
                return;
            }
            long adClickTime = this.session.getAdClickTime();
            int adExpireDay = this.session.getAdExpireDay();
            if (adClickTime == 0L || adExpireDay == 0) {
                this.resetDeepLink();
                return;
            }
            long expireTime = adClickTime + (long)(86400000 * adExpireDay);
            if (expireTime < System.currentTimeMillis()) {
                this.resetDeepLink();
                return;
            }
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public void openDeepLink(Intent intent) {
        try {
            Uri referrer;
            if (intent == null || intent.getData() == null || TextUtils.isEmpty((CharSequence)intent.getData().toString())) {
                return;
            }
            Uri uri = intent.getData();
            Bundle bundle = intent.getExtras();
            if (bundle != null && bundle.containsKey("android.intent.extra.REFERRER") && (referrer = (Uri)bundle.get("android.intent.extra.REFERRER")) != null) {
                this.setDeepLink(uri.toString(), referrer.toString());
                return;
            }
            String referrerName = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
            if (!TextUtils.isEmpty((CharSequence)referrerName)) {
                this.setDeepLink(uri.toString(), Uri.parse((String)referrerName).toString());
                return;
            }
            this.setDeepLink(uri.toString(), null);
        }
        catch (Exception e) {
            WiseLog.e("open deep link error", e);
        }
    }

    public void openDeepLink(String deepLinkUrl) {
        this.setDeepLink(deepLinkUrl, null);
    }

    private void setDeepLink(String deepLinkUri, String openReferrer) {
        this.session.setOpenDeepLink(deepLinkUri);
        WiseLog.d("basicData.getIsFirstOpenInSession()  : " + this.basicData.getIsFirstOpenInSession());
        WiseLog.d("deep link url : " + deepLinkUri);
        WiseLog.d("open referrer : " + (!TextUtils.isEmpty((CharSequence)openReferrer) ? openReferrer : "empty"));
        if (deepLinkUri.contains("wtc") && deepLinkUri.contains("wts")) {
            long expireTime;
            this.resetDeepLink();
            Uri uri = Uri.parse((String)deepLinkUri);
            Set queryParameters = uri.getQueryParameterNames();
            Iterator iterator = queryParameters.iterator();
            while (iterator.hasNext()) {
                String name;
                switch (name = (String)iterator.next()) {
                    case "_wts": {
                        this.session.setAdSource(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallSource(uri.getQueryParameter(name));
                        this.session.setInstallReferrer(deepLinkUri);
                        this.session.setIsReferrerUpdate("Y");
                        break;
                    }
                    case "_wtm": {
                        this.session.setAdType(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallType(uri.getQueryParameter(name));
                        break;
                    }
                    case "_wtc": {
                        this.session.setAdCampaign(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallCampaign(uri.getQueryParameter(name));
                        break;
                    }
                    case "_wtw": {
                        this.session.setAdKeyword(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallKeyword(uri.getQueryParameter(name));
                        break;
                    }
                    case "_wtclkTime": {
                        this.session.setAdClickTime(ValueOf.longValue(uri.getQueryParameter(name)));
                        WiseLog.d("WTCLKTIME in setDeepLink :" + ValueOf.longValue(uri.getQueryParameter(name)));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallClickTime(ValueOf.longValue(uri.getQueryParameter(name)));
                        break;
                    }
                    case "_wtp": {
                        this.session.setAdExpireDay(ValueOf.intValue(uri.getQueryParameter(name)));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setAdInstallExpireTime(ValueOf.intValue(uri.getQueryParameter(name)));
                        break;
                    }
                    case "_wtaffid": {
                        this.session.setDepth1(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setInstallDepth1(uri.getQueryParameter(name));
                        break;
                    }
                    case "_wtbffid": {
                        this.session.setDepth2(uri.getQueryParameter(name));
                        if (!BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") || !this.basicData.getIsFirstOpenInSession()) break;
                        this.session.setInstallDepth2(uri.getQueryParameter(name));
                        break;
                    }
                    case "_wgcmpid": {
                        this.session.setGoogleCampaignId(uri.getQueryParameter(name));
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)this.session.getAdSource()) || TextUtils.isEmpty((CharSequence)this.session.getAdCampaign())) {
                WiseLog.d("deep link doesn't have primary key");
                this.resetDeepLink();
                return;
            }
            if (this.session.getAdClickTime() == 0L) {
                this.session.setAdClickTime(System.currentTimeMillis());
            }
            if (BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y") && this.basicData.getIsFirstOpenInSession() && this.session.getAdInstallSource() != null && !this.session.getAdInstallSource().equals("") && this.session.getAdInstallClickTime() == 0L) {
                this.session.setAdInstallClickTime(System.currentTimeMillis());
            }
            if ((expireTime = this.session.getAdClickTime() + (long)(86400000 * Integer.valueOf(this.session.getAdExpireDay()))) < System.currentTimeMillis()) {
                WiseLog.d("invalid deep link referrer");
                this.resetDeepLink();
                return;
            }
            this.session.setIsDeepLinkUpdate("Y");
            this.session.setAdLinkUrl(deepLinkUri);
            this.session.setDeepLinkReferrer(openReferrer);
            SessionDataManager.deepLinkSubject.onNext((Object)true);
        } else {
            FingerPrintDataManager.getInstance().loadFingerPrintByDeepLink();
        }
    }

    private void resetDeepLink() {
        this.session.setAdSource(null);
        this.session.setAdType(null);
        this.session.setAdCampaign(null);
        this.session.setAdKeyword(null);
        this.session.setAdClickTime(0L);
        this.session.setAdExpireDay(0);
        this.session.setDepth1(null);
        this.session.setDepth2(null);
        this.session.setGoogleCampaignId(null);
    }
}

