/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.common.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Log;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.common.network.IConnection;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;

public class ConnectHelper {
    private static ConnectHelper instance = null;
    private Context context = null;

    public static ConnectHelper getInstance() {
        if (instance == null) {
            instance = new ConnectHelper();
        }
        return instance;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @SuppressLint(value={"CheckResult"})
    public void networkStatus(final String TAG, final IConnection iConnection) {
        Observable<Boolean> o1 = this.checkNetworkConnection(TAG);
        Observable<Boolean> o2 = this.checkNetworkStatus(TAG);
        Observable.zip(o1, o2, (BiFunction)new BiFunction<Boolean, Boolean, Boolean>(){

            public Boolean apply(Boolean aBoolean, Boolean aBoolean2) {
                if (!aBoolean.booleanValue() || !aBoolean2.booleanValue()) {
                    return false;
                }
                return true;
            }
        }).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean isConnect) {
                if (iConnection != null) {
                    iConnection.onConnection(isConnect);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                Log.e((String)TAG, (String)"check network status zip error !!", (Throwable)throwable);
            }
        });
    }

    private Observable<Boolean> checkNetworkConnection(String TAG) {
        return Observable.timer((long)100L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap((Function)new Function<Long, ObservableSource<String>>(){

            public ObservableSource<String> apply(Long aLong) {
                try {
                    if (ConnectHelper.this.context == null) {
                        return Observable.just((Object)"context is null");
                    }
                    ConnectivityManager connectivityManager = (ConnectivityManager)ConnectHelper.this.context.getSystemService("connectivity");
                    if (connectivityManager == null) {
                        return Observable.just((Object)"connectivityManager is null");
                    }
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    if (networkInfo == null) {
                        return Observable.just((Object)"network info is null");
                    }
                    if (networkInfo.isConnected()) {
                        return Observable.just((Object)"");
                    }
                    return Observable.just((Object)"network connection false");
                }
                catch (Exception e) {
                    return Observable.just((Object)e.getMessage());
                }
            }
        }).observeOn(AndroidSchedulers.mainThread()).flatMap((Function)new Function<String, ObservableSource<Boolean>>(){

            public ObservableSource<Boolean> apply(String message) {
                if (TextUtils.isEmpty((CharSequence)message)) {
                    WiseLog.d("network connection check true");
                    return Observable.just((Object)true);
                }
                WiseLog.d("network connection check : " + message);
                return Observable.just((Object)false);
            }
        });
    }

    private Observable<Boolean> checkNetworkStatus(String TAG) {
        return Observable.timer((long)100L, (TimeUnit)TimeUnit.MILLISECONDS).flatMap((Function)new Function<Long, ObservableSource<String>>(){

            public ObservableSource<String> apply(Long aLong) {
                try {
                    String proxyUrl = System.getProperty("http.proxyHost");
                    if (TextUtils.isEmpty((CharSequence)proxyUrl)) {
                        WiseLog.d("doesn't have http.proxyHost data");
                        return Observable.just((Object)"");
                    }
                    WiseLog.d("proxy url : " + proxyUrl);
                    URL myUrl = new URL("http://" + proxyUrl);
                    URLConnection connection = myUrl.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.connect();
                    return Observable.just((Object)"");
                }
                catch (MalformedURLException e) {
                    return Observable.just((Object)e.getMessage());
                }
                catch (IOException e) {
                    return Observable.just((Object)e.getMessage());
                }
                catch (Exception e) {
                    return Observable.just((Object)e.getMessage());
                }
            }
        }).observeOn(AndroidSchedulers.mainThread()).flatMap((Function)new Function<String, ObservableSource<Boolean>>(){

            public ObservableSource<Boolean> apply(String message) {
                if (TextUtils.isEmpty((CharSequence)message)) {
                    WiseLog.d("proxy network check true");
                    return Observable.just((Object)true);
                }
                WiseLog.d("proxy network check : " + message);
                return Observable.just((Object)false);
            }
        });
    }
}

