package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.util.Iterator;
import java.util.Set;

public class SupportManager {

    private final String TAG = "SupportManager";
    private static SupportManager instance = null;
    private String supportUrl = null;

    public static SupportManager getInstance() {
        if (instance == null) {
            instance = new SupportManager();
        }
        return instance;
    }

    public void setSupportUrl(Intent intent) {

        try {

            WiseLog.d("set support url");

            if (intent == null) {
                return;
            }

            String url = intent.getData().toString();
            WiseLog.d("url : " + url);
            if (TextUtils.isEmpty(url)) {
                return;
            }
            Uri uri = Uri.parse(url);
            Set<String> queryParameters = uri.getQueryParameterNames();
            if (queryParameters == null || queryParameters.isEmpty()) {
                WiseLog.d("query param is null or empty");
                return;
            }

            Iterator<String> iterator = queryParameters.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (TextUtils.isEmpty(key)) {
                    WiseLog.d("key is empty");
                    continue;
                }
                WiseLog.d("key : " + key);
                switch (key) {
                    case "apiUrl":
                        supportUrl = uri.getQueryParameter(key);
                }
            }
            WiseLog.d("support url : " + supportUrl);

        } catch (Exception e) {
            Log.e("SupportManager", "set support url error !!", e);
        }

    }

    public String getSupportUrl() {
        return supportUrl;
    }

}
