package com.sdk.wisetracker.base.tracker.data.manager;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.text.TextUtils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sdk.wisetracker.base.open.model.Push;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.model.Const;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.SessionRetrofit;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import com.sdk.wisetracker.base.tracker.util.TimeUtil;

import java.util.Map;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/**
 * 푸시 수신시 세션에 푸시 정보 추가 class
 */
public class PushDataManager extends BaseDataManager {

    private static PushDataManager instance = null;

    public static PushDataManager getInstance() {
        if (instance == null) {
            instance = new PushDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
        setPushData();
    }

    @Override
    public void afterTransaction() {
        session.setPushTitle(null);
        session.setIsNewPushToken("N");
        super.afterTransaction();
    }

    private void setPushData() {
        long expireTime = session.getPushExpireTime();
        long clickTime = session.getPushClickTime();
        if (clickTime + (TimeUtil.DAY_MILLIS * expireTime) <= System.currentTimeMillis()) {
            session.setPushId(null);
            session.setPushExpireTime(0);
            session.setPushClickTime(0);
        }
    }

    public void setPushClick(Intent intent) {
        try {
            if (intent == null) {
                WiseLog.d("intent is null");
                return;
            }
            // ######################################################################
            // Extra data parsing block
            if (intent.getParcelableExtra(Push.class.getSimpleName()) != null) {
                Push push = intent.getParcelableExtra(Push.class.getSimpleName());
                String pushId = push.getCampaignId() + "#" + push.getId();
                session.setPushId(pushId);
                session.setPushTitle(push.getTitle());
                session.setPushExpireTime(push.getExpireTime() == 0 ? session.getExpireDate() : push.getExpireTime());
                session.setPushClickTime(System.currentTimeMillis());
            }else{
                String _extraDataString = intent.getStringExtra(Const.PUSH_EXTRA_DATA);
                if( _extraDataString != null && !_extraDataString.equals("")){
                    try{
                        JsonParser parser = new JsonParser();
                        JsonObject _extraData = (JsonObject)parser.parse(_extraDataString);
                        if( _extraData != null && _extraData.size() > 0 ){
                            if( _extraData.has(Const.PUSH_ID) && _extraData.has(Const.PUSH_CAMPAIGN_ID) ){
                                String id =  _extraData.get(Const.PUSH_ID).getAsString();
                                String campaignId =  _extraData.get(Const.PUSH_CAMPAIGN_ID).getAsString();
                                String title =  _extraData.get(Const.PUSH_TITLE).getAsString();
                                if (TextUtils.isEmpty(title)) {
                                    String body =  _extraData.get(Const.PUSH_BODY).getAsString();
                                    title = body.substring(0, 128);
                                    title = title.replaceAll("'", "");
                                    title = title.replaceAll("\"", "");
                                }
                                String pushId = campaignId + "#" + id;
                                session.setPushId(pushId);
                                session.setPushTitle(title);
                                session.setPushClickTime(System.currentTimeMillis());
                                session.setPushExpireTime(session.getExpireDate());
                                if(_extraData.has(Const.PUSH_EXPIRE_TIME)){
                                    int period = Integer.parseInt(String.valueOf(_extraData.get(Const.PUSH_EXPIRE_TIME).getAsString()));
                                    session.setPushExpireTime( period == 0 ? session.getExpireDate(): period );
                                }
                            }
                        }
                    }catch(Exception e){
                        WiseLog.e("Notification Extra Data Error", e);
                    }
                }
            }
            // ######################################################################
        } catch (Exception e) {
            WiseLog.e("set alarm link data error !! ", e);
        }

    }

    public void setPushReceiverId(Intent intent) {

        try {

            if (intent == null) {
                WiseLog.d("intent is null");
                return;
            }

            // ######################################################################
            // Extra data parsing block
            if (intent.getParcelableExtra(Push.class.getSimpleName()) != null) {
                Push push = intent.getParcelableExtra(Push.class.getSimpleName());
                String id = push.getCampaignId() + "#" + push.getId();
                sendPushId(id);
            }else{
                String _extraDataString = intent.getStringExtra(Const.PUSH_EXTRA_DATA);
                if( _extraDataString != null && !_extraDataString.equals("")){
                    try{
                        JsonParser parser = new JsonParser();
                        JsonObject _extraData = (JsonObject)parser.parse(_extraDataString);
                        if( _extraData != null && _extraData.size() > 0 ){
                            if( _extraData.has(Const.PUSH_ID) && _extraData.has(Const.PUSH_CAMPAIGN_ID) ){
                                String campaignID =  _extraData.get(Const.PUSH_CAMPAIGN_ID).getAsString();
                                String pushId =  _extraData.get(Const.PUSH_ID).getAsString();
                                String id = campaignID + "#" + pushId;
                                sendPushId(id);
                            }
                        }
                    }catch(Exception e){
                        WiseLog.e("Notification Extra Data Error", e);
                    }
                }
            }
            // ######################################################################

        } catch (Exception e) {
            WiseLog.e(e);
        }

    }

    @SuppressLint("CheckResult")
    private void sendPushId(String id) {
        Session session = SessionDataManager.getInstance().getSession();
        String serviceNumber = String.valueOf(session.getServiceNumber());
        String adId = session.getAdId();
        String uuid = session.getUuid();
        SessionApi api = SessionRetrofit.getInstance().getBaseApi(SessionApi.class, HeaderType.DOT);
        api.sendReceivedPush(serviceNumber, adId, uuid, id, System.currentTimeMillis())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Consumer<JsonObject>() {
                               @Override
                               public void accept(JsonObject jsonObject) {
                                   WiseLog.d("success");
                               }
                           },
                        new Consumer<Throwable>() {
                            @Override
                            public void accept(Throwable throwable) {
                                WiseLog.e(throwable);
                            }
                        });
    }

    public void setPushToken(String token) {
        if (TextUtils.isEmpty(session.getPushToken())) {
            session.setIsNewPushToken("Y");
        } else if (!session.getPushToken().equals(token)) {
            session.setIsNewPushToken("Y");
        }
        session.setPushToken(token);
    }

}
