/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class InitEnvironment {
    private static InitEnvironment instance = null;
    private Context context;
    private Session session = SessionDataManager.getInstance().getSession();

    public static InitEnvironment getInstance() {
        if (instance == null) {
            instance = new InitEnvironment();
        }
        return instance;
    }

    public void setEnvironment(Context context) {
        this.context = context;
        this.setLanguage();
        this.setCountry();
        this.setTimeZone();
        this.setOs();
        this.setResolution();
        this.setDeviceModel();
        this.setPackageInfo();
        this.setGps();
        this.setCarriers();
        this.setNetworkInfo();
        this.setInch();
        this.setUuid();
        this.setDeviceUuid();
        this.setVendorId();
        this.setSDKVersion();
        this.saveSession();
    }

    private void saveSession() {
        SessionDataManager.getInstance().saveSession(this.session);
    }

    private void setLanguage() {
        Locale locale = this.context.getResources().getConfiguration().locale;
        this.session.setLanguage(locale.getLanguage());
    }

    private void setCountry() {
        Locale locale = this.context.getResources().getConfiguration().locale;
        String country = locale.getCountry();
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        if (telephonyManager != null && !TextUtils.isEmpty((CharSequence)telephonyManager.getSimCountryIso())) {
            country = telephonyManager.getSimCountryIso();
        }
        this.session.setCountry(country.toUpperCase());
    }

    private void setTimeZone() {
        GregorianCalendar mCalendar = new GregorianCalendar();
        TimeZone mTimeZone = ((Calendar)mCalendar).getTimeZone();
        int mGMTOffset = mTimeZone.getRawOffset();
        this.session.setTimeZone(String.valueOf(TimeUnit.HOURS.convert(mGMTOffset, TimeUnit.MILLISECONDS)));
    }

    private void setOs() {
        try {
            Field[] fields = Build.VERSION_CODES.class.getFields();
            String osName = fields[Build.VERSION.SDK_INT + 1].getName();
            this.session.setOs("Android " + osName + " (" + String.valueOf(Build.VERSION.SDK_INT) + ")");
        }
        catch (Exception e) {
            this.session.setOs("Android  (" + String.valueOf(Build.VERSION.SDK_INT) + ")");
        }
    }

    private void setResolution() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(displayMetrics);
        int deviceDensityDIP = displayMetrics.densityDpi;
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        String resolution = String.valueOf(width) + "*" + String.valueOf(height);
        this.session.setResolution(resolution);
    }

    private void setDeviceModel() {
        this.session.setDeviceModel(Build.MODEL);
    }

    private void setPackageInfo() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            this.session.setAppVersion(packageInfo.versionName);
            this.session.setAppInstallTime(packageInfo.firstInstallTime);
            this.session.setAppUpdateTime(packageInfo.lastUpdateTime);
            this.session.setPackageName(packageInfo.packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            WiseLog.d("set package name not found exception !! " + e.getMessage());
        }
        catch (Exception e) {
            WiseLog.d("set app version error !! " + e.getMessage());
        }
    }

    private void setGps() {
        try {
            LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
            boolean isGps = locationManager == null ? false : locationManager.isProviderEnabled("gps");
            this.session.setGps(isGps ? "Y" : "N");
        }
        catch (SecurityException e) {
            this.session.setGps("N");
            WiseLog.d("set gps security exception error !! " + e.getMessage());
        }
        catch (Exception e) {
            this.session.setGps("N");
            WiseLog.d("set gps exception error !! " + e.getMessage());
        }
    }

    private void setCarriers() {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
            if (telephonyManager == null) {
                return;
            }
            String carriers = telephonyManager.getSimOperatorName();
            this.session.setCarriers(carriers);
        }
        catch (Exception e) {
            WiseLog.d("set carriers error !! " + e.getMessage());
        }
    }

    private boolean checkSelfPermission(String permission2) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                return this.context.checkSelfPermission(permission2) == 0;
            }
            return true;
        }
        catch (Exception e) {
            WiseLog.e("check : " + permission2 + "self permission error !!", e);
            return false;
        }
    }

    private void setNetworkInfo() {
        if (!this.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            return;
        }
        try {
            int isWifi = 0;
            ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo info = connectivityManager.getActiveNetworkInfo();
            if (info != null && info.isConnected()) {
                if (info.getType() == 0) {
                    isWifi = 1;
                } else if (info.getType() == 1) {
                    isWifi = 2;
                }
            }
            this.session.setNetworkType(isWifi);
        }
        catch (Exception e) {
            WiseLog.e("set network info error !!", e);
        }
    }

    private void setInch() {
        DisplayMetrics matrix = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(matrix);
        int w = matrix.widthPixels;
        int h = matrix.heightPixels;
        float density = matrix.density;
        float xdpi = matrix.xdpi;
        float ydpi = matrix.ydpi;
        float x_inch = (float)w / xdpi;
        float y_inch = (float)h / ydpi;
        double display = Math.sqrt(x_inch * x_inch + y_inch * y_inch);
        this.session.setInch(Math.round(display * 10.0) / 10L);
    }

    private void setUuid() {
        String uuid = this.session.getUuid();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
        }
        this.session.setUuid(uuid);
    }

    private void setDeviceUuid() {
        if (!this.checkSelfPermission("android.permission.READ_PHONE_STATE")) {
            return;
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
            if (telephonyManager == null) {
                return;
            }
            String deviceUuid = Build.VERSION.SDK_INT >= 26 ? telephonyManager.getImei() : telephonyManager.getDeviceId();
            if (TextUtils.isEmpty((CharSequence)deviceUuid)) {
                return;
            }
            this.session.setDeviceUuid(deviceUuid);
        }
        catch (Exception e) {
            WiseLog.e("set device uuid error", e);
        }
    }

    private void setVendorId() {
        try {
            String vendorId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
            if (TextUtils.isEmpty((CharSequence)vendorId)) {
                return;
            }
            this.session.setVendorId(vendorId);
        }
        catch (Exception e) {
            WiseLog.e("set vendor id error", e);
        }
    }

    public void setSDKVersion() {
        HashMap<String, String> sdkVersionMap = new HashMap<String, String>();
        sdkVersionMap.put("SESSION", "1.0.17");
        this.session.setSdkVersion(sdkVersionMap);
    }
}

